/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.intercept;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.intercept.InterceptStatModel;
import cn.com.duiba.nezha.alg.alg.vo.intercept.ActInterceptRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.intercept.PreSelectPlugInterceptDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.ActInterceptFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.PlugInterceptStatDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlugInterceptDQNRcmder {
    private static final Logger logger = LoggerFactory.getLogger(PlugInterceptDQNRcmder.class);
    private static long ADX_MULTIPLIER = 10000000L;
    private static int MAP_DF_SIZE = 8;
    static double[] pCpmBucket = new double[]{0.5, 0.8, 0.9, 0.95, 0.99, 1.0};
    static double[] pCpmWeight = new double[]{0.1, 1.0, 2.0, 2.0, 5.0, 100.0};

    public static Map<String, String> featureParse(ActInterceptFeatureDo actFeatureDo, Double rpm) {
        Map staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic((ActInterceptFeatureDo)actFeatureDo);
        Map dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamicPlug((ActInterceptFeatureDo)actFeatureDo, (ActInterceptFeatureDo)actFeatureDo, (Double)rpm);
        dynamicFeatureMap.putAll(staticFeatureMap);
        return dynamicFeatureMap;
    }

    public static ActInterceptRcmdDo rcmd(CODER coderModel, LocalTFModel ltfModel, List<Long> plugInterceptDoList, List<PreSelectPlugInterceptDo> preSelectPlugInterceptDoList, Map<Long, PlugInterceptStatDo> plugInterceptStatDoMap, ActInterceptFeatureDo actFeatureDo) throws Exception {
        ActInterceptRcmdDo ret = null;
        if (PlugInterceptDQNRcmder.valid(plugInterceptDoList, actFeatureDo).booleanValue()) {
            HashMap<Long, Map> featureMap = new HashMap<Long, Map>();
            Map<Long, PreSelectPlugInterceptDo> plugInterceptSelectDoListMap = PlugInterceptDQNRcmder.getLastSelect(preSelectPlugInterceptDoList);
            if (plugInterceptStatDoMap == null) {
                plugInterceptStatDoMap = new HashMap<Long, PlugInterceptStatDo>();
            }
            Map staticFeatureMap = ActInterceptFeatureParse.generateFeatureMapStatic((ActInterceptFeatureDo)actFeatureDo);
            ArrayList<ActInterceptRcmdDo> actRcmdDoList = new ArrayList<ActInterceptRcmdDo>();
            for (Long plugId : plugInterceptDoList) {
                ActInterceptFeatureDo dynamicDo = new ActInterceptFeatureDo();
                dynamicDo.setPlugId(plugId);
                PlugInterceptStatDo plugInterceptStatDo = plugInterceptStatDoMap.get(plugId);
                Double rpm = InterceptStatModel.getRpm(plugInterceptStatDo);
                Map dynamicFeatureMap = ActInterceptFeatureParse.generateFeatureMapDynamicPlug((ActInterceptFeatureDo)dynamicDo, (ActInterceptFeatureDo)actFeatureDo, (Double)rpm);
                dynamicFeatureMap.putAll(staticFeatureMap);
                featureMap.put(plugId, dynamicFeatureMap);
            }
            Map pRpmMap = new HashMap();
            if (PlugInterceptDQNRcmder.validModel(coderModel, ltfModel).booleanValue()) {
                pRpmMap = coderModel.predictWithLocalTF(featureMap, ltfModel);
            }
            for (Long plugId : plugInterceptDoList) {
                ActInterceptRcmdDo interceptRcmdDo = new ActInterceptRcmdDo();
                interceptRcmdDo.setKey(plugId + "");
                interceptRcmdDo.setPlugId(plugId);
                interceptRcmdDo.setInterceptContentType(2L);
                if (plugInterceptSelectDoListMap.containsKey(plugId)) {
                    interceptRcmdDo.setHasType(true);
                } else {
                    interceptRcmdDo.setHasType(false);
                }
                PlugInterceptStatDo plugInterceptStatDo = plugInterceptStatDoMap.get(plugId);
                interceptRcmdDo.setsRpm(InterceptStatModel.getRpm(plugInterceptStatDo));
                Double pRpm = (Double)pRpmMap.get(plugId);
                interceptRcmdDo.setpRpm(pRpm);
                Double mergeRpm = PlugInterceptDQNRcmder.getMergeRpm(interceptRcmdDo);
                interceptRcmdDo.setMergeRpm(mergeRpm);
                actRcmdDoList.add(interceptRcmdDo);
            }
            ret = PlugInterceptDQNRcmder.rcmd(actRcmdDoList);
        }
        return ret;
    }

    public static ActInterceptRcmdDo rcmd(List<ActInterceptRcmdDo> rcmdList) {
        Double weight;
        ActInterceptRcmdDo ret = null;
        if (AssertUtil.isEmpty(rcmdList)) {
            return ret;
        }
        long size = rcmdList.size();
        Double bestRpm = null;
        String bestRpmKey = null;
        if (size == 1L) {
            return rcmdList.get(0);
        }
        int i = 0;
        while ((long)i < size) {
            ActInterceptRcmdDo plugDo = rcmdList.get(i);
            Double rpm = plugDo.getMergeRpm();
            if (rpm != null && (bestRpm == null || bestRpm < rpm)) {
                bestRpm = rpm;
                bestRpmKey = plugDo.getKey();
            }
            ++i;
        }
        HashMap<ActInterceptRcmdDo, Double> weightMap = new HashMap<ActInterceptRcmdDo, Double>(MAP_DF_SIZE);
        Double weightSum = 0.0;
        int i2 = 0;
        while ((long)i2 < size) {
            ActInterceptRcmdDo rcmdDo = rcmdList.get(i2);
            Double rpm = rcmdDo.getMergeRpm();
            weight = PlugInterceptDQNRcmder.getRpmWeight(rpm, bestRpm);
            weight = 1.0;
            weightSum = weightSum + weight;
            weightMap.put(rcmdDo, weight);
            ++i2;
        }
        for (Map.Entry entry : weightMap.entrySet()) {
            ActInterceptRcmdDo rcmdDo = (ActInterceptRcmdDo)entry.getKey();
            weight = (Double)entry.getValue();
            if (bestRpmKey == null || !bestRpmKey.equals(rcmdDo.getKey()) || !(weight < weightSum * 0.85)) continue;
            Double weightOther = weightSum - weight;
            weight = weightOther * 0.85 / 0.15000000000000002;
            weightSum = weightOther + weight;
            weightMap.put(rcmdDo, weight);
        }
        ret = (ActInterceptRcmdDo)Roulette.doubleMap(weightMap);
        return ret;
    }

    private static Double getMergeRpm(ActInterceptRcmdDo actRcmdDo) {
        Double ret = null;
        if (actRcmdDo != null) {
            Double actSRpm = actRcmdDo.getsRpm();
            Double pRpm = actRcmdDo.getpRpm();
            if (pRpm == null) {
                return ret;
            }
            ret = pRpm;
            if (actSRpm == null) {
                actSRpm = pRpm;
            }
            ret = 0.8 * pRpm + 0.2 * actSRpm;
        }
        return ret;
    }

    private static Double getRpmWeight(Double rpm, Double bestRpm) {
        Double ret = 0.001;
        if (rpm != null && bestRpm != null) {
            Double ratio = DataUtil.division((Double)rpm, (Double)bestRpm, (int)3);
            if (bestRpm >= 0.0) {
                ret = MathBase.getConfidenceWeight(Math.min(ratio, 1.0), pCpmBucket, pCpmWeight);
            }
        }
        return ret;
    }

    public static Map<Long, PreSelectPlugInterceptDo> getLastSelect(List<PreSelectPlugInterceptDo> preSelectDoList) {
        Map<Long, PreSelectPlugInterceptDo> ret = new HashMap<Long, PreSelectPlugInterceptDo>();
        HashMap groupMap = new HashMap();
        String lastDateTime = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{preSelectDoList})) {
            for (int i = 0; i < preSelectDoList.size(); ++i) {
                PreSelectPlugInterceptDo preSelectDo = preSelectDoList.get(i);
                if (preSelectDo == null) continue;
                String cDateTime = preSelectDo.getDt();
                Long plugId = preSelectDo.getPlugId();
                if (!groupMap.containsKey(cDateTime)) {
                    groupMap.put(cDateTime, new HashMap());
                }
                if (plugId != null) {
                    ((Map)groupMap.get(cDateTime)).put(plugId, preSelectDo);
                }
                if (lastDateTime == null) {
                    lastDateTime = cDateTime;
                    continue;
                }
                if (lastDateTime.compareTo(cDateTime) >= 0) continue;
                lastDateTime = cDateTime;
            }
            ret = (Map)groupMap.get(lastDateTime);
        }
        return ret;
    }

    private static Boolean valid(List<Long> interceptDoList, ActInterceptFeatureDo actFeatureDo) {
        Boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{interceptDoList, actFeatureDo})) {
            ret = false;
        }
        return ret;
    }

    private static Boolean validModel(CODER coderModel, LocalTFModel ltfModel) {
        Boolean ret = true;
        if (ltfModel == null || coderModel == null) {
            logger.warn("PlugInterceptDQNRcmder.rcmd() input valid ,params ltfModel is null or coderModel is null");
            ret = false;
        }
        return ret;
    }
}

