package cn.com.duiba.nezha.alg.alg.adx.algplus;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.ClickValueRectifyReqDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class ClickValueRectifyTask {

    private static final Logger logger = LoggerFactory.getLogger(ClickValueRectifyTask.class);

    private static int[] CLICK_VALUE_BUCKET = {1, 2, 3, 5, 7, 10, 20, 50, 100};

    /**
     *  定时任务–PD创意点击价值纠偏(5min执行1次)
     *  注：根据资源位维度数据，计算纠偏因子
     *
     * @param rectifyRequestDo
     * @return
     */

    public static ClickValueRectifyDo getClickValueRectify(ClickValueRectifyReqDo rectifyRequestDo) {

        ClickValueRectifyDo ret = new ClickValueRectifyDo();

        try {


            Double defaultFactor = 1.0;                        // 默认纠偏因子
            boolean isConfident = false;                       // 数据指标是否置信
            Integer bucketLen = CLICK_VALUE_BUCKET.length + 2; // 点击价值分层个数(0-10)

            Map<Integer, Double> rectifyFactorMap = new HashMap<>((bucketLen));
            Map<Integer, Long> resoClickCntDay = new HashMap<>((bucketLen));
            Map<Integer, Long> resoClickCntHour = new HashMap<>((bucketLen));
            Map<Integer, Long> resoAdConsumeDay = new HashMap<>((bucketLen));
            Map<Integer, Long> resoAdConsumeHour = new HashMap<>((bucketLen));
            Map<Integer, Double> resoPreClickValueDay = new HashMap<>((bucketLen));
            Map<Integer, Double> resoPreClickValueHour = new HashMap<>((bucketLen));



            //1.统计指标计算
            boolean isDayConfident = false, isMinConfident = false;
            Map<Integer, AdxStatsDo> resoLevelStats = new HashMap<>((bucketLen));
            if (AssertUtil.isNotEmpty(rectifyRequestDo)) {

                resoLevelStats = rectifyRequestDo.getResoClickValueLevelStats();
                AdxStatsDo resoStats = rectifyRequestDo.getResoStats();
                if (AssertUtil.isNotEmpty(resoStats)) {
                    AdxIndexStatDo resoLast1DayStat = resoStats.getLast1DayStat();
                    AdxIndexStatDo resoLast20MinStat = resoStats.getLast20MinStat();
                    AdxIndexStatsDo resoStatsDay = AdxStatData.adxIndexCompute(resoLast1DayStat);
                    AdxIndexStatsDo resoStatsMin = AdxStatData.adxIndexCompute(resoLast20MinStat);
                    isDayConfident = resoStatsDay.getConfident();
                    isMinConfident = resoStatsMin.getConfident();

                }
            }


            //2.计算纠偏因子（使用资源位维度）
            for (int key = 0; key < bucketLen; key++) {

                Double rectifyFactor = defaultFactor;
                if (AssertUtil.isNotEmpty(resoLevelStats)) {
                    AdxStatsDo levelStats = resoLevelStats.get(key);

                    if (AssertUtil.isNotEmpty(levelStats)) {
                        AdxIndexStatDo levelLast1DayStat = levelStats.getLast1DayStat();
                        AdxIndexStatDo levelLast1HourStat = levelStats.getLast1HourStat();
                        AdxIndexStatsDo levelStatsDay = AdxStatData.adxIndexCompute(levelLast1DayStat);
                        AdxIndexStatsDo levelStatsHour = AdxStatData.adxIndexCompute(levelLast1HourStat);

                        //融合因子（实时, 当天）
                        Double conRectifyFactor = AdxStatData.getConRectifyFactor(levelStatsHour, levelStatsDay);

                        //置信判断：资源位整体当天/实时维度数据置信
                        if (isDayConfident && isMinConfident) {
                            isConfident = true;

                            if (AssertUtil.isNotEmpty(conRectifyFactor)) {
                                rectifyFactor = conRectifyFactor;
                            }
                        }

                        resoClickCntDay.put(key, levelStatsDay.getClickCnt());
                        resoClickCntHour.put(key, levelStatsHour.getClickCnt());
                        resoAdConsumeDay.put(key, levelStatsDay.getAdvertConsume());
                        resoAdConsumeHour.put(key, levelStatsHour.getAdvertConsume());
                        resoPreClickValueDay.put(key, levelStatsDay.getPreClickValueSum());
                        resoPreClickValueHour.put(key, levelStatsHour.getPreClickValueSum());
                    }
                }

                rectifyFactorMap.put(key, rectifyFactor);
            }


            ret.setRectifyFactorMap(rectifyFactorMap);
            ret.setConfident(isConfident);
            ret.setResoClickCntDay(resoClickCntDay);
            ret.setResoClickCntHour(resoClickCntHour);
            ret.setResoAdConsumeDay(resoAdConsumeDay);
            ret.setResoAdConsumeHour(resoAdConsumeHour);
            ret.setResoPreClickValueDay(resoPreClickValueDay);
            ret.setResoPreClickValueHour(resoPreClickValueHour);

        } catch (Exception e) {

            logger.error("ClickValueRectifyTask.getClickValueRectify error", e);
        }
        return ret;
    }

}
