package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;

import java.util.Map;


/**
 * 广告出价控制模块
 */
public class BidControlAlg {


    /**
     * 出价控制
     * 描述：
     * 包含所有算法出价调节策略
     * 1、出价维稳调节
     * 2、价格保护
     * 3、探价
     * 4、底价放弃
     * 5、预算平滑（暂无）
     * 6、纠偏出价调节（暂无）
     *
     * 输入说明：
     * 1、所有配置集合
     * 2、算法控制参数对象

     * 输出说明：
     * 1、出价、是否放弃
     * 2、控制参数
     */

    /**
     * @param advertMap   竞价广告列表
     * @param paramsModel 控制参数对象
     */
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {


        return BidControl.bidControl(advertMap, paramsModel);
    }


    /**
     * 维稳重置
     * 描述：
     * 包含两种重置情况：
     * 1、配置重置
     * 2、配置修改目标、调整出价
     * <p>
     * 输入说明：
     * 1、配置基础信息
     * 2、算法控制参数对象
     * <p>
     * 输出说明：
     * 1、配置重置：
     * 2、算法控制参数对象（更新）
     * <p>
     * <p>
     * /**
     *
     * @param advertId  广告ID
     * @param packageId 配置ID
     * @param type      2 初始化重置（管理后台手动）  1：出价 或目标重置
     */
    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {

        BidControl.reSet(advertId, packageId, type,paramsModel);
    }


    /**
     * 重新出价（出价保护）
     * 描述
     * 对在白名单，且排序Top的配置，调整价格，保护出价

     * 输入说明：
     * top1：ctr1、fee1
     * top2：ctr2、fee2
     * 维稳出价结果对象

     * 输出说明：
     * 1、配置重置：
     * 2、维稳出价结果对象（更新）
     */

    /**
     * @param top1          排序第一的配置
     * @param top2          排序第二的配置
     * @param bidResultTop1 排序第一的出价结果对象
     *                      <p>
     *                      return              重新出价
     */
    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {
        return BidControl.reBid(top1, top2, bidResultTop1);
    }


    /**
     * 重新出价（出价保护）
     * 描述
     * 对在白名单，且排序Top的配置，调整价格，保护出价

     * 输入说明：
     * top1：ctr1、fee1
     * top2：ctr2、fee2
     * 维稳出价结果对象

     * 输出说明：
     * 1、配置重置：
     * 2、维稳出价结果对象（更新）
     */

    /**
     * @param top1          排序第一的探索配置
     * @param top2          排序第二的非探索配置
     * @param bidResultTop1 排序第一的探索出价结果对象
     *                      <p>
     *                      return              重新出价
     */
    public static AdBidResultDo exploreReBid(AdFeeDo top1, AdFeeDo top2,
                                             AdBidResultDo bidResultTop1) {
        return BidControl.exploreReBid(top1, top2, bidResultTop1);
    }
}
