package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import lombok.Data;

@Data
public class SlotControlParams {

    /**
     * 冷启动
     */

    private Long avgFee;
    private static double probs = 0.5;
    private String updateTime;


    public static long getFee(long fee, SlotControlParams slotControlParams) {
        long adjustFee = fee;
        Long avgFee = slotControlParams.getAvgFee();
        if (avgFee == null) {
            return adjustFee;
        }

        if (fee > avgFee) {
            double random = Math.random();
            adjustFee = random > probs ? avgFee : Math.min(fee, 2 * avgFee);
        }
        return adjustFee;

    }

    /**
     * @param fee
     * @param cpcFee            cpc指导出价
     * @param slotControlParams
     * @return
     */
    public static long getFee(long fee, Long cpcFee, SlotControlParams slotControlParams) {
        long adjustFee = fee;

        /**
         * 广告位平均出价
         */
        Long avgFee = slotControlParams.getAvgFee();


        if (cpcFee == null && avgFee != null) {
            cpcFee = avgFee;
        }

        if (cpcFee == null) {
            return adjustFee;
        }


        if (fee > cpcFee) {
            double random = Math.random();

            double adjustFee1 = random > probs ? cpcFee : Math.min(fee, 1.5 * cpcFee);
            adjustFee = Math.round(adjustFee1);
        }


        return adjustFee;

    }

}
