/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorSubDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxStatBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxStatSubDo;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    public static AdxFactorDo run(AdxFactorReqDo adxFactorReqDo) {
        AdxFactorDo adxFactorDo = Optional.ofNullable(adxFactorReqDo.getAdxFactorDo()).orElse(new AdxFactorDo());
        try {
            Map<Long, Map<Long, AdxIdeaDo>> resIdeaDoMap = adxFactorReqDo.getResIdeaDoMap();
            resIdeaDoMap.forEach((resId, adxIdeaDoMap) -> {
                AdxFactorSubDo resFactorSubDo = adxFactorDo.getFactorSubDo((Long)resId, 1);
                AdxStatDo resStatDo = adxFactorReqDo.getStatDo((Long)resId, 1);
                AdxRoiFactor.runFactor(resFactorSubDo, resStatDo, new AdxIdeaDo());
                adxFactorDo.putFactorSubDo((Long)resId, resFactorSubDo, 1);
                adxIdeaDoMap.forEach((ideaId, adxIdeaDo) -> {
                    AdxFactorSubDo ideaFactorSubDo = adxFactorDo.getFactorSubDo((Long)ideaId, 0);
                    AdxStatDo ideaStatDo = adxFactorReqDo.getStatDo((Long)ideaId, 0);
                    logger.info("last ideaId:{},ideaFactorSubDo:{}", ideaId, (Object)JSON.toJSONString((Object)ideaFactorSubDo));
                    AdxRoiFactor.runFactor(ideaFactorSubDo, ideaStatDo, adxIdeaDo);
                    adxFactorDo.putFactorSubDo((Long)ideaId, ideaFactorSubDo, 0);
                    logger.info("new ideaId:{},ideaFactorSubDo:{}", ideaId, (Object)JSON.toJSONString((Object)ideaFactorSubDo));
                });
            });
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.run error:", (Throwable)e);
        }
        return adxFactorDo;
    }

    public static void runFactor(AdxFactorSubDo adxFactorSubDo, AdxStatDo adxStatDo, AdxIdeaDo adxIdeaDo) {
        try {
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxFactorSubDo, adxStatDo, adxIdeaDo})) {
                return;
            }
            if (adxIdeaDo == null) {
                adxIdeaDo = new AdxIdeaDo();
            }
            Integer bidMode = adxIdeaDo.getBidMode();
            Double target = AdxIdeaDo.getTarget(adxIdeaDo);
            boolean reset = false;
            if (bidMode != null && target != null && adxFactorSubDo.getAdxIdeaDo() != null && !adxIdeaDo.equals(adxFactorSubDo.getAdxIdeaDo())) {
                reset = true;
            }
            AdxStatSubDo statSubDoMins = adxStatDo.getStatSubDo1();
            AdxStatBaseDo statBaseDoMins = statSubDoMins.getAdxStatBaseDo();
            AdxStatSubDo statSubDoDay = adxStatDo.getStatSubDo2();
            AdxStatBaseDo statBaseDoDay = statSubDoDay.getAdxStatBaseDo();
            AdxStatSubDo statSubDo3Day = adxStatDo.getStatSubDo3();
            AdxStatBaseDo statBaseDo3Days = statSubDo3Day.getAdxStatBaseDo();
            AdxFactorBaseDo factorBaseDo = adxFactorSubDo.getFactorBaseDo();
            AdxRoiFactor.getFactor(target, factorBaseDo, null, bidMode, statBaseDoMins, statBaseDoDay, statBaseDo3Days, reset);
            Map<String, AdxStatBaseDo> adxStatBaseDoMap = statSubDoMins.getAdxStatBaseDoMap();
            if (AssertUtil.isNotEmpty(adxStatBaseDoMap)) {
                boolean finalReset = reset;
                adxStatBaseDoMap.forEach((appId, appStatBaseDo) -> {
                    AdxFactorBaseDo appFactor = adxFactorSubDo.getAppFactor((String)appId);
                    AdxStatBaseDo appStatBaseDoDay = statSubDoDay.getStatBaseDo((String)appId);
                    AdxStatBaseDo appStatBaseDo3Days = statSubDo3Day.getStatBaseDo((String)appId);
                    AdxRoiFactor.getFactor(target, appFactor, factorBaseDo, bidMode, appStatBaseDo, appStatBaseDoDay, appStatBaseDo3Days, finalReset);
                    adxFactorSubDo.putAppFactor((String)appId, appFactor);
                });
            }
            adxFactorSubDo.setAdxIdeaDo(adxIdeaDo);
            adxFactorSubDo.setFactorBaseDo(factorBaseDo);
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.runFactor error:", (Throwable)e);
        }
    }

    public static void getFactor(Double target, AdxFactorBaseDo factorBaseDo, AdxFactorBaseDo factorBaseDo2, Integer bidMode, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay, AdxStatBaseDo statBaseDo3Days, boolean reset) {
        if (target != null && bidMode != null) {
            AdxRoiFactor.updateFactor(target, factorBaseDo, bidMode, adxStatBaseDo, statBaseDoDay, statBaseDo3Days, reset);
        }
        AdxRoiFactor.updateStatValue(factorBaseDo, factorBaseDo2, adxStatBaseDo, statBaseDoDay);
    }

    public static void updateFactor(Double target, AdxFactorBaseDo factorBaseDo, Integer bidMode, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay, AdxStatBaseDo statBaseDo3Days, boolean reset) {
        try {
            if (factorBaseDo == null) {
                factorBaseDo = new AdxFactorBaseDo();
            }
            double factor = factorBaseDo.getFactor();
            if (reset) {
                factor = 1.0;
                factorBaseDo.setConfidence(true);
                factorBaseDo.setFactor(factor);
                return;
            }
            if (!AdxStatBaseDo.isCostConfidence(statBaseDoDay) && !AdxStatBaseDo.isImpConfidence(adxStatBaseDo)) {
                factor += (1.0 - factor) * 0.1;
                factorBaseDo.setConfidence(false);
                factorBaseDo.setFactor(factor);
                return;
            }
            Double realValueMins = AdxRoiFactor.getRealValue(adxStatBaseDo, bidMode, target);
            Double realValueDay = AdxRoiFactor.getRealValue(statBaseDoDay, bidMode, target);
            Double realValue3Days = AdxRoiFactor.getRealValue(statBaseDo3Days, bidMode, target);
            PidController pidController = new PidController();
            double signal = pidController.runPid2(target.doubleValue(), realValueMins.doubleValue(), realValueDay.doubleValue(), realValue3Days.doubleValue());
            factor += signal;
            if (realValueDay / target - 1.0 > 0.1) {
                factor += (0.3 - factor) * 0.1;
            } else if (realValueDay / target - 1.0 < -0.1) {
                factor += (1.2 - factor) * 0.1;
            }
            factor = MathUtil.stdwithBoundary((double)factor, (double)0.3, (double)1.2);
            factorBaseDo.setConfidence(true);
            factorBaseDo.setFactor(factor);
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.updateFactor error:", (Throwable)e);
        }
    }

    public static void updateStatValue(AdxFactorBaseDo factorBaseDo, AdxFactorBaseDo factorBaseDo2, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double arpu = factorBaseDo.getArpu();
        Double launchPv = factorBaseDo.getLaunchPv();
        Double statCtr = factorBaseDo.getStatCtr();
        Double cpm = factorBaseDo.getCpm();
        Double clickValue = factorBaseDo.getClickValue();
        if (AdxStatBaseDo.isCostConfidence(statBaseDoDay)) {
            arpu = AdxRoiFactor.getArpu(arpu, adxStatBaseDo, statBaseDoDay);
            launchPv = AdxRoiFactor.getLaunchPv(launchPv, adxStatBaseDo, statBaseDoDay);
            statCtr = AdxRoiFactor.getStatCtr(statCtr, adxStatBaseDo, statBaseDoDay);
            cpm = AdxRoiFactor.getStatCpm(cpm, adxStatBaseDo, statBaseDoDay);
            clickValue = AdxRoiFactor.getStatClickValue(clickValue, adxStatBaseDo, statBaseDoDay);
        } else if (factorBaseDo2 != null) {
            arpu = MathUtil.mean((Double)arpu, (Double)factorBaseDo2.getArpu(), (Double)0.9);
            launchPv = MathUtil.mean((Double)launchPv, (Double)factorBaseDo2.getLaunchPv(), (Double)0.9);
            statCtr = MathUtil.mean((Double)statCtr, (Double)factorBaseDo2.getStatCtr(), (Double)0.9);
            cpm = MathUtil.mean((Double)cpm, (Double)factorBaseDo2.getCpm(), (Double)0.9);
            clickValue = MathUtil.mean((Double)clickValue, (Double)factorBaseDo2.getClickValue(), (Double)0.9);
        }
        factorBaseDo.setArpu(arpu);
        factorBaseDo.setLaunchPv(launchPv);
        factorBaseDo.setStatCtr(statCtr);
        factorBaseDo.setCpm(cpm);
        factorBaseDo.setClickValue(clickValue);
    }

    public static Double getArpu(Double arpu, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double arpu1 = AdxStatBaseDo.getStatArpu(adxStatBaseDo);
        Double arpu2 = AdxStatBaseDo.getStatArpu(statBaseDoDay);
        Double statArpu = MathUtil.mean((Double)arpu1, (Double)arpu2, (Double)0.9);
        arpu = MathUtil.mean((Double)arpu, (Double)statArpu, (Double)0.9);
        return arpu;
    }

    public static Double getLaunchPv(Double launchPv, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double launchPv1 = AdxStatBaseDo.getStatLaunchPv(adxStatBaseDo);
        Double launchPv2 = AdxStatBaseDo.getStatLaunchPv(statBaseDoDay);
        Double statlaunchPv = MathUtil.mean((Double)launchPv1, (Double)launchPv2, (Double)0.9);
        launchPv = MathUtil.mean((Double)launchPv, (Double)statlaunchPv, (Double)0.9);
        return launchPv;
    }

    public static Double getStatCtr(Double ctr, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double ctr1 = AdxStatBaseDo.getStatLaunchPv(adxStatBaseDo);
        Double ctr2 = AdxStatBaseDo.getStatLaunchPv(statBaseDoDay);
        Double statctr = MathUtil.mean((Double)ctr1, (Double)ctr2, (Double)0.9);
        ctr = MathUtil.mean((Double)ctr, (Double)statctr, (Double)0.9);
        return ctr;
    }

    public static Double getStatCpm(Double cpm, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double cpm1 = AdxStatBaseDo.getStatCpm(adxStatBaseDo);
        Double cpm2 = AdxStatBaseDo.getStatCpm(statBaseDoDay);
        Double statCpm = MathUtil.mean((Double)cpm1, (Double)cpm2, (Double)0.9);
        cpm = MathUtil.mean((Double)cpm, (Double)statCpm, (Double)0.9);
        return cpm;
    }

    public static Double getStatClickValue(Double clickValue, AdxStatBaseDo adxStatBaseDo, AdxStatBaseDo statBaseDoDay) {
        Double cv1 = AdxStatBaseDo.getStatClickValue(adxStatBaseDo);
        Double cv2 = AdxStatBaseDo.getStatClickValue(statBaseDoDay);
        Double statCv = MathUtil.mean((Double)cv1, (Double)cv2, (Double)0.9);
        clickValue = MathUtil.mean((Double)clickValue, (Double)statCv, (Double)0.9);
        return clickValue;
    }

    public static Double getRoi(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long advertConsume = adxStatBaseDo.getAdvertConsume();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (adxConsume != null && adxConsume > 3000.0) {
                ret = MathUtil.division((Double)adxConsume, (Long)advertConsume, (int)3);
            }
        }
        return ret;
    }

    public static Double getCpc(AdxStatBaseDo adxStatBaseDo) {
        Double ret = null;
        if (adxStatBaseDo != null) {
            Long click = adxStatBaseDo.getClick();
            Double adxConsume = adxStatBaseDo.getAdxConsume2();
            if (adxConsume != null && adxConsume > 3000.0) {
                ret = MathUtil.division((Double)adxConsume, (Long)click, (int)3);
            }
        }
        return ret;
    }

    public static Double getRealValue(AdxStatBaseDo adxStatBaseDo, Integer bidMode, Double defaultValue) {
        Double ret = null;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxStatBaseDo, bidMode})) {
            Double d = ret = bidMode == 1 ? AdxRoiFactor.getRoi(adxStatBaseDo) : AdxRoiFactor.getCpc(adxStatBaseDo);
        }
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static Double getStatValue(Double ... values) {
        Double ret = null;
        double sum = 0.0;
        int cnt = 0;
        for (Double v : values) {
            if (v == null) continue;
            sum += v.doubleValue();
            ++cnt;
        }
        ret = MathUtil.division((double)sum, (int)cnt, (int)3);
        return ret;
    }
}

