/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb.AdxRtbBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbBidAlg {
    private static final Logger logger = LoggerFactory.getLogger(RtbBidAlg.class);

    public static AdxRtbBidResultDo getRtbBidding(AdxRtbBidRequestDo bidRequestDo) {
        AdxRtbBidResultDo ret = new AdxRtbBidResultDo();
        if (!RtbBidAlg.valid(bidRequestDo)) {
            RtbBidAlg.printBidReq(bidRequestDo);
        }
        try {
            Long resId = bidRequestDo.getResourceId();
            Long ideaId = bidRequestDo.getIdeaId();
            String appId = bidRequestDo.getAppId();
            Integer bidMode = bidRequestDo.getBidMode();
            Integer groupTag = bidRequestDo.getGroupTag();
            AdxFactorDo adxFactorDo = Optional.ofNullable(bidRequestDo.getAdxFactorDo()).orElse(new AdxFactorDo());
            AdxFactorBaseDo factorBaseDo = adxFactorDo.getFactorBaseDo(resId, ideaId, appId);
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(327.0);
            Double preCtr = bidRequestDo.getPreCtr();
            Double statCtr = factorBaseDo.getStatCtr();
            Double ctr = MathUtil.mean((Double)preCtr, (Double)statCtr, (Double)0.9);
            ctr = Optional.ofNullable(ctr).orElse(0.0269);
            Double preLaunchPv = bidRequestDo.getPreLaunchPv();
            Double statLaunchPv = factorBaseDo.getLaunchPv();
            Double launchPv = MathUtil.mean((Double)preLaunchPv, (Double)statLaunchPv, (Double)0.9);
            launchPv = Optional.ofNullable(launchPv).orElse(1.025);
            Double arpu = factorBaseDo.getArpu();
            arpu = Optional.ofNullable(arpu).orElse(17.9);
            Double preClickValue = bidRequestDo.getClickValue();
            Double statClick = factorBaseDo.getClickValue();
            Double clickValue = MathUtil.mean((Double)preClickValue, (Double)statClick, (Double)0.9);
            clickValue = Optional.ofNullable(clickValue).orElse(18.4);
            Double cpc = bidRequestDo.getCpc();
            Double roi = bidRequestDo.getRoi() / 100.0;
            Double price = bidMode == 1 ? RtbBidAlg.getRoiPrice(groupTag, ctr, factor, launchPv, arpu, roi, clickValue) : RtbBidAlg.getCpcPrice(ctr, cpc, factor);
            price = Math.min(price, 3.0 * cpm);
            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setClickValue(clickValue);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
        }
        catch (Exception e) {
            logger.error("RtbBidAlg.getRtbBidding error", (Throwable)e);
        }
        return ret;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, Double factor) {
        Double price = ctr * cpc * factor * 1000.0 * 100.0;
        return price;
    }

    public static Double getRoiPrice(Integer groupTag, Double ctr, Double factor, Double launchPv, Double arpu, Double roi, Double clickValue) {
        Double price = null;
        price = groupTag == 3 ? Double.valueOf(ctr * launchPv * arpu * factor / roi * 1000.0) : Double.valueOf(ctr * clickValue * factor / roi * 1000.0);
        return price;
    }

    public static boolean valid(AdxRtbBidRequestDo bidRequestDo) {
        boolean ret = true;
        if (bidRequestDo == null || bidRequestDo.getBidMode() == null || bidRequestDo.getPreCtr() == null) {
            ret = false;
        }
        if (bidRequestDo.getBidMode() == 1 && (bidRequestDo.getRoi() == null || bidRequestDo.getPreLaunchPv() == null)) {
            ret = false;
        }
        if (bidRequestDo.getBidMode() == 2 && bidRequestDo.getCpc() == null) {
            ret = false;
        }
        return ret;
    }

    public static void printBidReq(AdxRtbBidRequestDo bidRequestDo) {
        logger.info("bidRequestDo is not valid, groupId:{}, resourceId:{}, ideaId:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, clickValue:{}", new Object[]{bidRequestDo.getGroupId(), bidRequestDo.getResourceId(), bidRequestDo.getIdeaId(), bidRequestDo.getBidMode(), bidRequestDo.getPreCtr(), bidRequestDo.getRoi(), bidRequestDo.getPreLaunchPv(), bidRequestDo.getCpc(), bidRequestDo.getClickValue()});
    }
}

