package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class BidControl {

    //行业ID---6:教育, 9:二电, 15:会籍卡, 16:运营商, 21:保险
    public static List<Long> tradeList = Arrays.asList(15L, 16L);


    /**
     * 出价控制
     * 描述：
     * 包含所有算法出价调节策略
     * 1、出价维稳调节
     * 2、价格保护
     * 3、探价
     * 4、底价放弃
     * 5、预算平滑（暂无）
     * 6、纠偏出价调节（暂无）
     *
     * 输入说明：
     * 1、所有配置集合
     * 2、算法控制参数对象

     * 输出说明：
     * 1、出价、是否放弃
     * 2、控制参数
     */

    /**
     * 批量接口
     *
     * @param advertMap   竞价广告列表
     * @param paramsModel 控制参数对象
     */
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {
        Map<String, AdBidResultDo> ret = new HashMap<>();

        for (Map.Entry<String, AdBidInputDo> entry : advertMap.entrySet()) {

            String key = entry.getKey();
            AdBidInputDo adBidInputDo = entry.getValue();

            AdBidResultDo adBidResultDo = bidControl(adBidInputDo, paramsModel);

            ret.put(key, adBidResultDo);
        }

        return ret;
    }

    /**
     * 单广告接口
     *
     * @param adBidInputDo 竞价广告
     * @param paramsModel  控制参数对象
     */
    public static AdBidResultDo bidControl(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel) {
        AdBidResultDo adBidResultDo = new AdBidResultDo();


        adBidResultDo.setAdvertId(adBidInputDo.getAdvertId());
        adBidResultDo.setPackageId(adBidInputDo.getPackageId());
        adBidResultDo.setSlotId(adBidInputDo.getSlotId());
        adBidResultDo.setReservePriceGiveUp(false);
        adBidResultDo.setReserveFee(adBidInputDo.getReserveFee());
        /**
         * cpc 广告
         */
        if (adBidInputDo.getChargeType() == 1) {

            adBidResultDo.setFee(adBidInputDo.getFee());
        }

        /**
         * ocpc广告
         */

        if (adBidInputDo.getChargeType() == 2) {

            long fee = getOcpcFee(adBidInputDo.getCvr(), adBidInputDo.getAFee(), adBidInputDo.getAppAFee(), adBidInputDo.getSpecialAccountWeight());

            adBidResultDo.setFee(fee);
            adBidResultDo.setFactor(1.0);

            if (AssertUtil.isNotEmpty(paramsModel)) {

                AdBidParamsDo adBidParamsDo = getBidParams(adBidInputDo, paramsModel, fee);

                if (AssertUtil.isNotEmpty(adBidParamsDo)) {
                    adBidResultDo.setFee(adBidParamsDo.getFee());
                    adBidResultDo.setFactor(adBidParamsDo.getFactor());
                    adBidResultDo.setAdBidParamsDo(adBidParamsDo);
                    adBidResultDo.setReservePriceGiveUp(adBidParamsDo.getIsGiveUp());
                }

            }

        }


        return adBidResultDo;
    }


    public static AdBidParamsDo getBidParams(AdBidInputDo adBidInputDo,
                                             OcpxControlModel paramsModel, long fee) {

        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();

        Long advertId = adBidInputDo.getAdvertId();
        Long packageId = adBidInputDo.getPackageId();
        Long slotId = adBidInputDo.getSlotId();
        Long cpcFee = adBidInputDo.getFee(); //默认参考cpc出价

//        long floorFee = adBidInputDo.getReserveFee();
        /**
         * 参数计算
         */

        adBidParamsDo.setFee(fee);

        adBidParamsDo.setAFee(adBidInputDo.getAFee());//ocpx 广告 转化目标出价（配置的）
        adBidParamsDo.setAppAFee(adBidInputDo.getAppAFee());//ocpx 广告 媒体 转化目标出价（******   新增 !!!! *******）
        adBidParamsDo.setDeepFee(adBidInputDo.getDeepFee());//深度目标成本（2020.11.12）


        adBidParamsDo.setChargeType(adBidInputDo.getChargeType()); //是否ocpc，1：cpc、2：ocpc
        adBidParamsDo.setCvrType(adBidInputDo.getCvrType());//ocpx 转化目标类型，目前支持：0、2、3（2020.09.10）
        adBidParamsDo.setDeepCvrType(adBidInputDo.getDeepCvrType());//ocpx 深度转化目标类型，目前支持：8（2020.09.10）
        adBidParamsDo.setPreDcvr(adBidInputDo.getPreDcvr());//预估深度转化率

        adBidParamsDo.setFactor(1.0);
        adBidParamsDo.setReserveFee(adBidInputDo.getReserveFee());
        adBidParamsDo.setReservePriceWhite(adBidInputDo.getReservePriceWhite());

        adBidParamsDo.setIsAutoTarget(adBidInputDo.getIsAutoTarget());

        adBidParamsDo.setAbTestId(adBidInputDo.getAbTestId());
        adBidParamsDo.setFastAbTestId(adBidInputDo.getFastAbTestId());

        adBidParamsDo.setIsNewOTest(adBidInputDo.getIsNewOTest());
        adBidParamsDo.setNewOAbTestId(adBidInputDo.getNewOAbTestId());
        adBidParamsDo.setIsColdTest(adBidInputDo.getIsColdTest());
        adBidParamsDo.setColdAbTestId(adBidInputDo.getColdAbTestId());

        adBidParamsDo.setDeepControlType(adBidInputDo.getDeepControlType());

        adBidParamsDo.setBidControlType(adBidInputDo.getBidControlType());

        adBidParamsDo.setDeepAllEffect(adBidInputDo.getDeepAllEffect());

        adBidParamsDo.setReleaseTarget(adBidInputDo.getReleaseTarget());

        adBidParamsDo.setDeepDelayType(adBidInputDo.getDeepDelayType());// 双出价后端延迟类型： null：无  1：10分钟内   2：10分钟以上

//        System.out.println("ocpxControlSubModel=" + JSON.toJSONString(ocpxControlSubModel));


        /**
         * 处理逻辑
         *
         * 功能点：成本控制（跑量、底价、出价保护-过度出价，使用同一套参数）、双出价、出价保护-冷启动、试探
         *
         * 成本控制：
         *    跑量模式： releaseTarget=2、3
         *
         *
         *
         */


        /**
         * 部分双出价配置，全部生效
         */


//        if (adBidParamsDo.getDeepAllEffect() != null && adBidParamsDo.getDeepAllEffect()) {
//            adBidParamsDo.setAbTestId(2);
//        }


        /**
         * 选择成本控制对象
         * 12.3
         */
//        OcpxControlSubModel pModel = paramsModel.getOcpxControlSubModel(advertId, packageId);
        OcpxControlSubModel pModel = adBidInputDo.getOcpxControlSubModel();


        if (pModel != null) {


            /**
             * 策略
             */


            /**
             * 0 策略模式   常规成本控制、跑量成本控制、双出价成本控制
             * 白名单测试优先级：新o测试>双出价>跑量>冷启动
             */
            int costParamsType = 1; //默认

            if (adBidParamsDo.getIsNewOTest() != null && adBidParamsDo.getIsNewOTest().equals(2)) {
                //新o白名单测试
                if (adBidParamsDo.getNewOAbTestId() != null && adBidParamsDo.getNewOAbTestId().equals(2)) {
                    costParamsType = 2;
                }

            } else if (adBidParamsDo.getDeepControlType() != null && adBidParamsDo.getDeepControlType().equals(0)) {

                //双出价白名单测试（附加：全切测试--仅实验组生效）
                if (adBidParamsDo.getAbTestId() != null && adBidParamsDo.getAbTestId().equals(2)) {
                    costParamsType = 2;
                }

            } else if (adBidParamsDo.getReleaseTarget() != null && adBidParamsDo.getReleaseTarget() > 1L && adBidParamsDo.getReleaseTarget() != 4L
                    && adBidParamsDo.getBidControlType() != null && adBidParamsDo.getBidControlType().equals(2)) {

                //跑量测试模式: 选择跑量模式，按行业白名单开启测试
                if (adBidParamsDo.getFastAbTestId() != null && adBidParamsDo.getFastAbTestId().equals(2)) {
                    costParamsType = 2;
                }

            }  else if (adBidParamsDo.getIsColdTest() != null && adBidParamsDo.getIsColdTest().equals(2)) {
                //冷启动白名单测试
                if (adBidParamsDo.getColdAbTestId() != null && adBidParamsDo.getColdAbTestId().equals(2)) {
                    costParamsType = 2;
                }

            }

            /**
             * 1 成本维稳
             */


            costControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType));


            /**
             * 2 双出价
             *
             */
            deepControl(adBidParamsDo, pModel.getDeepControlParams(), pModel.getDeepControlParams(slotId));

            /**
             * 3 出价试探-出价增长
             *
             */
            exploreControl(adBidParamsDo, adBidInputDo.getExploreFactor(), adBidInputDo.getIsSupport());


            /**
             * 4 底价控制参数
             */

            floorPriceControl(adBidParamsDo, pModel.getOcpxControlParams(), pModel.getOcpxControlParams(1, slotId));

            /**
             * 5 出价保护-过度出价
             *
             */

            protectControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType), costParamsType);


        }

        /**
         * 6 出价保护-冷启动
         */
        coldControl(adBidParamsDo, paramsModel.getAdSlotControlParams(advertId, slotId), paramsModel.getSlotControlParams(slotId), cpcFee);


        /**
         * 返回结果封装
         */

        return adBidParamsDo;
    }


    /**
     * 策略：成本维稳
     *
     * @return
     */
    public static void costControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams) {

        //维稳参数
        Long factorType = null;//维稳类型，1 配置  2 广告位 3 at 4 无

        Double factor = 1.0;// 维稳因子
        Double pcFactor = 1.0;// 预估值校准因子
        Double fcFactor = 1.0;// 跑量因子

        Long fee = adBidParamsDo.getFee();

        /**
         * 维稳重置
         */
        Integer resetType = OcpxControlParams.getResetType(pkParams);


        /**
         * 维稳调控优先级  自动定向>广告位>整体
         */
        OcpcFactorParams slotFactorParams = OcpxControlParams.getOcpcFactors(slotParams);
        OcpcFactorParams pkFactorParams = OcpxControlParams.getOcpcFactors(pkParams);
        OcpcFactorParams atPkFactorParams = OcpxControlParams.getOcpcFactors(atPkParams);

        Double slotFactor = OcpxControlParams.getCostFactor(slotParams);
        Double pkFactor = OcpxControlParams.getCostFactor(pkParams);
        Double atPkFactor = OcpxControlParams.getCostFactor(atPkParams);

        if (atPkFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget()) {
            factorType = 3L;
            factor = atPkFactor;
            pcFactor = atPkFactorParams.getPcFactor();
            fcFactor = atPkFactorParams.getFcFactor();

        } else if (slotFactor != null) {
            factorType = 2L;
            factor = slotFactor;
            pcFactor = slotFactorParams.getPcFactor();
            fcFactor = slotFactorParams.getFcFactor();

        } else if (pkFactor != null) {
            factorType = 1L;
            factor = pkFactor;
            pcFactor = pkFactorParams.getPcFactor();
            fcFactor = pkFactorParams.getFcFactor();

        }


        Long feeNew = Math.round(fee * factor);


        //维稳重置标记
        adBidParamsDo.setResetType(resetType);


        //维稳参数
        adBidParamsDo.setFactorType(factorType);
        adBidParamsDo.setFactor(factor);
        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setPcFactor(pcFactor);
        adBidParamsDo.setFcFactor(fcFactor);


    }

    /**
     * 策略：双出价维稳
     *
     * @return
     */
    public static void deepControl(AdBidParamsDo adBidParamsDo, DeepControlParams pkParams, DeepControlParams slotParams) {


        Long fee = adBidParamsDo.getFee();

        /**
         * 未开启双出价 直接返回
         */
        if (adBidParamsDo.getDeepControlType() == null
                || adBidParamsDo.getAbTestId() == null) {
            return;
        }


        boolean deepStatus = false;
        boolean isDeep = false;

        /**
         * 深度目标类型 1：设定深度目标成本，分广告位设置目标成本
         */

        if (adBidParamsDo.getDeepFee() != null && adBidParamsDo.getDeepControlType() != null) {

            isDeep = true;
            if (adBidParamsDo.getDeepControlType() == 0 && adBidParamsDo.getAbTestId() == 2) {
                deepStatus = true;
            }

            if (adBidParamsDo.getDeepControlType() != 0) {
                //全切测试：仅实验组生效
                deepStatus = true;
            }

        }


        Double factor = 1.0;
        if (isDeep) {
            //Double pkFactor = DeepControlParams.getDeepFactor(pkParams);
            Double pkFactor = DeepControlParams.getDeepFactor(pkParams, adBidParamsDo.getDeepFee(), adBidParamsDo.getAFee(), adBidParamsDo.getPreDcvr());

            //Double slotFactor = DeepControlParams.getDeepFactor(slotParams);
            Double slotFactor = DeepControlParams.getDeepFactor(slotParams, adBidParamsDo.getDeepFee(), adBidParamsDo.getAFee(), adBidParamsDo.getPreDcvr());

            if (slotFactor != null) {
                factor = slotFactor;
                adBidParamsDo.setPkStatDcvr(slotParams.getPkStatDcvr());
                adBidParamsDo.setSlotStatDcvr(slotParams.getSlotStatDcvr());
            } else if (pkFactor != null) {
                factor = pkFactor;
                adBidParamsDo.setPkStatDcvr(pkParams.getPkStatDcvr());
                adBidParamsDo.setSlotStatDcvr(pkParams.getSlotStatDcvr());
            }

            adBidParamsDo.setDeepControlFactor(factor);

            if (deepStatus) {
                Long feeNew = Math.round(fee * factor);
                adBidParamsDo.setFee(feeNew);
            }

        }


    }

    /**
     * 策略：冷启动控制
     * <p>
     * 广告在广告位上历史投放较少时，限制过高出价
     * 90%出价，限制在平均出价下
     * 10%出价，限制在平均出价*2倍下
     *
     * @return
     */
    public static void coldControl(AdBidParamsDo adBidParamsDo, AdControlParams adControlParams, SlotControlParams slotControlParams, Long cpcFee) {

        //出价保护-冷启动
        Boolean coldProject = null;// 出价保护- 是否冷启动保护

        Long coldProjectFeeDiff = null;// 出价保护-冷启动出价下降

        Long fee = adBidParamsDo.getFee();


        if (slotControlParams != null) {


            if (adControlParams == null
                    || adControlParams.getIsColdStart() == null
                    || adControlParams.getIsColdStart()) {

                coldProject = true;

                Long feeNew = SlotControlParams.getFee(fee, cpcFee, slotControlParams);

                coldProjectFeeDiff = fee - feeNew;
                fee = feeNew;

            }
        }

        //出价保护-冷启动
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setColdProject(coldProject);
        adBidParamsDo.setColdProjectFeeDiff(coldProjectFeeDiff);

    }

//    /**
//     * 策略：探索出价控制
//     *
//     * @return
//     */
//    public static void exploreControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
//
//        Long fee = adBidParamsDo.getFee();
//        Long feeNew = fee;
//        Long exploreFeeDiff = null;// 出价试探-出价增长
//
//        if (slotParams != null && slotParams.getEConf()) {
//            feeNew = OcpxControlParams.getExplorePrice(slotParams, fee);
//        } else if (pkParams != null && pkParams.getEConf()) {
//            feeNew = OcpxControlParams.getExplorePrice(pkParams, fee);
//        } else {
//            return;
//        }
//        exploreFeeDiff = feeNew - fee;
//
//        //出价试探-出价增长
//        adBidParamsDo.setExplore(true);
//        adBidParamsDo.setExploreFeeDiff(exploreFeeDiff);
//        adBidParamsDo.setFee(feeNew);
//
//    }

    /**
     * 探索加价
     *
     * @param adBidParamsDo
     * @param factor
     */
    public static void exploreControl(AdBidParamsDo adBidParamsDo, Double factor, Boolean isSupport) {
        if (factor == null || isSupport) {
            return;
        }

        Long fee = adBidParamsDo.getFee();
        Double feeNew = fee * factor;

        //出价试探-出价增长
        adBidParamsDo.setExplore(true);
        adBidParamsDo.setExploreFactor(factor);
        adBidParamsDo.setFee(feeNew.longValue());

    }


    /**
     * 策略：出价保护控制
     *
     * @return
     */
    public static void protectControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams, int costParamsType) {

        //出价保护-过度出价
        Boolean secondPriceProject = null;// 出价保护，是否二阶保护


        Double secondProtectPriceFactor = null;// 出价保护，二阶因子


        Double slotProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(slotParams, costParamsType);
        Double pkProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(pkParams, costParamsType);

        Double atProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(atPkParams, costParamsType);

        if (atProtectPriceFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget()) {
            secondProtectPriceFactor = atProtectPriceFactor;
        } else if (slotProtectPriceFactor != null) {
            secondProtectPriceFactor = slotProtectPriceFactor;
        } else if (pkProtectPriceFactor != null) {
            secondProtectPriceFactor = pkProtectPriceFactor;
        }


        if (secondProtectPriceFactor != null) {
            secondPriceProject = true;

            /**
             * 当前出价保护 后置 在最后环节计算
             */

        }

        //出价保护-过度出价
        adBidParamsDo.setSecondPriceProject(secondPriceProject);
        adBidParamsDo.setCFactor(secondProtectPriceFactor);
    }

    /**
     * 策略：底价控制
     *
     * @return
     */
    public static void floorPriceControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {

        //底价控制参数

        Boolean isGiveUp = null;

        if (adBidParamsDo.getReservePriceWhite() != null && adBidParamsDo.getReservePriceWhite()) {
            adBidParamsDo.setReservePriceWhite(true);
            return;
        }


        Long giveUpFee = null;// 底价放弃阈值-出价

        Double giveUpRatio = null;// 底价放弃阈值-概率


        if (slotParams != null && slotParams.getFConf() != null && slotParams.getFConf()) {
            giveUpFee = slotParams.getFPriceThre();
            giveUpRatio = slotParams.getFGiveUpProb();
        } else if (pkParams != null && pkParams.getFConf() != null) {
            giveUpFee = pkParams.getFPriceThre();
            giveUpRatio = pkParams.getFGiveUpProb();

        } else {
            return;
        }

        //本次是否放弃
        double rate = Math.random();
        if (giveUpRatio != null && giveUpFee != null) {

            if (rate < giveUpRatio && adBidParamsDo.getFee() <= giveUpFee) {
                isGiveUp = true;
            }
        }


        //底价控制参数
        adBidParamsDo.setIsGiveUp(isGiveUp);

        adBidParamsDo.setGiveUpFee(giveUpFee);

        adBidParamsDo.setGiveUpRatio(giveUpRatio);

    }


    /**
     * 维稳重置
     * 描述：
     * 包含两种重置情况：
     * 1、配置重置
     * 2、配置修改目标、调整出价
     * <p>
     * 输入说明：
     * 1、配置基础信息
     * 2、算法控制参数对象
     * <p>
     * 输出说明：
     * 1、配置重置：
     * 2、算法控制参数对象（更新）
     * <p>
     * <p>
     * /**
     *
     * @param advertId  广告ID
     * @param packageId 配置ID
     * @param type      2 初始化重置（管理后台手动）  1：出价 或目标重置
     */
    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {

        if (AssertUtil.isAllNotEmpty(advertId, packageId, type, paramsModel)) {

            OcpxControlSubModel ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId);

            if (ocpxControlSubModel != null) {
                OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();

                if (ocpxControlParams != null) {
                    ocpxControlParams.setResetType(type);
                }
            }
        }

    }


    /**
     * 维稳重置
     * 描述：
     * 包含两种重置情况：
     * 1、配置重置
     * 2、配置修改目标、调整出价
     * <p>
     * 输入说明：
     * 1、配置基础信息
     * 2、算法控制参数对象
     * <p>
     * 输出说明：
     * 1、配置重置：
     * 2、算法控制参数对象（更新）
     * <p>
     * <p>
     * /**
     *
     * @param advertId  广告ID
     * @param packageId 配置ID
     * @param type      2 初始化重置（管理后台手动）  1：出价 或目标重置
     */
    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlSubModel ocpxControlSubModel) {

        if (AssertUtil.isAllNotEmpty(advertId, packageId, type, ocpxControlSubModel)) {

            if (ocpxControlSubModel != null) {
                OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();

                if (ocpxControlParams != null) {
                    ocpxControlParams.setResetType(type);
                }

                OcpxControlParams ocpxControlParams2 = ocpxControlSubModel.getOcpxControlParams(2);
                if (ocpxControlParams2 != null) {
                    ocpxControlParams2.setResetType(type);
                }


                OcpxControlParams ocpxControlParams3 = ocpxControlSubModel.getOcpxControlParams(3);
                if (ocpxControlParams3 != null) {
                    ocpxControlParams3.setResetType(type);
                }

            }
        }

    }

    /**
     * 重新出价（出价保护）
     * 描述
     * 对在白名单，且排序Top的配置，调整价格，保护出价

     * 输入说明：
     * top1：ctr1、fee1
     * top2：ctr2、fee2
     * 维稳出价结果对象

     * 输出说明：
     * 1、配置重置：
     * 2、维稳出价结果对象（更新）
     */

    /**
     * @param top1          排序第一的配置
     * @param top2          排序第二的配置
     * @param bidResultTop1 排序第一的出价结果对象
     *                      <p>
     *                      return              重新出价
     */
    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {


        //异常处理
        if (AssertUtil.isEmpty(top1)) {
            return bidResultTop1;
        }

        if (bidResultTop1 != null) {
            bidResultTop1.setFee(top1.getFee());
        }

        if (bidResultTop1 != null && bidResultTop1.getAdBidParamsDo() != null) {


            //
            Boolean isSecondPriceProject = bidResultTop1.getAdBidParamsDo().getSecondPriceProject();
            Double protectPriceFactor = bidResultTop1.getAdBidParamsDo().getCFactor();


            Long reserveFee = bidResultTop1.getReserveFee();
            if (reserveFee == null) {
                reserveFee = 15L;
            }

            if (isSecondPriceProject != null && isSecondPriceProject && protectPriceFactor != null && top1.getFee() > reserveFee) {


                // 加价
                if (protectPriceFactor > 1.0) {
                    long protectFee = Math.round(top1.getFee() * protectPriceFactor);
                    bidResultTop1.setFee(protectFee);


                } else {

                    // 降价

                    if (protectPriceFactor < 0.4) {
                        protectPriceFactor = 0.1;
                    }

                    long protectFee = Math.round(top1.getFee() * protectPriceFactor);

                    protectFee = Math.max(protectFee, reserveFee);

                    long secondFee = protectFee;


                    if (!AssertUtil.isEmpty(top2)) {
                        // top2 不为空情况下 计算二价
                        secondFee = getSecondFee(top1.getCtr(), top2.getCtr(), top2.getFee());
                    }


                    // 新出价，二阶基、原出价基础上 平滑
                    long feeNew = Math.max(secondFee, protectFee);
                    feeNew = Math.min(top1.getFee(), feeNew);
                    bidResultTop1.setFee(feeNew);

                }


            }


        }
        return bidResultTop1;
    }


    private static long getSecondFee(double ctr1, double ctr2, long fee2) {
        double feeNew = ctr2 * fee2 / ctr1;
        return Math.round(feeNew) + 1;
    }


    private static long getOcpcFee(double cvr, long afee, Long appFee, Double specialAccountWeight) {

        return appFee == null ? getOcpcFee(cvr, afee, specialAccountWeight) : getOcpcFee(cvr, appFee, specialAccountWeight);
    }

    private static long getOcpcFee(double cvr, long afee, Double specialAccountWeight) {
        if (specialAccountWeight == null) {
            specialAccountWeight = 1.0;
        }
        return Math.round(cvr * afee * specialAccountWeight);
    }


    /**
     * 探索排序第一流量重新出价（出价保护）
     * 描述
     * 对探索流量，调整价格，保护出价
     * <p>
     * 输入说明：
     * 排序第一的探索配置 top1：ctr1、fee1
     * 排序第一的非探索配置 top2：ctr2、fee2
     * <p>
     * 排序第一维稳出价结果对象
     * <p>
     * 输出说明：
     * 1、配置重置：
     * 2、维稳出价结果对象（更新）
     *
     * @param top1          排序第一的探索配置
     * @param top2          排序第一的非探索配置
     * @param bidResultTop1 排序第一的探索配置结果对象
     *                      <p>
     *                      return              重新出价
     */
    public static AdBidResultDo exploreReBid(AdFeeDo top1, AdFeeDo top2,
                                             AdBidResultDo bidResultTop1,
                                             Boolean isSupport) {

        //异常处理
        if (AssertUtil.isEmpty(bidResultTop1)) {
            return bidResultTop1;
        }

        if (isSupport) { // 如果是探索扶持流量，则加价系数只作用在排序竞价环节，未调价
            bidResultTop1.setFee(top1.getFee());
        } else if (top1 != null && top2 != null) {
            // max(探索第一不加价，和非探索第一)
            double val = Math.min(
                    Math.max(top1.getFee() / bidResultTop1.getExploreFactor(),
                            (top2.getCtr() * top2.getFee() + 0.01) / top1.getCtr()), top1.getFee());
            bidResultTop1.setFee(
                    new Double(val).longValue()
            );
        } else if (top1 != null) {
            // 如果全是探索流量，则使用不加价的价格
            bidResultTop1.setFee(
                    new Double(top1.getFee() / bidResultTop1.getExploreFactor()).longValue()
            );
        }

        return bidResultTop1;
    }

}
