package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class AdxDirecetlyPriceDo {

    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 素材ID
     */
    private Long materialId;

    /**
     * 计划维度设置的目标分成比例
     */
    private Double advShareRate;

    /**
     * 广告线 发券CPC价格
     */
    private Double advPrice;

    /**
     * 广告线预估 CTR
     */
    private Double ctr;

    /**
     * 算法调整后的返回给媒体的出价
     */
    private Double adxPrice;

    /**
     * 维稳因子
     */
    private Double roiFactor;

    /**
     * CTR权重调节因子
     */
    private Double ctrFactor;

    /**
     * 配置的真实底价(27分)，如果出价高于该底价但低于30，则以一定概率强制提价至30分
     */
    private Double realFloorPrice;


    public static Double getShareRate(AdxDirecetlyPriceDo adxDirecetlyPriceDo) {
        Double ret = null;
        if(adxDirecetlyPriceDo != null && adxDirecetlyPriceDo.getAdvShareRate() != null) {
            ret = adxDirecetlyPriceDo.getAdvShareRate() /100;
        }
        return ret;
    }

    public static Double getRankScore(AdxDirecetlyPriceDo adxDirecetlyPriceDo) {
        Double ret = 0.;
        Double priceLower = 40.0;
        Double priceUpper = 80.0;
        double adxPriceRaise = 30.;// 从数据中分析得出的提价阈值
        double realFloorPrice = adxDirecetlyPriceDo.getRealFloorPrice();
        double adxPrice = adxDirecetlyPriceDo.getAdxPrice();
        ret = MathUtil.dotPow(adxDirecetlyPriceDo.getAdxPrice(), adxDirecetlyPriceDo.getCtr(),
                adxDirecetlyPriceDo.getCtrFactor(), priceLower, priceUpper, 3);

        // 出价介于27与30之间，则以一定概率强制提价至adxPriceRaise(30分)
        if (adxPrice < adxPriceRaise && adxPrice > realFloorPrice) {
            double rand = Math.random();
//            System.out.println("rand: " + rand + "probability: " + Math.pow(2, -(adxPriceRaise-adxPrice)/(adxPriceRaise-realFloorPrice)));
            if(rand < Math.pow(2, -(adxPriceRaise-adxPrice)/(adxPriceRaise-realFloorPrice))) {
                adxDirecetlyPriceDo.setAdxPrice(adxPriceRaise);
            }
        }
        return ret;
    }

}