package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class AdxDirecrtlyPriceReqDo {

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位维度设置的目标分成比例
     */
    private Double slotShareRate;

    /**
     * 底价
     */
    private Double floorPrice;

    /**
     * 配置的真实底价，如果出价高于该底价但低于30，则以一定概率强制提价至30分
     */
    private Double realFloorPrice;

    /**
     * 需要返回给媒体的广告个数 可配置
     */
    private Integer advertCnt;

    /**
     * 广告券出价信息
     */
    private  List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = new ArrayList<>();

    /**
     * 维稳因子
     */
    private AdxMeiTuanFactorDo adxMeiTuanFactorDo = new AdxMeiTuanFactorDo();

    /**
     * 策略ID
     * 取值 0,1,2,3,4,5
     * 人工出价: 0,2
     * 算法1.0: 1,3
     * 算法2.0: 4,5
     */

    private Integer strategyId;

    /**
     *头部抢量策略ID
     */
    private Integer reqRankStrategyId;

    /**
     *用户当日在美团的竞价请求次数
     */
    private Long reqCnt;

    /**
     * 竞价请求次数阈值
     */
    private Long reqThreshold;

    public static double getShareRate(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        double ret = 1.;
        if(adxDirecrtlyPriceReqDo != null && adxDirecrtlyPriceReqDo.getSlotShareRate() != null) {
            ret = adxDirecrtlyPriceReqDo.getSlotShareRate() / 100;
        }
        return ret;
    }
}
