/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.AdvertSupportInfoV1;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.AdvertSupportRes;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.SupportData;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.SupportParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class AdvertSupportV1 {
    public static AdvertSupportRes biddingFactorV1(AdvertSupportInfoV1 advertSupportInfo, SupportParams params) {
        Double ret = 1.0;
        AdvertSupportRes res = new AdvertSupportRes();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertSupportInfo})) {
            return res;
        }
        List<Double> supportRatioBucket = params.getSupportRatioBucket();
        List<Double> supportRatioWeight = params.getSupportRatioWeight();
        List<Double> rankRatioBucket = params.getRankRatioBucket();
        List<Double> rankRatioWeight = params.getRankRatioWeight();
        Double cost = params.getCostRatio();
        Double cons = params.getCons();
        Double[] supportRatioBucket1 = supportRatioBucket.toArray(new Double[supportRatioBucket.size()]);
        Double[] supportRatioWeight1 = supportRatioWeight.toArray(new Double[supportRatioWeight.size()]);
        Double[] rankRatioBucket1 = rankRatioBucket.toArray(new Double[rankRatioBucket.size()]);
        Double[] rankRatioWeight1 = rankRatioWeight.toArray(new Double[rankRatioWeight.size()]);
        double convRatio = AdvertSupportV1.supportRatio(advertSupportInfo, supportRatioBucket1, supportRatioWeight1);
        double cvrFactor = AdvertSupportV1.getCvrFactor(advertSupportInfo, cost);
        double rankRatio = AdvertSupportV1.division(advertSupportInfo.getRankScore(), advertSupportInfo.getRankScore1());
        double rankFactor = AdvertSupportV1.getConfidenceWeight(rankRatio, rankRatioBucket1, rankRatioWeight1, 1.0);
        double factor = cons * convRatio * rankFactor * cvrFactor;
        double smoothFactor = advertSupportInfo.getLowerLimit() + (advertSupportInfo.getUpperLimit() - advertSupportInfo.getLowerLimit()) * factor;
        smoothFactor = MathBase.noiseSmoother(smoothFactor, advertSupportInfo.getLowerLimit(), advertSupportInfo.getUpperLimit());
        ret = DataUtil.formatDouble((Double)smoothFactor, (int)4);
        if (advertSupportInfo.getAdvert3Day().getConv().getOrDefault(advertSupportInfo.getConvType(), 0L) >= advertSupportInfo.getConvCnt()) {
            ret = 1.0;
        }
        res.setFactor(ret);
        res.setCvrFactor(cvrFactor);
        res.setConvRatio(convRatio);
        res.setRankFactor(rankFactor);
        return res;
    }

    public static Double supportRatio(AdvertSupportInfoV1 advertSupportInfo, Double[] supportRatioBucket1, Double[] supportRatioWeight1) {
        double ret = 1.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertSupportInfo})) {
            return ret;
        }
        Integer convType = advertSupportInfo.getConvType();
        Long conv3day = advertSupportInfo.getAdvert3Day().getConv().getOrDefault(convType, 0L);
        Long conv1day = advertSupportInfo.getAdvert1Day().getConv().getOrDefault(convType, 0L);
        long convs = advertSupportInfo.getConvCnt();
        long conv1 = Math.round(0.5 * (double)convs);
        if (advertSupportInfo.getAdvertConvLastDay().getOrDefault(convType, 0L) > 0L) {
            conv1 = Math.max(convs - advertSupportInfo.getAdvertConvLastDay().getOrDefault(convType, 0L), 1L);
        }
        Double ratio1 = AdvertSupportV1.division(conv3day, convs);
        Double ratio2 = AdvertSupportV1.division(conv1day, conv1);
        double ratioWeight1 = AdvertSupportV1.getConfidenceWeight(ratio1, supportRatioBucket1, supportRatioWeight1, 0.1);
        double ratioWeight2 = AdvertSupportV1.getConfidenceWeight(ratio2, supportRatioBucket1, supportRatioWeight1, 0.1);
        double ratioWeight = 0.5 * ratioWeight1 + 0.5 * ratioWeight2;
        return ratioWeight;
    }

    public static Double getCvrFactor(AdvertSupportInfoV1 advertSupportInfo, double cost) {
        double costRatio = AdvertSupportV1.division(advertSupportInfo.getAdvert1Day().getOcpcConsume(), advertSupportInfo.getAdvert1Day().getCost());
        double tradeCvr = AdvertSupportV1.division(advertSupportInfo.getTradeAppConv().getOrDefault(advertSupportInfo.getPreType(), 0L), advertSupportInfo.getTradeAppClk());
        double cvrRatio = AdvertSupportV1.division(advertSupportInfo.getPreCvr(), (Double)tradeCvr);
        double cvrFactor = 1.0;
        if (costRatio > cost) {
            cvrFactor = Math.min(1.2, Math.max(cvrRatio, 0.8));
        }
        return cvrFactor;
    }

    public static Double getConfidenceWeight(Double value, Double[] bucketList, Double[] weightList, double defaultValue) {
        Double ret = defaultValue;
        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            int size = bucketList.length;
            for (int i = 0; i < size; ++i) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = weightList[0];
                    break;
                }
                if (i == size - 1) {
                    ret = weightList[size - 1];
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static double division(Long v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }

    public static double division(Double v1, Double v2) {
        return v1 != null && v2 != null && v2 != 0.0 ? v1 / v2 : 0.0;
    }

    public static double division(Long v1, Double v2) {
        return v1 != null && v2 != null && v2 != 0.0 ? v1.doubleValue() / v2 : 0.0;
    }

    public static void main(String[] args) {
        AdvertSupportInfoV1 info = new AdvertSupportInfoV1();
        info.setUpperLimit(2.0);
        info.setLowerLimit(1.0);
        info.setPreCvr(0.01);
        HashSet<Integer> convTypes = new HashSet<Integer>();
        convTypes.add(1);
        convTypes.add(3);
        info.setConvTypes(convTypes);
        SupportData advert3Day = new SupportData();
        advert3Day.setClick(10L);
        HashMap<Integer, Long> convs = new HashMap<Integer, Long>();
        convs.put(1, 50L);
        convs.put(3, 10L);
        advert3Day.setConv(convs);
        advert3Day.setExposure(100L);
        advert3Day.setConsume(100L);
        advert3Day.setCost(100.0);
        advert3Day.setCostBias(1.0);
        info.setAdvert3Day(advert3Day);
        info.setAdvert1Day(advert3Day);
        info.setRankScore1(22.0);
        info.setRankScore(16.0);
        info.setPreType(1);
        info.setTradeAppClk(100L);
        info.setTradeAppConv(convs);
        info.setAdvertConvLastDay(convs);
        info.setConvCnt(50L);
        info.setConvType(1);
        SupportParams params = new SupportParams();
        ArrayList<Double> supportRatioBucket = new ArrayList<Double>();
        supportRatioBucket.add(0.0);
        supportRatioBucket.add(0.1);
        supportRatioBucket.add(0.2);
        supportRatioBucket.add(0.3);
        supportRatioBucket.add(0.5);
        supportRatioBucket.add(0.8);
        supportRatioBucket.add(1.0);
        ArrayList<Double> supportRatioWeight = new ArrayList<Double>();
        supportRatioWeight.add(1.0);
        supportRatioWeight.add(0.9);
        supportRatioWeight.add(0.8);
        supportRatioWeight.add(0.7);
        supportRatioWeight.add(0.6);
        supportRatioWeight.add(0.5);
        supportRatioWeight.add(0.2);
        ArrayList<Double> rankRatioBucket = new ArrayList<Double>();
        rankRatioBucket.add(0.5);
        rankRatioBucket.add(0.6);
        rankRatioBucket.add(0.7);
        rankRatioBucket.add(0.8);
        rankRatioBucket.add(0.9);
        ArrayList<Double> rankRatioWeight = new ArrayList<Double>();
        rankRatioWeight.add(0.5);
        rankRatioWeight.add(0.6);
        rankRatioWeight.add(0.8);
        rankRatioWeight.add(1.0);
        rankRatioWeight.add(1.1);
        params.setSupportRatioBucket(supportRatioBucket);
        params.setSupportRatioWeight(supportRatioWeight);
        params.setRankRatioBucket(rankRatioBucket);
        params.setRankRatioWeight(rankRatioWeight);
        params.setCostRatio(1.25);
        params.setCons(0.8);
        AdvertSupportRes f = AdvertSupportV1.biddingFactorV1(info, params);
        System.out.println(JSON.toJSONString((Object)f));
    }
}

