/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.basepricecontrol;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceInfo;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceParams;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceResult;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePriceControl {
    private static final Logger logger = LoggerFactory.getLogger(BasePriceControl.class);

    public static BasePriceResult basePriceControl(BasePriceInfo basePriceInfo, BasePriceResult lastBasePriceResult, BasePriceParams basePriceParams) {
        BasePriceResult ret = new BasePriceResult();
        if (AssertUtil.isEmpty((Object)basePriceInfo)) {
            return ret;
        }
        if (Math.random() < 0.001) {
            logger.info("params basePriceParams:{}", (Object)basePriceParams);
        }
        try {
            ret = BasePriceControl.getBasePriceRatio(basePriceInfo);
        }
        catch (Exception e) {
            logger.warn("getBasePriceRatio happend error,lastBasePriceInfo={}", (Object)JSON.toJSONString((Object)basePriceInfo), (Object)e);
        }
        if (lastBasePriceResult != null) {
            ret.setGiveUpProb5(lastBasePriceResult.getGiveUpProb5());
            ret.setGiveUpProb10(lastBasePriceResult.getGiveUpProb10());
        }
        if (basePriceInfo.manageType == 2) {
            BasePriceControl.updateProb2(ret, basePriceParams);
        }
        if (basePriceInfo.manageType == 3) {
            BasePriceControl.updateProb3(ret, basePriceParams);
        }
        if (Math.random() < 0.001) {
            logger.info("basePriceControl GiveUpProb5:{} GiveUpProb10:{}", (Object)ret.getGiveUpProb5(), (Object)ret.getGiveUpProb10());
        }
        return ret;
    }

    public static void updateProb2(BasePriceResult basePriceResult, BasePriceParams basePriceParams) {
        Double totalFactor2;
        Double totalFactor;
        Double totalFactor1;
        Double giveUpProb10;
        Double ret5 = 0.2;
        Double ret10 = 0.2;
        Double totalLearnRate5 = basePriceParams.totalLearnRate2;
        Double totalLearnRate10 = basePriceParams.totalLearnRate2_2;
        Double giveUpLowerLimit = basePriceParams.giveUpLowerLimit2;
        Double giveUpUpperLimit = basePriceParams.giveUpUpperLimit2;
        Double level5RatioLimit = basePriceParams.level5RatioLimit2;
        Double level10RatioLimit = basePriceParams.level10RatioLimit2;
        if (basePriceResult == null) {
            return;
        }
        Double giveUpProb5 = basePriceResult.getGiveUpProb5();
        if (giveUpProb5 == null) {
            giveUpProb5 = 0.5;
        }
        if ((giveUpProb10 = basePriceResult.getGiveUpProb10()) == null) {
            giveUpProb10 = 0.4;
        }
        Double level5Ratio = basePriceResult.level5Ratio;
        Double level10Ratio = basePriceResult.level10Ratio;
        Double orientCostConvertBias = basePriceResult.orientCostConvertBias;
        if (level5Ratio >= level5RatioLimit) {
            totalFactor1 = MathBase.noiseSmoother(10.0 * level5Ratio, 0.2, 1.0);
            totalFactor = totalLearnRate5 + totalFactor1;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, 0.5, giveUpUpperLimit);
        }
        if (level10Ratio >= level10RatioLimit) {
            totalFactor2 = MathBase.noiseSmoother(10.0 * level10Ratio, 0.5, 1.0);
            totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, 0.5, giveUpUpperLimit);
        }
        if (level5Ratio < level5RatioLimit) {
            totalFactor1 = MathBase.noiseSmoother(10.0 * level5Ratio, 0.05, 0.5);
            totalFactor = totalLearnRate5 + totalFactor1;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, giveUpLowerLimit, 0.5);
        }
        if (level10Ratio < level10RatioLimit) {
            totalFactor2 = MathBase.noiseSmoother(10.0 * level10Ratio, 0.1, 0.8);
            totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, giveUpLowerLimit, 0.5);
        }
        ret5 = DataUtil.formatDouble((Double)ret5, (int)3);
        ret10 = DataUtil.formatDouble((Double)ret10, (int)3);
        basePriceResult.setGiveUpProb5(ret5);
        basePriceResult.setGiveUpProb10(ret10);
    }

    public static void updateProb3(BasePriceResult basePriceResult, BasePriceParams basePriceParams) {
        Double totalFactor2;
        Double totalFactor;
        Double totalFactor1;
        Double giveUpProb10;
        Double ret5 = 0.2;
        Double ret10 = 0.2;
        Double totalLearnRate5 = basePriceParams.totalLearnRate3;
        Double totalLearnRate10 = basePriceParams.totalLearnRate3_2;
        Double giveUpLowerLimit = basePriceParams.giveUpLowerLimit3;
        Double giveUpUpperLimit = basePriceParams.giveUpUpperLimit3;
        Double level5RatioLimit = basePriceParams.level5RatioLimit3;
        Double level10RatioLimit = basePriceParams.level10RatioLimit3;
        if (basePriceResult == null) {
            return;
        }
        Double giveUpProb5 = basePriceResult.getGiveUpProb5();
        if (giveUpProb5 == null) {
            giveUpProb5 = 0.5;
        }
        if ((giveUpProb10 = basePriceResult.getGiveUpProb10()) == null) {
            giveUpProb10 = 0.4;
        }
        Double level5Ratio = basePriceResult.level5Ratio;
        Double level10Ratio = basePriceResult.level10Ratio;
        Double orientCostConvertBias = basePriceResult.orientCostConvertBias;
        if (level5Ratio >= level5RatioLimit) {
            totalFactor1 = MathBase.noiseSmoother(10.0 * level5Ratio, 0.4, 1.0);
            totalFactor = totalLearnRate5 + totalFactor1;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, 0.5, giveUpUpperLimit);
        }
        if (level10Ratio >= level10RatioLimit) {
            totalFactor2 = MathBase.noiseSmoother(10.0 * level10Ratio, 0.8, 1.0);
            totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, 0.5, giveUpUpperLimit);
        }
        if (level5Ratio < level5RatioLimit) {
            totalFactor1 = MathBase.noiseSmoother(10.0 * level5Ratio, 0.1, 0.5);
            totalFactor = totalLearnRate5 + totalFactor1;
            ret5 = giveUpProb5 * totalFactor;
            ret5 = MathBase.noiseSmoother(ret5, giveUpLowerLimit, 0.5);
        }
        if (level10Ratio < level10RatioLimit) {
            totalFactor2 = MathBase.noiseSmoother(10.0 * level10Ratio, 0.2, 0.8);
            totalFactor = totalLearnRate10 + totalFactor2;
            ret10 = giveUpProb10 * totalFactor;
            ret10 = MathBase.noiseSmoother(ret10, giveUpLowerLimit, 0.5);
        }
        ret5 = DataUtil.formatDouble((Double)ret5, (int)3);
        ret10 = DataUtil.formatDouble((Double)ret10, (int)3);
        basePriceResult.setGiveUpProb5(ret5);
        basePriceResult.setGiveUpProb10(ret10);
    }

    public static BasePriceResult getBasePriceRatio(BasePriceInfo basePriceInfo) {
        BasePriceResult ret = new BasePriceResult();
        Double level5Ratio = 0.0;
        Double level10Ratio = 0.0;
        Double level15Ratio = 0.0;
        Double orientCostConvertToday = basePriceInfo.orientConvertToday != 0L ? (double)basePriceInfo.orientCostToday.longValue() / (double)basePriceInfo.orientConvertToday.longValue() : (double)basePriceInfo.orientCostToday.longValue();
        Double orientCostConvertBias = basePriceInfo.afee != 0L ? orientCostConvertToday / (double)basePriceInfo.afee.longValue() : 1.0;
        Double orientLevel5Ratio = 0.0;
        Double orientLevel10Ratio = 0.0;
        Double orientLevel15Ratio = 0.0;
        if (basePriceInfo.orientLaunchToday > 0L) {
            orientLevel5Ratio = (double)basePriceInfo.orientLevel5PriceLaunchToday.longValue() / (double)basePriceInfo.orientLaunchToday.longValue();
            orientLevel10Ratio = (double)basePriceInfo.orientLevel10PriceLaunchToday.longValue() / (double)basePriceInfo.orientLaunchToday.longValue();
            orientLevel15Ratio = (double)basePriceInfo.orientLevel15PriceLaunchToday.longValue() / (double)basePriceInfo.orientLaunchToday.longValue();
        }
        Double orientSlotLevel5Ratio = 0.0;
        Double orientSlotLevel10Ratio = 0.0;
        Double orientSlotLevel15Ratio = 0.0;
        if (basePriceInfo.orientSlotLaunchToday > 0L) {
            orientSlotLevel5Ratio = (double)basePriceInfo.orientSlotLevel5PriceLaunchToday.longValue() / (double)basePriceInfo.orientSlotLaunchToday.longValue();
            orientSlotLevel10Ratio = (double)basePriceInfo.orientSlotLevel10PriceLaunchToday.longValue() / (double)basePriceInfo.orientSlotLaunchToday.longValue();
            orientSlotLevel15Ratio = (double)basePriceInfo.orientSlotLevel15PriceLaunchToday.longValue() / (double)basePriceInfo.orientSlotLaunchToday.longValue();
        }
        if (basePriceInfo.orientLaunchToday > 200L) {
            if (basePriceInfo.orientSlotLaunchToday < 100L) {
                level5Ratio = orientLevel5Ratio;
                level10Ratio = orientLevel10Ratio;
                level15Ratio = orientLevel15Ratio;
            } else {
                level5Ratio = 0.7 * orientSlotLevel5Ratio + 0.3 * orientLevel5Ratio;
                level10Ratio = 0.7 * orientSlotLevel10Ratio + 0.3 * orientLevel10Ratio;
                level15Ratio = 0.7 * orientSlotLevel15Ratio + 0.3 * orientLevel15Ratio;
            }
        }
        ret.setLevel5Ratio(level5Ratio);
        ret.setLevel10Ratio(level10Ratio);
        ret.setLevel15Ratio(level15Ratio);
        ret.setOrientCostConvertBias(orientCostConvertBias);
        return ret;
    }

    public static Map<BasePriceInfo, BasePriceResult> basePriceControl(List<BasePriceInfo> basePriceInfoList, Map<BasePriceInfo, BasePriceResult> lastBasePriceResultMap, BasePriceParams basePriceParams) {
        HashMap<BasePriceInfo, BasePriceResult> ret = new HashMap<BasePriceInfo, BasePriceResult>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{basePriceInfoList, basePriceParams})) {
            return ret;
        }
        for (BasePriceInfo basePriceInfo : basePriceInfoList) {
            BasePriceResult result;
            BasePriceResult lastBasePriceResult = null;
            if (lastBasePriceResultMap != null) {
                lastBasePriceResult = lastBasePriceResultMap.get(basePriceInfo);
            }
            if ((result = BasePriceControl.basePriceControl(basePriceInfo, lastBasePriceResult, basePriceParams)) == null) continue;
            ret.put(basePriceInfo, result);
        }
        return ret;
    }

    public static <T> Map<T, Boolean> giveUpControl(Map<T, BasePriceResult> basePriceResultMap, Map<T, Long> finalFeeMap, Integer biddingAdvertNum) {
        HashMap<T, Boolean> ret = new HashMap<T, Boolean>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{basePriceResultMap})) {
            return ret;
        }
        for (Map.Entry<T, BasePriceResult> entry : basePriceResultMap.entrySet()) {
            T key = entry.getKey();
            BasePriceResult basePriceResult = entry.getValue();
            Double getGiveUpProb5 = basePriceResult.getGiveUpProb5();
            Double getGiveUpProb10 = basePriceResult.getGiveUpProb10();
            Long finalFee = finalFeeMap.get(key);
            Random r = new Random();
            Double x = r.nextDouble();
            Boolean giveUp = false;
            if (finalFee <= 5L && x <= getGiveUpProb5) {
                giveUp = true;
            }
            if (finalFee > 5L && finalFee <= 10L && x <= getGiveUpProb10) {
                giveUp = true;
            }
            if (giveUp == null) continue;
            ret.put(key, giveUp);
        }
        return ret;
    }
}

