package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd;

import cn.com.duiba.nezha.alg.feature.vo.AdxIdeaMaterialDo;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


/**
 * 创意特征对象
 *
 */
@Data
public class AdxIdeaFeatureDo implements Serializable {


    /**
     * 创意特征
     */
    private Long groupId; //组

    private Long resourceId;//资源位

    private Long ideaId;//创意ID

    private Long materialId;//素材ID

    private String buttonText; // 按钮文字 f3010020
    private Integer iconH; // 创意图标高 f3010030
    private Integer iconW; // 创意图标宽 f3010040
    private Integer mjPicType; // 规格类型 f3010050
    private Integer ideaPicH1; // 创意图片高1 f3010060
    private Integer ideaPicW1; // 创意图片宽1 f3010070
    private Integer ideaPicH2; // 创意图片高2 f3010080
    private Integer ideaPicW2; // 创意图片宽2 f3010090
    private Integer ideaPicH3; // 创意图片高3 f3010100
    private Integer ideaPicW3; // 创意图片宽3 f3010110
    private Integer ideaPicNum; // 创意图片个数 f3010120
    private Integer styleStandard; // 广告样式规格 f3010130
    private Integer ideaType; // 互动创意类型(0-静态创意，1-动态创意) f3010140

    //创意素材标签特征
    private Integer pictureType; //素材图片类型（1=图片 3=视频）f3030000
    private List<AdxIdeaMaterialDo> pictureMaterialDo; //图片素材特征
    private List<AdxIdeaMaterialDo> videoMaterialDo; //视频素材特征

    //创意+分媒体行为特征
    private Long ideaAppExpCntDay; //创意+百度appId 当天曝光次数 f3060011
    private Long ideaAppClickCntDay; //创意+百度appId 当天点击次数 f3060012
    private Long ideaAppAdCostDay; //创意+百度appId 当天广告消耗	 f3060013

    //创意+活动特征
    private Long ideaActAccCntDay;   //创意 当天活动访问次数
    private Long ideaActJoinCntDay;   //创意 当天活动参与次数
    private Long ideaActAccCntWeek;   //创意 当天活动访问次数
    private Long ideaActJoinCntWeek;   //创意 当天活动参与次数

    //活动+创意行为数据
    private Map<Long, Long> actIdeaActAccCntDay;    //活动+创意 活动访问数据
    private Map<Long, Long> actIdeaActJoinCntDay;    //活动+创意 活动参与数据
    private Map<Long, Long> actIdeaActAccCntWeek;    //活动+创意 活动访问数据
    private Map<Long, Long> actIdeaActJoinCntWeek;    //活动+创意 活动参与数据



    /**
     * 算法内部计算，不需要填写
     */

    private Double mergeRpm;//模型融合收益
    private Double pRpm; //模型预估收益 打印
    private Double sRpm; //模型预估收益 打印

    private AdxIdeaParamsDo adxIdeaParamsDo;



    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getIdeaId() {
        return ideaId;
    }

    public void setIdeaId(Long ideaId) {
        this.ideaId = ideaId;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public Integer getIconH() {
        return iconH;
    }

    public void setIconH(Integer iconH) {
        this.iconH = iconH;
    }

    public Integer getIconW() {
        return iconW;
    }

    public void setIconW(Integer iconW) {
        this.iconW = iconW;
    }

    public Integer getMjPicType() {
        return mjPicType;
    }

    public void setMjPicType(Integer mjPicType) {
        this.mjPicType = mjPicType;
    }

    public Integer getIdeaPicH1() {
        return ideaPicH1;
    }

    public void setIdeaPicH1(Integer ideaPicH1) {
        this.ideaPicH1 = ideaPicH1;
    }

    public Integer getIdeaPicW1() {
        return ideaPicW1;
    }

    public void setIdeaPicW1(Integer ideaPicW1) {
        this.ideaPicW1 = ideaPicW1;
    }

    public Integer getIdeaPicH2() {
        return ideaPicH2;
    }

    public void setIdeaPicH2(Integer ideaPicH2) {
        this.ideaPicH2 = ideaPicH2;
    }

    public Integer getIdeaPicW2() {
        return ideaPicW2;
    }

    public void setIdeaPicW2(Integer ideaPicW2) {
        this.ideaPicW2 = ideaPicW2;
    }

    public Integer getIdeaPicH3() {
        return ideaPicH3;
    }

    public void setIdeaPicH3(Integer ideaPicH3) {
        this.ideaPicH3 = ideaPicH3;
    }

    public Integer getIdeaPicW3() {
        return ideaPicW3;
    }

    public void setIdeaPicW3(Integer ideaPicW3) {
        this.ideaPicW3 = ideaPicW3;
    }

    public Integer getIdeaPicNum() {
        return ideaPicNum;
    }

    public void setIdeaPicNum(Integer ideaPicNum) {
        this.ideaPicNum = ideaPicNum;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public void setStyleStandard(Integer styleStandard) {
        this.styleStandard = styleStandard;
    }

    public List<AdxIdeaMaterialDo> getPictureMaterialDo() { return pictureMaterialDo; }

    public void setPictureMaterialDo(List<AdxIdeaMaterialDo> pictureMaterialDo) { this.pictureMaterialDo = pictureMaterialDo; }

    public List<AdxIdeaMaterialDo> getVideoMaterialDo() { return videoMaterialDo; }

    public void setVideoMaterialDo(List<AdxIdeaMaterialDo> videoMaterialDo) { this.videoMaterialDo = videoMaterialDo; }

    public Double getMergeRpm() {
        return mergeRpm;
    }

    public void setMergeRpm(Double mergeRpm) {
        this.mergeRpm = mergeRpm;
    }

    public Double getPRpm() {
        return pRpm;
    }

    public void setPRpm(Double pRpm) {
        this.pRpm = pRpm;
    }

    public Double getSRpm() {
        return sRpm;
    }

    public void setSRpm(Double sRpm) {
        this.sRpm = sRpm;
    }

    public AdxIdeaParamsDo getAdxIdeaParamsDo() {
        return adxIdeaParamsDo;
    }

    public void setAdxIdeaParamsDo(AdxIdeaParamsDo adxIdeaParamsDo) {
        this.adxIdeaParamsDo = adxIdeaParamsDo;
    }
}
