package cn.com.duiba.nezha.alg.alg.vo.adx.rtb2;

import lombok.Data;

import java.io.Serializable;

@Data
public class AdxRtbBidRequestDo implements Serializable {

    /**
     * 推广组ID
     */
    private Long groupId;

    /**
     * 资源位ID
     */
    private Long resourceId;

    /**
     * 创意ID
     */
    private Long ideaId;

    /**
     * app ID
     */
    private String appId;

    /**
     * 出价方式：1-roi出价、2-cpc出价
     */
    private Integer bidMode;

    /**
     * 目标roi
     */
    private Double roi;

    /**
     * 目标cpc
     */
    private Double cpc;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 预估点击价值
     */
    private Double clickValue;

    /**
     * 维稳参数对象
     */
    private AdxFactorDo adxFactorDo;

    /**
     * 实验分组ID
     * 1、2 老接口
     * 3、4 新接口
     */
    private Integer groupTag;

}
