/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rtbbid;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class AdxBidding {
    public static Long getAdxParPrice(AdxDo adxDoInfo, Double roiFactor, Map<String, Long> advertConsume) {
        Double defaultMinRoi = 1.0;
        Double defaultRoiFactor = 1.0;
        Double lowerLimit = 0.3;
        Double upperLimit = 1.7;
        Double defaultPreCtr = 0.01;
        Double defaultClickValue = 5.0;
        Long advertConsumeDayLimit = 500L;
        Long advertConsumeMsLimit = 500L;
        Long ret = Math.round(Math.floor(defaultPreCtr * defaultClickValue * 1000.0 / (defaultMinRoi * defaultRoiFactor)));
        if (AssertUtil.isNotEmpty((Object)adxDoInfo)) {
            Integer groupTag;
            Long groupId;
            Double statCtr = adxDoInfo.getStatCtr();
            Double statCtrResource = adxDoInfo.getStatCtrResource();
            Double currentPreValue = adxDoInfo.getPreCtr();
            Double ideaAppStatCtr = adxDoInfo.getIdeaAppStatCtr();
            Double resoAppStatCtr = adxDoInfo.getResoAppStatCtr();
            Double statClickValue = adxDoInfo.getStatClickValue();
            Double statClickValueResource = adxDoInfo.getStatClickValueResource();
            Double preAdClickValue = adxDoInfo.getPredClickValue();
            Double recTfPreClickValue = adxDoInfo.getRecTfPreClickValue();
            Double ideaAppStatCva = adxDoInfo.getIdeaAppStatCva();
            Double resoAppStatCva = adxDoInfo.getResoAppStatCva();
            if (statCtrResource == null || statCtrResource < 0.0) {
                statCtrResource = defaultPreCtr;
            }
            if (statCtr == null || statCtr < 0.0) {
                statCtr = statCtrResource;
            }
            if (statClickValueResource == null || statClickValueResource < 0.0) {
                statClickValueResource = defaultClickValue;
            }
            if (statClickValue == null || statClickValue < 0.0) {
                statClickValue = statClickValueResource;
            }
            Double statConCtr = statCtr;
            Double statConCva = statClickValue;
            if (AssertUtil.isNotEmpty(advertConsume)) {
                Long ideaAdvertConsumeDay = StrategyBid.nullToDefault(advertConsume.get("ideaDay"), 0L);
                Long ideaAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("ideaMs"), 0L);
                Long resoAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("resourceMs"), 0L);
                statConCtr = DataUtil.division((Double)((double)ideaAdvertConsumeMs.longValue() * statCtr + (double)advertConsumeMsLimit.longValue() * statCtrResource), (Long)(ideaAdvertConsumeMs + advertConsumeMsLimit), (int)6);
                statConCva = DataUtil.division((Double)((double)ideaAdvertConsumeMs.longValue() * statClickValue + (double)advertConsumeMsLimit.longValue() * statClickValueResource), (Long)(ideaAdvertConsumeMs + advertConsumeMsLimit), (int)6);
                if (ideaAdvertConsumeDay < advertConsumeDayLimit) {
                    statConCtr = statCtrResource;
                    statConCva = statClickValueResource;
                }
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{groupId = adxDoInfo.getGroupId(), groupTag = adxDoInfo.getGroupTag()}) && groupId.equals(129L) && groupTag.equals(2)) {
                Double[] ctrDefaultList = new Double[]{resoAppStatCtr, statConCtr};
                statConCtr = AdxStatData.nullToDefaultList(ideaAppStatCtr, ctrDefaultList);
                Double[] cvaDefaultList = new Double[]{resoAppStatCva, statConCva};
                statConCva = AdxStatData.nullToDefaultList(ideaAppStatCva, cvaDefaultList);
            }
            if (preAdClickValue != null && preAdClickValue >= 0.0) {
                statConCva = StrategyBid.getNormalValue(preAdClickValue, statConCva, statConCva * 0.0, statConCva * 4.0);
            }
            Double conCtr = AdxStatData.getConCtr(currentPreValue, statConCtr, 0.8, 0.0, 4.0, 0.02);
            Double preCvaWeight = 0.0;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{groupId, groupTag}) && groupId.equals(129L) && groupTag.equals(2)) {
                preCvaWeight = 0.2;
            }
            Double conCva = AdxStatData.getConValue(recTfPreClickValue, statConCva, preCvaWeight, 0.0, 2.0, 1.0);
            roiFactor = StrategyBid.getNormalValue(roiFactor, defaultRoiFactor, lowerLimit, upperLimit);
            Double minRoi = StrategyBid.nullToDefault(adxDoInfo.getMinRoi(), defaultMinRoi);
            ret = Math.round(Math.floor(conCtr * conCva * 1000.0 / (minRoi * roiFactor)));
        }
        return ret;
    }

    public static Double getConCtr(Double statValue, Double modelPreValue) {
        Double preCtrFactor = 0.8;
        Double defaultCtr = 0.01;
        Double fUpperLimit = 4.0;
        Double fLowerLimit = 0.0;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        statValue = StrategyBid.getNormalValue(statValue, defaultCtr, vLowerLimit, vUpperLimit);
        modelPreValue = StrategyBid.getNormalValue(modelPreValue, statValue, statValue * fLowerLimit, statValue * fUpperLimit);
        Double ret = preCtrFactor * modelPreValue + (1.0 - preCtrFactor) * statValue;
        ret = ret < vLowerLimit ? vLowerLimit : (ret > vUpperLimit ? vUpperLimit : ret);
        return ret;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Long> advertConsumeInfo = new HashMap<String, Long>();
            advertConsumeInfo.put("ideaDay", 2000L);
            advertConsumeInfo.put("ideaMs", 2000L);
            advertConsumeInfo.put("resourceMs", 2000L);
            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setMinRoi(1.0);
            adxDoInfo1.setPreCtr(0.50164);
            adxDoInfo1.setStatCtr(0.953488372);
            adxDoInfo1.setStatClickValue(0.341463415);
            adxDoInfo1.setStatCtrResource(0.978723404);
            adxDoInfo1.setStatClickValueResource(0.25);
            adxDoInfo1.setPredClickValue(null);
            Double roiFactor = 1.0;
            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo1, roiFactor, advertConsumeInfo);
            System.out.println("testGetAdxParPrice:" + JSON.toJSONString((Object)testParPrice));
            System.out.println("getConCtr:" + JSON.toJSONString((Object)AdxBidding.getConCtr(0.6, 0.1)));
            ArrayList<Long> ideaMaList = new ArrayList<Long>();
            ideaMaList.add(1L);
            ideaMaList.add(2L);
            int randomInd = ThreadLocalRandom.current().nextInt(0, ideaMaList.size());
            System.out.println("11:" + JSON.toJSONString((Object)randomInd));
            System.out.println("11:" + JSON.toJSONString(ideaMaList.get(randomInd)));
            int randomInd1 = ThreadLocalRandom.current().nextInt(0, ideaMaList.size());
            System.out.println("11:" + JSON.toJSONString((Object)randomInd1));
            System.out.println("11:" + JSON.toJSONString(ideaMaList.get(randomInd1)));
            Double[] rankScoreList = new Double[]{1.1, 0.01, 1.1, 0.015};
            Integer[] expCntList = new Integer[]{3, 100, 0, 0};
            double tmpScore = -1000000.0;
            Integer n = null;
            for (int i = 0; i < rankScoreList.length; ++i) {
                Double rankScore = rankScoreList[i];
                Integer expCnt = expCntList[i];
                Double reRankScore = rankScore >= 0.0 ? rankScore * DataUtil.division((Long)10L, (Long)(10L + (long)expCnt.intValue())) : rankScore * (2.0 - DataUtil.division((Long)10L, (Long)(10L + (long)expCnt.intValue())));
                System.out.println("112:" + JSON.toJSONString((Object)rankScore) + "," + JSON.toJSONString((Object)reRankScore));
                if (!(reRankScore > tmpScore)) continue;
                tmpScore = reRankScore;
                n = i;
            }
            System.out.println("113:" + JSON.toJSONString(n));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

