package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class DeepControlParams {

    /**
     * 深度 双出价 控制参数
     */
    private Double deepFactor; //深度目标调价因子

    private Double confWeight;//预估置信权重

    private Double preMergeWeight;//预估融合权重

    private Double preMergeDiffU;//预估偏离统计上限 1.2
    private Double preMergeDiffL;//预估偏离统计下限 0.9

    private Integer controlType; //实际控制类型 1：成本优先  2：消耗优先  3：延迟类型处理

    private Double slotStatDcvr; //配置+广告位，离线统计转化率
    private Double pkStatDcvr; //配置，离线统计转化率


    private String updateTime;// 更新时间


    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static Double getDeepFactor(DeepControlParams params) {

        Double ret = null;

        if (params != null) {
            ret = params.getDeepFactor();
        }

        return ret;
    }


    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static Double getDeepFactor(DeepControlParams params, Long deepFee, Long aFee, Double preDcvr) {

        Double ret = null;

        if (params == null || params.getDeepFactor() == null) {
            return ret;
        }

        ret = params.getDeepFactor();

        Integer controlType = params.getControlType();
        Double confWeight = params.getConfWeight();

        Double preMergeWeight = params.getPreMergeWeight();

        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();

        if (AssertUtil.isAllNotEmpty(confWeight, controlType, preDcvr, deepFee, aFee, preMergeWeight, preMergeDiffU, preMergeDiffL)) {

            Double statFactor = params.getDeepFactor();
            Double preFactor = deepFee * preDcvr / aFee;
            /**
             * 置信衰减
             */
            preFactor = 1.0 + confWeight * (preFactor - 1.0);

            /**
             * 模式1
             * preMergeDiffL=0.9  preMergeDiffU=1.2  preMergeWeight=0.5
             *
             * 模式2
             * preMergeDiffL=0.95  preMergeDiffU=1.2  preMergeWeight=0.5
             *
             * 模式3延迟自定义
             * preMergeDiffL=1.0  preMergeDiffU=1.0  preMergeWeight=0.0
             *
             */
            preFactor = MathUtil.stdwithBoundary(preFactor, statFactor * preMergeDiffL, statFactor * preMergeDiffU);
            ret = preMergeWeight * preFactor + (1 - preMergeWeight) * statFactor;
            ret = MathUtil.formatDouble(ret, 5);

        }
        return ret;
    }


    public static void main(String args){

        DeepControlParams params =new DeepControlParams();
    }

}
