package cn.com.duiba.nezha.alg.alg.adx.directly2;

import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyPkDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxDirectlyPkReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.ExploreFactor;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxRtbBidRequestDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.toList;

public class AdxDirectlyPk2 {

    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyPk2.class);

    /**
     * 直投、互动pk接口
     * @param adxDirectlyPkReqDo
     * @return
     */
    public static AdxDirectlyPkDo getPk(AdxDirectlyPkReqDo adxDirectlyPkReqDo) {

        AdxDirectlyPkDo adxDirectlyPkDo = new AdxDirectlyPkDo();

        try{
            Long resourceId = adxDirectlyPkReqDo.getResourceId();
            String appId = adxDirectlyPkReqDo.getAppId();
            List<AdxIdeaDo> adxIdeaDos = adxDirectlyPkReqDo.getAdxIdeaDos();
            ExploreFactor eFactor = adxDirectlyPkReqDo.getEFactor();

            /**
             * 探索概率
             */
            Double factor = ExploreFactor.getEFactor(eFactor, resourceId, appId);
            if(factor == null) {factor = 0.3;}

            setIdeaEcpm(adxIdeaDos, appId, eFactor, adxDirectlyPkDo);
            Long ideaId = rank(adxIdeaDos, factor);

            adxDirectlyPkDo.setIdeaId(ideaId);
        }catch(Exception e){
            logger.info("AdxDirectlyPkDo.getPk Error", e);
        }

        return adxDirectlyPkDo;

    }

    public static void setIdeaEcpm(List<AdxIdeaDo> adxIdeaDos, String appId, ExploreFactor eFactor, AdxDirectlyPkDo adxDirectlyPkDo) {
        for(AdxIdeaDo adxIdeaDo : adxIdeaDos) {
            Long ideaId = adxIdeaDo.getIdeaId();
            Double ecpm = ExploreFactor.getIdeaStat(eFactor, ideaId, appId);
            adxIdeaDo.setEcpm(ecpm);

            if(adxIdeaDo.getPriceType() == 2) {
                adxDirectlyPkDo.setDirectlyPrice(adxIdeaDo.getPrice().longValue());
            }else{
                adxDirectlyPkDo.setInterPrice(adxIdeaDo.getPrice().longValue());
            }

        }
    }

    public static Long rank(List<AdxIdeaDo> adxIdeaDos, Double exploreRate) {

        Long ideaId= null;
        Map<Long, Double> ecpms = adxIdeaDos.stream().collect(Collectors.toMap(AdxIdeaDo::getIdeaId, AdxIdeaDo::getEcpm));

        Double ramdom = Math.random();

        if(ramdom < exploreRate) {
            ideaId = Roulette.doubleMap(ecpms);
        }else {
            adxIdeaDos = adxIdeaDos.stream().
                    sorted(comparing(AdxIdeaDo :: getPrice).reversed()).collect(toList());
            ideaId = adxIdeaDos.get(0).getIdeaId();
        }

        return ideaId;
    }

    public void valid(AdxDirectlyPkReqDo adxDirectlyPkReqDo) {
        if(AssertUtil.isAnyEmpty(adxDirectlyPkReqDo.getResourceId(), adxDirectlyPkReqDo.getEFactor(), adxDirectlyPkReqDo.getAdxIdeaDos())) {
            logger.warn("AdxDirectlyPkDo.getPk params not valid, resId={}, adxIdeaDos={}", adxDirectlyPkReqDo.getResourceId(), adxDirectlyPkReqDo.getAdxIdeaDos());
        }
    }
}
