/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly2;

import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyPkDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxDirectlyPkReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.ExploreFactor;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxDirectlyPk2 {
    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyPk2.class);

    public static AdxDirectlyPkDo getPk(AdxDirectlyPkReqDo adxDirectlyPkReqDo) {
        AdxDirectlyPkDo adxDirectlyPkDo = new AdxDirectlyPkDo();
        try {
            Long resourceId = adxDirectlyPkReqDo.getResourceId();
            String appId = adxDirectlyPkReqDo.getAppId();
            List<AdxIdeaDo> adxIdeaDos = adxDirectlyPkReqDo.getAdxIdeaDos();
            ExploreFactor eFactor = adxDirectlyPkReqDo.getEFactor();
            boolean isTest = adxDirectlyPkReqDo.isTest();
            Integer groupTag = Optional.ofNullable(adxDirectlyPkReqDo.getGroupTag()).orElse(0);
            Double factor = ExploreFactor.getEFactor(eFactor, resourceId, appId);
            if (factor == null) {
                factor = 0.3;
            }
            AdxDirectlyPk2.setIdeaEcpm(adxIdeaDos, appId, eFactor, adxDirectlyPkDo);
            Long ideaId = AdxDirectlyPk2.rank(adxIdeaDos, factor, isTest, groupTag);
            adxDirectlyPkDo.setIdeaId(ideaId);
        }
        catch (Exception e) {
            logger.info("AdxDirectlyPkDo.getPk Error", (Throwable)e);
        }
        return adxDirectlyPkDo;
    }

    public static void setIdeaEcpm(List<AdxIdeaDo> adxIdeaDos, String appId, ExploreFactor eFactor, AdxDirectlyPkDo adxDirectlyPkDo) {
        for (AdxIdeaDo adxIdeaDo : adxIdeaDos) {
            Long ideaId = adxIdeaDo.getIdeaId();
            Double ecpm = ExploreFactor.getIdeaStat(eFactor, ideaId, appId);
            adxIdeaDo.setEcpm(ecpm);
            if (adxIdeaDo.getPriceType() == 2L) {
                adxDirectlyPkDo.setDirectlyPrice(adxIdeaDo.getPrice().longValue());
                continue;
            }
            adxDirectlyPkDo.setInterPrice(adxIdeaDo.getPrice().longValue());
        }
    }

    public static Long rank(List<AdxIdeaDo> adxIdeaDos, Double exploreRate, boolean isTest, Integer groupTag) {
        Long ideaId = null;
        if (adxIdeaDos.size() != 2) {
            logger.warn("AdxDirectlyPk2.getPk adxIdeaDos size is {}", (Object)adxIdeaDos.size());
            return adxIdeaDos.get(0).getIdeaId();
        }
        if (isTest && (groupTag == 3 || groupTag == 4)) {
            ideaId = groupTag == 3 ? (Long)adxIdeaDos.stream().filter(s -> s.getPriceType() == 0L || s.getPriceType() == 1L).map(AdxIdeaDo::getIdeaId).collect(Collectors.toList()).get(0) : (Long)adxIdeaDos.stream().filter(s -> s.getPriceType() == 2L).map(AdxIdeaDo::getIdeaId).collect(Collectors.toList()).get(0);
            return ideaId;
        }
        Map<Long, Double> ecpms = adxIdeaDos.stream().collect(Collectors.toMap(AdxIdeaDo::getIdeaId, AdxIdeaDo::getEcpm));
        Double ramdom = Math.random();
        if (ramdom < exploreRate) {
            ideaId = Roulette.doubleMap(ecpms);
        } else {
            adxIdeaDos = adxIdeaDos.stream().sorted(Comparator.comparing(AdxIdeaDo::getPrice).reversed()).collect(Collectors.toList());
            ideaId = adxIdeaDos.get(0).getIdeaId();
        }
        return ideaId;
    }

    public void valid(AdxDirectlyPkReqDo adxDirectlyPkReqDo) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxDirectlyPkReqDo.getResourceId(), adxDirectlyPkReqDo.getEFactor(), adxDirectlyPkReqDo.getAdxIdeaDos()})) {
            logger.warn("AdxDirectlyPkDo.getPk params not valid, resId={}, adxIdeaDos={}", (Object)adxDirectlyPkReqDo.getResourceId(), adxDirectlyPkReqDo.getAdxIdeaDos());
        }
    }
}

