/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class DeepControlParams {
    private Double deepFactor;
    private Double limitDeepFactor;
    private Double confWeight;
    private Double preMergeWeight;
    private Double preMergeDiffU;
    private Double preMergeDiffL;
    private Integer controlType;
    private Double slotStatDcvr;
    private Double pkStatDcvr;
    private String updateTime;

    public static Double getDeepFactor(DeepControlParams params) {
        Double ret = null;
        if (params != null) {
            ret = params.getDeepFactor();
        }
        return ret;
    }

    public static Double getDeepFactor(DeepControlParams params, Long deepFee, Long aFee, Double preDcvr, Integer appLimitReleaseMark) {
        Double preMergeDiffL;
        Double preMergeDiffU;
        Double preMergeWeight;
        Double ret = null;
        if (params == null || params.getDeepFactor() == null) {
            return ret;
        }
        ret = params.getDeepFactor();
        Double statFactor = params.getDeepFactor();
        if (appLimitReleaseMark != null && appLimitReleaseMark.equals(1) && params.getLimitDeepFactor() != null) {
            ret = params.getLimitDeepFactor();
            statFactor = params.getLimitDeepFactor();
        }
        Integer controlType = params.getControlType();
        Double confWeight = params.getConfWeight();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{confWeight, controlType, preDcvr, deepFee, aFee, preMergeWeight = params.getPreMergeWeight(), preMergeDiffU = params.getPreMergeDiffU(), preMergeDiffL = params.getPreMergeDiffL()})) {
            Double preFactor = (double)deepFee.longValue() * preDcvr / (double)aFee.longValue();
            preFactor = 1.0 + confWeight * (preFactor - 1.0);
            preFactor = MathUtil.stdwithBoundary((double)preFactor, (double)(statFactor * preMergeDiffL), (double)(statFactor * preMergeDiffU));
            ret = preMergeWeight * preFactor + (1.0 - preMergeWeight) * statFactor;
            ret = MathUtil.formatDouble((double)ret, (int)5);
        }
        return ret;
    }

    public static void main(String args) {
        DeepControlParams params = new DeepControlParams();
    }

    public Double getDeepFactor() {
        return this.deepFactor;
    }

    public Double getLimitDeepFactor() {
        return this.limitDeepFactor;
    }

    public Double getConfWeight() {
        return this.confWeight;
    }

    public Double getPreMergeWeight() {
        return this.preMergeWeight;
    }

    public Double getPreMergeDiffU() {
        return this.preMergeDiffU;
    }

    public Double getPreMergeDiffL() {
        return this.preMergeDiffL;
    }

    public Integer getControlType() {
        return this.controlType;
    }

    public Double getSlotStatDcvr() {
        return this.slotStatDcvr;
    }

    public Double getPkStatDcvr() {
        return this.pkStatDcvr;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setDeepFactor(Double deepFactor) {
        this.deepFactor = deepFactor;
    }

    public void setLimitDeepFactor(Double limitDeepFactor) {
        this.limitDeepFactor = limitDeepFactor;
    }

    public void setConfWeight(Double confWeight) {
        this.confWeight = confWeight;
    }

    public void setPreMergeWeight(Double preMergeWeight) {
        this.preMergeWeight = preMergeWeight;
    }

    public void setPreMergeDiffU(Double preMergeDiffU) {
        this.preMergeDiffU = preMergeDiffU;
    }

    public void setPreMergeDiffL(Double preMergeDiffL) {
        this.preMergeDiffL = preMergeDiffL;
    }

    public void setControlType(Integer controlType) {
        this.controlType = controlType;
    }

    public void setSlotStatDcvr(Double slotStatDcvr) {
        this.slotStatDcvr = slotStatDcvr;
    }

    public void setPkStatDcvr(Double pkStatDcvr) {
        this.pkStatDcvr = pkStatDcvr;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeepControlParams)) {
            return false;
        }
        DeepControlParams other = (DeepControlParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$deepFactor = this.getDeepFactor();
        Double other$deepFactor = other.getDeepFactor();
        if (this$deepFactor == null ? other$deepFactor != null : !((Object)this$deepFactor).equals(other$deepFactor)) {
            return false;
        }
        Double this$limitDeepFactor = this.getLimitDeepFactor();
        Double other$limitDeepFactor = other.getLimitDeepFactor();
        if (this$limitDeepFactor == null ? other$limitDeepFactor != null : !((Object)this$limitDeepFactor).equals(other$limitDeepFactor)) {
            return false;
        }
        Double this$confWeight = this.getConfWeight();
        Double other$confWeight = other.getConfWeight();
        if (this$confWeight == null ? other$confWeight != null : !((Object)this$confWeight).equals(other$confWeight)) {
            return false;
        }
        Double this$preMergeWeight = this.getPreMergeWeight();
        Double other$preMergeWeight = other.getPreMergeWeight();
        if (this$preMergeWeight == null ? other$preMergeWeight != null : !((Object)this$preMergeWeight).equals(other$preMergeWeight)) {
            return false;
        }
        Double this$preMergeDiffU = this.getPreMergeDiffU();
        Double other$preMergeDiffU = other.getPreMergeDiffU();
        if (this$preMergeDiffU == null ? other$preMergeDiffU != null : !((Object)this$preMergeDiffU).equals(other$preMergeDiffU)) {
            return false;
        }
        Double this$preMergeDiffL = this.getPreMergeDiffL();
        Double other$preMergeDiffL = other.getPreMergeDiffL();
        if (this$preMergeDiffL == null ? other$preMergeDiffL != null : !((Object)this$preMergeDiffL).equals(other$preMergeDiffL)) {
            return false;
        }
        Integer this$controlType = this.getControlType();
        Integer other$controlType = other.getControlType();
        if (this$controlType == null ? other$controlType != null : !((Object)this$controlType).equals(other$controlType)) {
            return false;
        }
        Double this$slotStatDcvr = this.getSlotStatDcvr();
        Double other$slotStatDcvr = other.getSlotStatDcvr();
        if (this$slotStatDcvr == null ? other$slotStatDcvr != null : !((Object)this$slotStatDcvr).equals(other$slotStatDcvr)) {
            return false;
        }
        Double this$pkStatDcvr = this.getPkStatDcvr();
        Double other$pkStatDcvr = other.getPkStatDcvr();
        if (this$pkStatDcvr == null ? other$pkStatDcvr != null : !((Object)this$pkStatDcvr).equals(other$pkStatDcvr)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeepControlParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $deepFactor = this.getDeepFactor();
        result = result * 59 + ($deepFactor == null ? 43 : ((Object)$deepFactor).hashCode());
        Double $limitDeepFactor = this.getLimitDeepFactor();
        result = result * 59 + ($limitDeepFactor == null ? 43 : ((Object)$limitDeepFactor).hashCode());
        Double $confWeight = this.getConfWeight();
        result = result * 59 + ($confWeight == null ? 43 : ((Object)$confWeight).hashCode());
        Double $preMergeWeight = this.getPreMergeWeight();
        result = result * 59 + ($preMergeWeight == null ? 43 : ((Object)$preMergeWeight).hashCode());
        Double $preMergeDiffU = this.getPreMergeDiffU();
        result = result * 59 + ($preMergeDiffU == null ? 43 : ((Object)$preMergeDiffU).hashCode());
        Double $preMergeDiffL = this.getPreMergeDiffL();
        result = result * 59 + ($preMergeDiffL == null ? 43 : ((Object)$preMergeDiffL).hashCode());
        Integer $controlType = this.getControlType();
        result = result * 59 + ($controlType == null ? 43 : ((Object)$controlType).hashCode());
        Double $slotStatDcvr = this.getSlotStatDcvr();
        result = result * 59 + ($slotStatDcvr == null ? 43 : ((Object)$slotStatDcvr).hashCode());
        Double $pkStatDcvr = this.getPkStatDcvr();
        result = result * 59 + ($pkStatDcvr == null ? 43 : ((Object)$pkStatDcvr).hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        return result;
    }

    public String toString() {
        return "DeepControlParams(deepFactor=" + this.getDeepFactor() + ", limitDeepFactor=" + this.getLimitDeepFactor() + ", confWeight=" + this.getConfWeight() + ", preMergeWeight=" + this.getPreMergeWeight() + ", preMergeDiffU=" + this.getPreMergeDiffU() + ", preMergeDiffL=" + this.getPreMergeDiffL() + ", controlType=" + this.getControlType() + ", slotStatDcvr=" + this.getSlotStatDcvr() + ", pkStatDcvr=" + this.getPkStatDcvr() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

