package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.*;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.extern.slf4j.Slf4j;


@Slf4j
public class DeepBidControl {

    //普通情况下的计算双出价因子方法，其中的各个数字为离线取数所得或人工设置
    public static DeepControlFactors calculateNormal(Long deepFee, Long aFee, Double preDcvr, Double confWeight,
                                                     Double preMergeWeight,
                                                     Double statFactor) {


        DeepControlFactors retDto = new DeepControlFactors();
        //默认取统计因子
        Double ret = statFactor;
        //由于统计因子瞄准目标有1.15变成了1.05，预估因子这边也从1.25降至1.18，先少降点
        Double preFactor = 1.18 * deepFee * preDcvr / aFee;

        preFactor = MathUtil.stdwithBoundary(preFactor, 0.1, 1.8);
        Double conFactor = (confWeight * preMergeWeight) * preFactor + (1 - confWeight * preMergeWeight) * statFactor;
        //根据离线数据取来的，当预估因子大于1.6时还有8%的加价空间，利用preMergeWeight实现对照组不生效，现在实验组对照组都走模型了，所以都生效了
        Double goodFactor = preMergeWeight > 0.1 ? 1.08 : 1.0;

        if (preFactor < 1.0) {
            ret = statFactor;
        } else if (preFactor > 1.6) {
            ret = Math.max(goodFactor * conFactor, statFactor);
        } else {
            ret = Math.max(conFactor, statFactor);
        }
        ret = MathUtil.formatDouble(MathUtil.stdwithBoundary(ret, 0.5, 1.8), 5);
        preFactor = MathUtil.formatDouble(preFactor, 5);
        retDto.setDeepFactor(ret);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        return retDto;

    }

    //高成本广告位所用的计算双出价因子方式，主要区别在于预估值较低时可以降价
    public static DeepControlFactors calculateHighCost(Long deepFee, Long aFee, Double preDcvr, Double confWeight,
                                                       Double preMergeWeight,
                                                       Double statFactor) {


        DeepControlFactors retDto = new DeepControlFactors();
        //默认取统计因子
        Double ret = statFactor;
        //由于统计因子瞄准目标有1.15变成了1.05，预估因子这边也从1.25降至1.18，先少降点
        Double preFactor = 1.18 * deepFee * preDcvr / aFee;

        preFactor = MathUtil.stdwithBoundary(preFactor, 0.1, 1.8);
        Double conFactor = (confWeight * preMergeWeight) * preFactor + (1 - confWeight * preMergeWeight) * statFactor;
        //根据离线数据取来的，当预估因子大于1.6时还有8%的加价空间，利用preMergeWeight实现对照组不生效，现在实验组对照组都走模型了，所以都生效了
        Double goodFactor = preMergeWeight > 0.1 ? 1.08 : 1.0;

        if (preFactor < 0.8) {
            ret = conFactor;
        } else if (preFactor < 1.0) {
            ret = statFactor;
        } else if (preFactor > 1.6) {
            ret = Math.max(goodFactor * conFactor, statFactor);
        } else {
            ret = Math.max(conFactor, statFactor);
        }
        ret = MathUtil.formatDouble(MathUtil.stdwithBoundary(ret, 0.5, 1.8), 5);
        preFactor = MathUtil.formatDouble(preFactor, 5);
        retDto.setDeepFactor(ret);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        log.info("Get double fee factor with high cost method."+retDto.toString());
        return retDto;

    }

}
