package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.alg.advert.DeepBidControl;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;
import org.junit.Test;

import java.util.Optional;

@Data
public class DeepControlParams {

    /**
     * 深度 双出价 控制参数
     */
    private Double deepFactor; //深度目标调价因子

    private Double limitDeepFactor; //限流释放媒体-深度目标调价因子

    private Double confWeight;//预估置信权重

    private Double preMergeWeight;//预估融合权重

    private Double preMergeDiffU;//预估偏离统计上限 1.2
    private Double preMergeDiffL;//预估偏离统计下限 0.9

    private Long controlType; //实际控制类型 1：成本优先  2：消耗优先  3：延迟类型处理

    private Double slotStatDcvr; //配置+广告位，离线统计转化率
    private Double pkStatDcvr; //配置，离线统计转化率


    private String updateTime;// 更新时间


    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static Double getDeepFactor(DeepControlParams params) {

        Double ret = null;

        if (params != null) {
            ret = params.getDeepFactor();
        }

        return ret;
    }


    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static DeepControlFactors getDeepFactor(DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        //取计算所需属性
        Integer appLimitReleaseMark = adBidParamsDo.getAppLimitReleaseMark();
        Long deepFee = adBidParamsDo.getDeepFee();
        Long aFee = adBidParamsDo.getAFee();
        Double preDcvr = adBidParamsDo.getPreDcvr();
        Long slotId = Optional.ofNullable(adBidParamsDo.getSlotId()).orElse(-1L);
        Integer abTestId = Optional.ofNullable(adBidParamsDo.getAbTestId()).orElse(1);

        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = null;

        if (params == null || params.getDeepFactor() == null) {
            return retDto;
        }

        ret = params.getDeepFactor();
        Double statFactor = params.getDeepFactor();

        ////限流释放媒体-深度目标调价因子
        if (appLimitReleaseMark != null && appLimitReleaseMark.equals(1) && params.getLimitDeepFactor() != null) {
            ret = params.getLimitDeepFactor();
            statFactor = params.getLimitDeepFactor();
        }

        //默认取统计的因子
        retDto.setDeepFactor(ret);
        retDto.setStatDeepFactor(statFactor);

        Long controlType = params.getControlType();
        Double confWeight = params.getConfWeight();

        Double preMergeWeight = params.getPreMergeWeight();

        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();

        if (AssertUtil.isAllNotEmpty(confWeight, controlType, preDcvr, deepFee, aFee, preMergeWeight, preMergeDiffU, preMergeDiffL)) {
            if (abTestId == 2 && slotId == 386453L) {
                retDto = DeepBidControl.calculateHighCost(deepFee, aFee, preDcvr, confWeight, preMergeWeight, statFactor);
            } else {
                retDto = DeepBidControl.calculateNormal(deepFee, aFee, preDcvr, confWeight, preMergeWeight, statFactor);
            }
        }

        return retDto;
    }


    public static void main(String args[]) {

        DeepControlParams params = new DeepControlParams();
        params.setConfWeight(1.0);
        params.setDeepFactor(1.1);
        params.setLimitDeepFactor(0.8);
        params.setControlType(1L);
        params.setPreMergeDiffL(0.3);
        params.setPreMergeDiffU(2.0);
        params.setPreMergeWeight(0.8);

        AdBidParamsDo adBidParamsDo=new AdBidParamsDo();
        adBidParamsDo.setAppLimitReleaseMark(0);
        adBidParamsDo.setSlotId(386453L);
        adBidParamsDo.setDeepFee(22000L);
        adBidParamsDo.setAFee(1000L);
        adBidParamsDo.setPreDcvr(0.2);
        adBidParamsDo.setAbTestId(2);

        DeepControlFactors result=getDeepFactor(params,adBidParamsDo);
        System.out.println(result);

    }

}
