package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Data
public class AdxDirecetlySlotDo {

    /**
     * 广告位维度设置的分成比例
     */
    private Double shareRate;

    /**
     * 扣费方式：1:一价扣费，2:二价扣费
     */
    private Integer feeType;


    /**
     * 广告计划维度设置的分成比例
     */
    private Map<Long, Double> advertShareRateMap;

    public static double getShareRate(AdxDirecetlySlotDo adxDirecetlySlotDo) {
        double ret = 1.;
        if(adxDirecetlySlotDo != null && adxDirecetlySlotDo.getShareRate() != null) {
            ret = adxDirecetlySlotDo.getShareRate() / 100;
        }
        return ret;
    }

    public static Map<Long, Double>  getAdvertShareRateMap(AdxDirecetlySlotDo adxDirecetlySlotDo) {
        Map<Long, Double> ret = new HashMap<>();
        if(AssertUtil.isAllNotEmpty(adxDirecetlySlotDo,adxDirecetlySlotDo.getAdvertShareRateMap())) {
            adxDirecetlySlotDo.getAdvertShareRateMap().forEach((adId,shareRate) -> {
                if(shareRate != null ) {
                    ret.put(adId, shareRate / 100);
                }
            });
        }

        return ret;
    }
}
