package cn.com.duiba.nezha.alg.alg.vo.adx.directly2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class AdxExpFactorDo {
    public Double resFactor;

    public Map<String, Double> appFactor = new HashMap<>();

    public static Double getAppFactor(AdxExpFactorDo adxExpFactorDo, String appId) {
        Double ret = null;
        if(AssertUtil.isAnyEmpty(adxExpFactorDo, appId)) {
            return ret;
        }
        if(adxExpFactorDo.getAppFactor() != null) {
            ret = adxExpFactorDo.getAppFactor().get(appId);
        }
        return ret;
    }

    public void putAppFactor(String appId, Double factor) {
        if(AssertUtil.isAllNotEmpty(appId, factor)) {
            appFactor.put(appId, factor);
        }
    }
}
