package cn.com.duiba.nezha.alg.alg.vo.adx.rtb;

import lombok.Data;

import java.io.Serializable;

/**
 * RTB互动-算法出价出参对象
 */

@Data
public class AdxRtbBidResultDo implements Serializable {

    /**
     * 出价策略
     */
    private String strategy;

    /**
     * 出价调节level
     */
    private String level;

    /**
     * 算法出价(分/cpm)
     */
    private Long adxAlgoPrice;

    /**
     * 算法CPC出价(分/cpc)
     */
    private Long cpc;

    /**
     * 维稳控制信息
     */
    private String adxControlInfo;

    /**
     * 创意点击价值-预估（预发券预估）
     */
    private Double predClickValue;

    /**
     * 点击价值分层
     */
    private Integer clickValueLevel;

    /**
     * 点击价值纠偏因子
     */
    private Double clickValueRectifyFactor;


    /**
     * 出价2.0
     */

    /**
     * 维稳因子
     */
    private Double factor;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * 融合ctr
     */
    private Double ctr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 融合每pv发券
     */
    private Double launchPv;

    /**
     * 点击价值
     */
    private Double clickValue;

    /**
     * arpu值
     */
    private Double arpu;


}
