package cn.com.duiba.nezha.alg.alg.kaihu;


import cn.com.duiba.nezha.alg.alg.vo.kaihu.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

public class KaiHuConvertFilterAlg {

    /**
     * 开户ROI控制API--转化回传/点券回传
     *
     * @param kaiHuInputDo
     * @param paramsModel
     * @return 返回是否回传  0-不回传、1-回传
     */
    public static KaiHuResultDo getFilterResult(KaiHuInputDo kaiHuInputDo, RoiControlModel paramsModel) {

        KaiHuResultDo ret = new KaiHuResultDo();
        if (AssertUtil.isEmpty(kaiHuInputDo)) {
            return ret;
        }

        //获取roi控制参数
        Long slotId = kaiHuInputDo.getSlotId();
        RoiParamsDo roiParams = getRFactor(slotId, paramsModel);
//        roiParams.setRFactor(1.0);//前期暂时不生效
        Double rFactor = roiParams.getRFactor();

        //获取是否回传
        int isBack = getBackResult(kaiHuInputDo, rFactor);

        ret.setIsBack(isBack);
        ret.setRoiParams(roiParams);
        return ret;
    }



    /**
     * 获取roi控制参数
     *
     * @param slotId
     * @param paramsModel
     * @return roiParamsDo
     */
    public static RoiParamsDo getRFactor(Long slotId, RoiControlModel paramsModel) {

        RoiParamsDo ret = new RoiParamsDo();

        Double rFactor = 1.0;
        String updateTime = null;
        if (AssertUtil.isAllNotEmpty(paramsModel, slotId)) {

            RoiControlParams params = paramsModel.getRoiControlParams(slotId);
            if (params.getCConf() != null && params.getCConf()) {

                rFactor = params.getRFactor();
                updateTime = params.getUpdateTime();
                if (rFactor == null) {
                    rFactor = 1.0;
                }
            }
        }

        ret.setRFactor(rFactor);
        ret.setUpdateTime(updateTime);

        return ret;
    }



    /**
     * 回传决策
     * 场景：2=广告转化多O回传、3=点券多O回传
     *
     * @return 返回是否回传  0-不回传、1-回传
     */
    public static int getBackResult(KaiHuInputDo kaiHuInputDo, Double rFactor) {

        int ret = 0;

        Integer scene = kaiHuInputDo.getScene();
        Integer fee = kaiHuInputDo.getFee();
        Integer aFee = kaiHuInputDo.getAFee();
        Integer chargeType = kaiHuInputDo.getChargeType();
        Integer convertType = kaiHuInputDo.getConvertType();
        Integer subType = kaiHuInputDo.getSubType();
        Integer appTargetFee = kaiHuInputDo.getAppTargetFee();
        Double roi = kaiHuInputDo.getRoi();
        Long mcbIdTag = kaiHuInputDo.getMcbIdTag();
        Long orderSubTypeTag = kaiHuInputDo.getOrderSubTypeTag();


        /**
         * 策略
         *
         * 1、判断是否需要回传，当前获取的转化类型 与 广告投放目标类型一致时，按概率回传
         * 2、计算回传概率，回传概率 =  广告投放目标成本/（开户媒体上目标转化成本 * roi * rFactor)
         * 3、根据回传概率计算，决策是否需要回传
         */

        //roi缺失处理，默认值1.5
        if (roi == null || roi < 1.0) {
            roi = 1.5;
        }

        //回传概率
        double p = 0.0;

        if (AssertUtil.isAllNotEmpty(scene, convertType, subType)
                && scene.equals(2) && (convertType.equals(subType))) {

            /**
             * 广告转化多O回传
             */

            //cpc广告
            if (AssertUtil.isNotEmpty(chargeType) && chargeType.equals(1)) {
                p = 0.3;
            }

            //ocpc广告
            if (AssertUtil.isAllNotEmpty(chargeType, aFee, appTargetFee, rFactor)
                    && chargeType.equals(2) && aFee > 1 && appTargetFee > 1 ) {

                p = aFee / (0.01 + appTargetFee * roi * rFactor);
            }

            ret = getRepeatTimes(p, mcbIdTag, orderSubTypeTag);


        } else if (AssertUtil.isNotEmpty(scene) && scene.equals(3)) {

            /**
             * 点券多O回传
             */

            if (AssertUtil.isAllNotEmpty(fee, appTargetFee, rFactor)
                    && fee > 1 && appTargetFee > 1) {

                p = fee / (0.01 + appTargetFee * roi * rFactor);
                ret = getRepeatTimes(p, mcbIdTag, orderSubTypeTag);
            }


        }


        return ret;
    }


    /**
     * 首次打印 广告订单Id+转化类型（orderSubTypeTag=1），按概率p随机回传；其余，不回传；
     *
     * @return
     */
    public static int getRepeatTimes(double p, Long mcbIdTag, Long orderSubTypeTag) {
        int ret = 0;

        if(orderSubTypeTag == null || orderSubTypeTag.equals(1L)) {
            ret = getRepeatTimes(p);
        }
//        ret = getRepeatTimes(p);//前期orderSubTypeTag=1暂时不生效

        if (ret > 1) {
            ret = 1;
        }

        return ret;
    }



    /**
     * 券点击
     *
     * @param advertId     广告计划ID
     * @param fee          券点击计费 单位：分
     * @param convertType  广告投放目标类型
     * @param chargeType   广告是否开启OCPC， 1-cpc、2-ocpc
     *                     //     * @param subType      当前获取的转化类型  0-落地页点击（注意点）、3-注册 ...等
     * @param appTargetFee 开户媒体上目标转化成本   单位：分
     * @param roi          目标ROI
     * @return 返回需要回传的次数  0-回传、1-回传1次、2-回传2次、依此类推，最大回传3次（）
     */
    public static int getFilterResult2(Long advertId, Integer fee, Integer convertType, Integer chargeType,
                                       Integer appTargetFee, Double roi) {
        int ret = 0;

        /**
         * 策略
         *
         * 1、判断是否需要回传，当前获取的转化类型 与 广告投放目标类型一致时，按概率回传
         * 2、计算回传概率，回传概率 =  广告投放目标成本/（开户媒体上目标转化成本 * roi)
         * 3、计算回传次数，根据回传概率计算
         * }
         */

        //roi缺失处理，默认值1.25
        if (roi == null) {
            roi = 1.5;
        }

        if (AssertUtil.isAllNotEmpty(fee, convertType, chargeType, appTargetFee)) {

            //cpc广告回传1次
            if (chargeType == 1) {

                double p = 0.5;
                ret = getRepeatTimes(p);
            }

            //ocpc广告
            if (fee > 1 && appTargetFee > 1) {

                double p = fee / (0.01 + appTargetFee * roi);
                ret = getRepeatTimes(p);
            }

        }

        //范围约束 不大于3

        if (ret > 1) {
            ret = 1;
        }

        return ret;
    }


    /**
     * @param advertId     广告计划ID
     * @param aFee         广告投放目标成本 单位：分
     * @param convertType  广告投放目标类型
     * @param chargeType   广告是否开启OCPC， 1-cpc、2-ocpc
     * @param subType      当前获取的转化类型  0-落地页点击（注意点）、3-注册 ...等
     * @param appTargetFee 开户媒体上目标转化成本   单位：分
     * @param roi          目标ROI
     * @return 返回需要回传的次数  0-回传、1-回传1次、2-回传2次、依此类推，最大回传3次（）
     */
    public static int getFilterResult(Long advertId, Integer aFee, Integer convertType, Integer chargeType,
                                      Integer subType,
                                      Integer appTargetFee, Double roi) {
        int ret = 0;

        /**
         * 策略
         *
         * 1、判断是否需要回传，当前获取的转化类型 与 广告投放目标类型一致时，按概率回传
         * 2、计算回传概率，回传概率 =  广告投放目标成本/（开户媒体上目标转化成本 * roi)
         * 3、计算回传次数，根据回传概率计算
         * }
         */

        //roi缺失处理，默认值1.25
        if (roi == null) {
            roi = 1.5;
        }

        if (AssertUtil.isAllNotEmpty(aFee, convertType, chargeType, subType, appTargetFee)) {

            //cpc广告回传1次
            if (chargeType.equals(1) && (convertType.equals(subType))) {

                double p = 0.5;
                ret = getRepeatTimes(p);
            }

            //ocpc广告
            if (chargeType.equals(2) && aFee > 1 && appTargetFee > 1 && (convertType.equals(subType))) {
                double p = aFee / (0.01 + appTargetFee * roi);
                ret = getRepeatTimes(p);
            }


        }

        //范围约束 不大于3

        if (ret > 1) {
            ret = 1;
        }

        return ret;
    }


    public static int getRepeatTimes(double p) {
        int ret = 0;

        int p1 = (int) Math.floor(p);
        ret += p1;

        double p2 = p - p1;
        if (Math.random() < p2) {
            ret += 1;
        }
        return ret;
    }


    /**
     * test
     *
     * @param args
     */
    public static void main(String[] args) {

        Map<Integer, Integer> retMap = new HashMap<>();
        for (int i = 0; i < 10000; i++) {
            int ret = getFilterResult(74603L, 1000, 4, 2, 4, 2000, 1.5);
            retMap.put(ret, 1 + retMap.getOrDefault(ret, 0));
        }

        System.out.println("1," + JSON.toJSONString(retMap));


        Map<Integer, Integer> retMap2 = new HashMap<>();
        for (int i = 0; i < 10000; i++) {
            int ret = getFilterResult2(74603L, 87, 0, 2, 1000, 1.2);
            retMap2.put(ret, 1 + retMap2.getOrDefault(ret, 0));
        }

        System.out.println("2," + JSON.toJSONString(retMap2));

    }


}
