package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class OcpxControlParams {

    private Integer resetType;// 维稳重置

    /**
     * 成本维稳控制参数
     */

    private Boolean cConf; //维稳置信

    private Double fcFactor=1.0; //跑量控制因子
    private Double cFactor; //二阶成本控制因子
    private Double pcFactor = 1.0; //预估值校准因子


    /**
     * 底价 控制参数
     */
    private Boolean fConf;// 底价置信
    private Long fPriceThre;// 底价阈值
    private Double fGiveUpProb;// 放弃概率

    /**
     * 双出价控制参数
     * 1. preDiscountUpperBound，预估降价上限，当预估因子小于该值，使用融合因子作为深度因子，比原有逻辑中使用的统计因子更小。
     * 2. extraRiseLowerBound，额外加价下限，当预估因子大于该值，融合因子额外乘以1.08。
     */
    private Double preDiscountUpperBound;
    private Double extraRiseLowerBound;


//    /**
//     * 探价控制参数
//     */
//    private Boolean eConf;// 探价置信
//    private Long ePriceThre; // 探价阈值
//    private Double eRate; //探价概率



    private String updateTime;
    /**
     * 获取维稳因子
     *
     * @param params
     * @return
     */
    public static Double getCostAtFactor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                ret = params.getCFactor();

                if (params.getCFactor() != null && params.getPcFactor() != null) {
                    if(params.getFcFactor()==null){
                        params.setFcFactor(1.0);
                    }
                    ret = Math.max(params.getCFactor(), params.getFcFactor());
                }
            }
        }

        return ret;
    }

    /**
     * 获取维稳因子 取 Max(预估纠偏因子,成本控制因子)
     *
     * @param params
     * @return
     */
    public static Double getCostFactor(OcpxControlParams params) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                if(params.getFcFactor()==null){
                    params.setFcFactor(1.0);
                }
                ret = params.getPcFactor() * params.getFcFactor();

            }
        }

        return ret;
    }

    /**
     * 获取维稳因子对象
     *
     * @param params
     * @return
     */
    public static OcpcFactorParams getOcpcFactors(OcpxControlParams params) {
        OcpcFactorParams ret = new OcpcFactorParams();

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                if(params.getFcFactor()==null){
                    params.setFcFactor(1.0);
                }
                Double factor = params.getPcFactor() * params.getFcFactor();

                //参数更新延迟，参数约束
                String updateTime = params.getUpdateTime();
                Long durationMin = LocalDateUtil.getIntervalMinutes(updateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
                if (durationMin == null || durationMin >= 120) {
                    factor = MathUtil.stdwithBoundary(factor, 1.0, 1.0);
                } else if (durationMin >= 60) {
                    factor = MathUtil.stdwithBoundary(factor, 0.95, 1.05);
                } else if (durationMin >= 30) {
                    factor = MathUtil.stdwithBoundary(factor, 0.9, 1.1);
                } else if (durationMin >= 20 ) {
                    factor = MathUtil.stdwithBoundary(factor, 0.8, 1.2);
                }

                ret.setFactor(factor);
                ret.setPcFactor(params.getPcFactor());
                ret.setFcFactor(params.getFcFactor());

            }
        }

        return ret;
    }


    /**
     * 二价出价保护因子
     *
     * @param params
     * @return
     */
    public static Double getCostFactorWithProtect(OcpxControlParams params, int costParamsType) {

        Double ret = null;

        if (params != null) {

            if (params.getCConf() != null && params.getCConf()) {
                if (params.getCFactor() != null) {
                    ret = params.getCFactor();
                }
            }

            //跑量模式：数据是否置信，二阶因子均生效
            if (costParamsType == 2 && params.getCFactor() != null) {
                ret = params.getCFactor();
            }
        }

        return ret;
    }


    /**
     * 获取重置状态
     *
     * @param ocpxControlParams
     * @return
     */

    public static Integer getResetType(OcpxControlParams ocpxControlParams) {

        if (ocpxControlParams != null) {
            return ocpxControlParams.getResetType();
        } else {
            return null;
        }
    }

    /**
     * 获取参数更新时间
     *
     * @param ocpxControlParams
     * @return
     */

    public static String getUpdateTime(OcpxControlParams ocpxControlParams) {

        if (ocpxControlParams != null) {
            return ocpxControlParams.getUpdateTime();
        } else {
            return null;
        }
    }

//    /**
//     * 探价-调整出价
//     */
//    public static Long getExplorePrice(OcpxControlParams ocpxControlParams, Long fee) {
//        Double adjustFee = fee.doubleValue();
//        if (ocpxControlParams != null) {
//            if (ocpxControlParams.getEConf() != null && ocpxControlParams.eConf) {
//                Long ePriceThre = ocpxControlParams.getEPriceThre();
//                if (ePriceThre != null && fee < ePriceThre) {
//                    adjustFee = adjustFee + (ePriceThre - adjustFee) * 0.5;
//                }
//            }
//        }
//        return adjustFee.longValue();
//    }

//    /**
//     * 探价-获取探价比例
//     */
//    public static Double getExploreRate(OcpxControlParams ocpxControlParams) {
//        if (ocpxControlParams != null) {
//            if (ocpxControlParams.getEConf() != null && ocpxControlParams.getEConf()) {
//                return ocpxControlParams.getERate();
//            }
//        }
//        return null;
//    }


}

