/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rcmd2.priceExploreLevelEnum;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPriceExploreDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxStatData {
    private static final Logger logger = LoggerFactory.getLogger(AdxStatData.class);

    public static Map<String, Double> updatePriceExploreList(List<AdxPriceExploreDo> priceExploreDoList, List<AdxPriceExploreDo> priceExploreAppDoList, Map<String, Double> lastPriceExploreMap, Double minStepSize) {
        int consumeEnd;
        int consumeStart;
        Map<String, Double> consumeResultMap;
        int profitEnd;
        int profitStart;
        Map<String, Double> profitResultMap;
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (lastPriceExploreMap == null) {
            lastPriceExploreMap = new HashMap<String, Double>();
        }
        if (minStepSize == null) {
            minStepSize = 0.1;
        }
        if (AssertUtil.isEmpty(profitResultMap = AdxStatData.getResultMap(priceExploreDoList, priceExploreAppDoList, lastPriceExploreMap, minStepSize, profitStart = priceExploreLevelEnum.profitLevelStart.getIndex(), profitEnd = priceExploreLevelEnum.profitLevelEnd.getIndex()))) {
            AdxStatData.defaultResultMap(profitResultMap, profitStart, profitEnd);
        }
        if (AssertUtil.isEmpty(consumeResultMap = AdxStatData.getResultMap(priceExploreDoList, priceExploreAppDoList, lastPriceExploreMap, minStepSize, consumeStart = priceExploreLevelEnum.consumeLevelStart.getIndex(), consumeEnd = priceExploreLevelEnum.consumeLevelEnd.getIndex()))) {
            AdxStatData.defaultResultMap(consumeResultMap, consumeStart, consumeEnd);
        }
        retMap.putAll(profitResultMap);
        retMap.putAll(consumeResultMap);
        return retMap;
    }

    public static void defaultResultMap(Map<String, Double> resultMap, int start, int end) {
        for (int i = start; i <= end; ++i) {
            double defaultValue = (start + "").equals(i + "") ? 2.0 : 2.0 + ((double)i - (double)(end + start + 1) / 2.0) * 0.5;
            resultMap.put(i + "", defaultValue);
        }
    }

    public static Map<String, Double> getResultMap(List<AdxPriceExploreDo> priceExploreDoList, List<AdxPriceExploreDo> priceExploreAppDoList, Map<String, Double> lastPriceExploreMap, Double minStepSize, int start, int end) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (priceExploreDoList.size() < end || !priceExploreDoList.get(end - 1).getLevel().equals(end + "") || priceExploreAppDoList.size() < end || !priceExploreAppDoList.get(end - 1).getLevel().equals(end + "")) {
            logger.info("updatePriceExploreList, Mode{} input data error {}, {}", new Object[]{start, priceExploreDoList, priceExploreAppDoList});
            return retMap;
        }
        String bestKey = AdxStatData.getBestKey(priceExploreDoList.subList(start, end - 1), priceExploreAppDoList.subList(start, end - 1), start + "");
        if (bestKey.equals("-1") || !lastPriceExploreMap.containsKey(start + "")) {
            if (AssertUtil.isNotEmpty((String)priceExploreDoList.get(start).getSlotId()) && priceExploreDoList.get(start).getSlotId().equals("7330181")) {
                logger.info("updatePriceExploreList, Mode{} app_data no confidence {}, {}", new Object[]{start, priceExploreAppDoList.subList(start - 1, end - 1), lastPriceExploreMap});
            } else if (Math.random() < 0.001) {
                logger.info("updatePriceExploreList, Mode{} app_data no confidence {}, {}", new Object[]{start, priceExploreAppDoList.subList(start - 1, end - 1), lastPriceExploreMap});
            }
        } else {
            Map<String, Double> factorMap = AdxStatData.getFactorMap(bestKey, minStepSize, lastPriceExploreMap, start);
            double bestFactor = factorMap.getOrDefault("bestFactor", 2.0);
            double stepSize = factorMap.getOrDefault("stepSize", 0.5);
            double idx = factorMap.getOrDefault("idx" + start, 0.0);
            for (int level = start; level <= end; ++level) {
                double factor = level == start ? bestFactor : bestFactor + ((double)level - (double)(end + start + 1) / 2.0) * stepSize;
                retMap.put(level + "", factor);
            }
            retMap.put("idx" + start, idx);
            logger.info("updatePriceExploreList, curPriceMap {}, lastPriceMap{}, priceDoList{}, Mode{}, bestKey{}", new Object[]{retMap, lastPriceExploreMap, priceExploreDoList, start, bestKey});
        }
        return retMap;
    }

    public static String getBestKey(List<AdxPriceExploreDo> priceExploreDoList, List<AdxPriceExploreDo> priceExploreAppDoList, String effectMode) {
        String bestKey = AdxStatData.findKey(priceExploreDoList, effectMode);
        if (bestKey.equals("-1")) {
            bestKey = AdxStatData.findKey(priceExploreAppDoList, effectMode);
            if (priceExploreDoList.get(0).getSlotId().equals("7330181")) {
                logger.info("updatePriceExploreList, slot_data no confidence {}", priceExploreDoList);
            } else if (Math.random() < 0.01) {
                logger.info("updatePriceExploreList, slot_data no confidence {}", priceExploreDoList);
            }
        }
        return bestKey;
    }

    public static String findKey(List<AdxPriceExploreDo> priceExploreDoList, String effectMode) {
        double bestEffect = Double.NEGATIVE_INFINITY;
        String bestKey = "-1";
        for (AdxPriceExploreDo levelDo : priceExploreDoList) {
            if (!AssertUtil.isNotEmpty((Object)levelDo)) continue;
            String key = levelDo.getLevel();
            Double effect = AdxPriceExploreDo.getEffect(levelDo, effectMode);
            if (!AssertUtil.isNotEmpty((Object)effect) || !(effect > bestEffect)) continue;
            bestEffect = effect;
            bestKey = key;
        }
        return bestKey;
    }

    public static Map<String, Double> getFactorMap(String bestKey, double minStepSize, Map<String, Double> lastPriceExploreMap, int start) {
        double stepSize;
        HashMap<String, Double> tmpMap = new HashMap<String, Double>();
        double upper = 5.0;
        double lower = 0.3;
        double bestFactor = MathUtil.stdwithBoundary((double)lastPriceExploreMap.getOrDefault(bestKey, 2.0), (double)lower, (double)upper);
        double oldBase = lastPriceExploreMap.getOrDefault(start + "", 2.0);
        double idx = lastPriceExploreMap.getOrDefault("idx" + start, 0.0);
        idx = bestFactor == oldBase ? (idx += 1.0) : 0.0;
        if (idx >= 4.0) {
            if (bestFactor >= 3.0) {
                stepSize = 5.0 * minStepSize;
                bestFactor -= 2.0 * stepSize;
                idx = 0.0;
            } else {
                stepSize = 2.0 * minStepSize;
            }
        } else {
            double stepSizeU = bestFactor - oldBase > 0.0 ? Math.min((upper - bestFactor) / 2.0, 1.0) : Math.min((bestFactor - lower) / 2.0, 1.0);
            stepSize = MathUtil.stdwithBoundary((double)Math.abs(bestFactor - oldBase), (double)minStepSize, (double)stepSizeU);
        }
        tmpMap.put("bestFactor", bestFactor);
        tmpMap.put("stepSize", stepSize);
        tmpMap.put("idx" + start, idx);
        return tmpMap;
    }
}

