/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.basepricecontrol;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceInfo;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceParams2;
import cn.com.duiba.nezha.alg.alg.basepricecontrol.BasePriceResultNew;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePriceControl2 {
    private static final Logger logger = LoggerFactory.getLogger(BasePriceControl2.class);

    public static Double basePriceProb(BasePriceInfo basePriceInfo, Long fee, BasePriceParams2 params) {
        Double prob = 0.5;
        Double alpha = params.alpha;
        Double beta1 = params.beta1;
        Double beta2 = params.beta2;
        Double beta3 = params.beta3;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{basePriceInfo, fee})) {
            return prob;
        }
        if (Math.random() < 0.001) {
            logger.info("params basePriceParams2:{}", (Object)params);
        }
        try {
            Map<String, Double> ratio = BasePriceControl2.getBasePriceRatio(basePriceInfo);
            Double ratio5 = ratio.get("level5");
            Double ratio10 = ratio.get("level10");
            Double factor = MathBase.noiseSmoother(ratio5 * beta2 + ratio10 * beta3, 0.01, 0.4);
            prob = alpha + (1.0 - Math.min((double)fee.longValue(), 15.0) / 15.0) * beta1 + factor;
            prob = DataUtil.formatDouble((Double)prob, (int)3);
        }
        catch (Exception e) {
            logger.warn("getBasePriceRatio happend error,basePriceInfo={}", (Object)JSON.toJSONString((Object)basePriceInfo), (Object)e);
        }
        return prob;
    }

    public static Map<String, Double> getBasePriceRatio(BasePriceInfo basePriceInfo) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        Double orientLevel5Ratio = 0.0;
        Double orientLevel10Ratio = 0.0;
        if (basePriceInfo.orientLaunchToday != null && basePriceInfo.orientLaunchToday > 0L) {
            orientLevel5Ratio = (double)basePriceInfo.orientLevel5PriceLaunchToday.longValue() / (double)basePriceInfo.orientLaunchToday.longValue();
            orientLevel10Ratio = (double)basePriceInfo.orientLevel10PriceLaunchToday.longValue() / (double)basePriceInfo.orientLaunchToday.longValue();
        }
        ret.put("level5", orientLevel5Ratio);
        ret.put("level10", orientLevel10Ratio);
        return ret;
    }

    public static <T> Map<T, BasePriceResultNew> isGiveUp(Map<T, BasePriceInfo> basePriceInfoMap, Map<T, Long> finalFeeMap, BasePriceParams2 basePriceParams) {
        HashMap<T, BasePriceResultNew> ret = new HashMap<T, BasePriceResultNew>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{basePriceInfoMap})) {
            return ret;
        }
        for (Map.Entry<T, BasePriceInfo> entry : basePriceInfoMap.entrySet()) {
            T key = entry.getKey();
            BasePriceInfo basePriceInfo = entry.getValue();
            Long finalFee = finalFeeMap.get(key);
            Double prob = BasePriceControl2.basePriceProb(basePriceInfo, finalFee, basePriceParams);
            Random r = new Random();
            Double x = r.nextDouble();
            Boolean giveUp = false;
            if (finalFee <= 10L && x <= prob) {
                giveUp = true;
            }
            BasePriceResultNew result = new BasePriceResultNew();
            result.setGiveUpProb(prob);
            result.setIsGiveUp(giveUp);
            ret.put(key, result);
        }
        return ret;
    }
}

