package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Data
public class IdeaUnitDo {

    /**
     * 创意素材ID
     */
    private Long ideaUnitId;

    /**
     * 创意计划ID
     */
    private Long adIdeaId;

    /**
     * 素材ID
     */
    private List<Long> materialIds;

    /**
     * 创意素材类型
     */
    private Long type;

    /**
     * 出价
     */
    private Double price;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * ctr
     */
    private Double ctr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 每pv发券
     */
    private Double launchPv;

    /**
     * arpu
     */
    private Double arpu;

    /**
     * 预估arpu
     */
    private Double preArpu;

    /**
     * 创意素材+当前资源位统计数据
     */
    private AdxStatsDo adxStatsDo;

    public static Double getStatEcpm(IdeaUnitDo ideaUnitDo){
        Double ret = null;
        if(ideaUnitDo != null) {
            AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
            AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
            ret = AdxIndexStatDo.getStatEcpm(last1DayStat);
        }
        if(ret == null) {ret = 10000.0;}
        return ret;

    }

}
