/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFilterTaskPlus {
    private static final Logger logger = LoggerFactory.getLogger(AdxFilterTaskPlus.class);
    private static double[] PRE_CTR_BUCKET = new double[]{0.002, 0.003, 0.005, 0.007, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1};

    public static AdxFilterInfoDo getFilterInfo(AdxFlowInfoDo flowInfo, AdxFilterInfoDo lastFilterInfo) {
        AdxFilterInfoDo ret = new AdxFilterInfoDo();
        try {
            Integer preIntervalSize = PRE_CTR_BUCKET.length + 1;
            Double minRoi = 1.0;
            Double defaultRate = 0.0;
            Double filterRate = 0.9;
            boolean dayConfident = false;
            HashMap<Integer, Double> filterMap = new HashMap<Integer, Double>(preIntervalSize);
            HashMap<Integer, Double> roiDayMap = new HashMap<Integer, Double>(preIntervalSize);
            HashMap<Integer, Double> roiHourMap = new HashMap<Integer, Double>(preIntervalSize);
            HashMap<Integer, Double> ctrDayMap = new HashMap<Integer, Double>(preIntervalSize);
            HashMap<Integer, Double> ctrHourMap = new HashMap<Integer, Double>(preIntervalSize);
            Double roiDay = null;
            Double roiHour = null;
            Double ctrDay = null;
            Double ctrHour = null;
            Map<Object, Object> intervalDayStats = new HashMap(preIntervalSize);
            Map<Object, Object> intervalHourStats = new HashMap(preIntervalSize);
            if (AssertUtil.isNotEmpty((Object)flowInfo)) {
                Long groupId = flowInfo.getGroupId();
                minRoi = AdxStatData.nullToMinDefault(flowInfo.getMinRoi(), 1.0);
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatDo ideaHourStats = flowInfo.getIdeaHourStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                AdxIndexStatsDo ideaHourComputes = AdxStatData.adxIndexCompute(ideaHourStats);
                dayConfident = ideaDayComputes.getConfident();
                roiDay = ideaDayComputes.getRoi();
                roiHour = ideaHourComputes.getRoi();
                ctrDay = ideaDayComputes.getCtr();
                ctrHour = ideaHourComputes.getCtr();
                intervalDayStats = flowInfo.getResoPreIntervalDayStats();
                intervalHourStats = flowInfo.getResoPreIntervalHourStats();
            }
            Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
            Double lastMinRoi = minRoi;
            if (AssertUtil.isNotEmpty((Object)lastFilterInfo)) {
                lastMinRoi = AdxStatData.nullToDefault(lastFilterInfo.getCurrentMinRoi(), 1.0);
            }
            for (int key = 0; key <= preIntervalSize; ++key) {
                AdxIndexStatDo intervalHour = new AdxIndexStatDo();
                AdxIndexStatDo intervalDay = new AdxIndexStatDo();
                if (AssertUtil.isAllNotEmpty((Object[])new Object[]{intervalHourStats, intervalDayStats})) {
                    intervalHour = (AdxIndexStatDo)intervalHourStats.get(key);
                    intervalDay = (AdxIndexStatDo)intervalDayStats.get(key);
                }
                AdxIndexStatsDo intervalHourComputes = AdxStatData.adxIndexCompute(intervalHour);
                AdxIndexStatsDo intervalDayComputes = AdxStatData.adxIndexCompute(intervalDay);
                Double roiIntervalHour = intervalHourComputes.getRoi();
                Double roiIntervalDay = intervalDayComputes.getRoi();
                Double ctrIntervalHour = intervalHourComputes.getCtr();
                Double ctrIntervalDay = intervalDayComputes.getCtr();
                if (AssertUtil.isEmpty((Object)roiIntervalHour)) {
                    roiIntervalHour = AdxStatData.getConRoi(intervalHourComputes, intervalDayComputes);
                }
                roiHourMap.put(key, roiIntervalHour);
                roiDayMap.put(key, roiIntervalDay);
                ctrHourMap.put(key, ctrIntervalHour);
                ctrDayMap.put(key, ctrIntervalDay);
                filterMap.put(key, defaultRate);
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 30L || !dayConfident) {
                    filterMap.put(key, defaultRate);
                    continue;
                }
                if (key == preIntervalSize) {
                    filterMap.put(key, defaultRate);
                    continue;
                }
                if (roiIntervalHour == null || !(roiIntervalHour < 0.3)) continue;
                filterMap.put(key, filterRate);
            }
            ret.setFilterMap(filterMap);
            ret.setCurrentMinRoi(minRoi);
            ret.setDayConfident(dayConfident);
            ret.setRoiDay(roiDay);
            ret.setRoiHour(roiHour);
            ret.setCtrDay(ctrDay);
            ret.setCtrHour(ctrHour);
            ret.setRoiDayInterval(roiDayMap);
            ret.setRoiHourInterval(roiHourMap);
            ret.setCtrDayInterval(ctrDayMap);
            ret.setCtrHourInterval(ctrHourMap);
        }
        catch (Exception e) {
            logger.error("AdxFilterTaskPlus.getFilterInfo error:" + e);
        }
        return ret;
    }
}

