/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaBaseRcmder;
import cn.com.duiba.nezha.alg.alg.adx.rcmd.AdxIdeaRcmder;
import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.base.Roulette;
import cn.com.duiba.nezha.alg.alg.params.AdxIdeaRcmdParam;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxIdeaDQNRcmder2 {
    private static final Logger logger = LoggerFactory.getLogger(AdxIdeaDQNRcmder2.class);
    private static int MAP_DF_SIZE = 8;

    public static AdxIdeaFeatureDo ideaRcmd(AdxIdeaRcmdParam adxIdeaRcmdParam, Map<String, String> staticFeatureMap) throws Exception {
        AdxIdeaFeatureDo ret = null;
        if (AdxIdeaDQNRcmder2.valid(adxIdeaRcmdParam).booleanValue()) {
            List<AdxIdeaFeatureDo> ideaFeatureDoList = adxIdeaRcmdParam.getIdeaFeatureList();
            AdxFeatureDo adxFeatureDo = adxIdeaRcmdParam.getAdxFeatureDo();
            AdxResourceRcmdDo adxResourceRcmdDo = adxIdeaRcmdParam.getAdxResourceRcmdDo();
            CODER coderModel = adxIdeaRcmdParam.getCoderModel();
            LocalTFModel ltfModel = adxIdeaRcmdParam.getLtfModel();
            if (!AdxIdeaDQNRcmder2.validModel(adxIdeaRcmdParam).booleanValue()) {
                AdxIdeaParamsDo adxIdeaParamsDo;
                ArrayList<Long> ideaList = new ArrayList<Long>();
                for (AdxIdeaFeatureDo ideaDo : ideaFeatureDoList) {
                    Long ideaId = ideaDo.getIdeaId();
                    ideaList.add(ideaId);
                }
                Long ideaId = AdxIdeaRcmder.ideaRcmd(ideaList, adxResourceRcmdDo);
                ret = new AdxIdeaFeatureDo();
                ret.setIdeaId(ideaId);
                Double sRpm = null;
                if (adxResourceRcmdDo != null && adxResourceRcmdDo.getIdeaParamsMap() != null && (adxIdeaParamsDo = adxResourceRcmdDo.getIdeaParamsMap().get(ideaId)) != null) {
                    sRpm = adxIdeaParamsDo.getRpm();
                }
                ret.setSRpm(sRpm);
            } else {
                HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
                for (AdxIdeaFeatureDo ideaDo : ideaFeatureDoList) {
                    Long ideaId = ideaDo.getIdeaId();
                    AdxFeatureDo dynamicDo = new AdxFeatureDo();
                    dynamicDo.setIdeaId(ideaId);
                    dynamicDo.setButtonText(ideaDo.getButtonText());
                    dynamicDo.setIconH(ideaDo.getIconH());
                    dynamicDo.setIconW(ideaDo.getIconW());
                    dynamicDo.setMjPicType(ideaDo.getMjPicType());
                    dynamicDo.setIdeaPicH1(ideaDo.getIdeaPicH1());
                    dynamicDo.setIdeaPicW1(ideaDo.getIdeaPicW1());
                    dynamicDo.setIdeaPicH2(ideaDo.getIdeaPicH2());
                    dynamicDo.setIdeaPicW2(ideaDo.getIdeaPicW2());
                    dynamicDo.setIdeaPicH3(ideaDo.getIdeaPicH3());
                    dynamicDo.setIdeaPicW3(ideaDo.getIdeaPicW3());
                    dynamicDo.setIdeaPicNum(ideaDo.getIdeaPicNum());
                    dynamicDo.setStyleStandard(String.valueOf(ideaDo.getIdeaType()));
                    dynamicDo.setMaterialId(ideaDo.getMaterialId());
                    dynamicDo.setPictureType(ideaDo.getPictureType());
                    dynamicDo.setPictureMaterialDo(ideaDo.getPictureMaterialDo());
                    dynamicDo.setVideoMaterialDo(ideaDo.getVideoMaterialDo());
                    Map dynamicFeatureMap = AdxFeatureParse.generateFeatureMapDynamic((AdxFeatureDo)dynamicDo, (AdxFeatureDo)adxFeatureDo);
                    FeatureMapDo featureMapDo = new FeatureMapDo();
                    featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
                    featureMapDo.setStaticFeatureMap(staticFeatureMap);
                    featureMap.put(ideaId, featureMapDo);
                }
                Map pRpmMap = coderModel.predictWithLocalTFNew(featureMap, ltfModel);
                for (AdxIdeaFeatureDo ideaDo : ideaFeatureDoList) {
                    Long ideaId = ideaDo.getIdeaId();
                    Double pRpm = (Double)pRpmMap.get(ideaId);
                    Double sRpm = null;
                    AdxIdeaParamsDo adxIdeaParamsDo = null;
                    if (adxResourceRcmdDo != null && adxResourceRcmdDo.getIdeaParamsMap() != null && (adxIdeaParamsDo = adxResourceRcmdDo.getIdeaParamsMap().get(ideaId)) != null) {
                        sRpm = adxIdeaParamsDo.getRpm();
                    }
                    Double mergeRpm = AdxIdeaDQNRcmder2.getMergeRpm(pRpm, sRpm);
                    ideaDo.setPRpm(pRpm);
                    ideaDo.setSRpm(sRpm);
                    ideaDo.setMergeRpm(mergeRpm);
                    ideaDo.setAdxIdeaParamsDo(adxIdeaParamsDo);
                }
                ret = AdxIdeaDQNRcmder2.rcmd(ideaFeatureDoList);
            }
        }
        return ret;
    }

    public static AdxIdeaFeatureDo rcmd(List<AdxIdeaFeatureDo> ideaList) {
        AdxIdeaFeatureDo ret = null;
        long size = ideaList.size();
        Double bestRpm = null;
        int i = 0;
        while ((long)i < size) {
            AdxIdeaFeatureDo ideaDo = ideaList.get(i);
            Double mergeRpm = ideaDo.getMergeRpm();
            if (mergeRpm != null && (bestRpm == null || bestRpm < mergeRpm)) {
                bestRpm = mergeRpm;
            }
            ++i;
        }
        HashMap<AdxIdeaFeatureDo, Double> weighMap = new HashMap<AdxIdeaFeatureDo, Double>(MAP_DF_SIZE);
        int i2 = 0;
        while ((long)i2 < size) {
            AdxIdeaFeatureDo adxIdeaFeatureDo = ideaList.get(i2);
            AdxIdeaParamsDo adxIdeaParamsDo = adxIdeaFeatureDo.getAdxIdeaParamsDo();
            Double sWeight = 1.0;
            if (adxIdeaParamsDo == null || adxIdeaParamsDo.getWeight() == null) {
                sWeight = 1.0;
            } else {
                sWeight = adxIdeaParamsDo.getWeight();
                if ((adxIdeaParamsDo.isFused() == null || !adxIdeaParamsDo.isFused().booleanValue()) && adxIdeaParamsDo.getGiveUpRatio() != null && adxIdeaParamsDo.getGiveUpRatio() >= 0.0 && Math.random() < adxIdeaParamsDo.getGiveUpRatio()) {
                    sWeight = null;
                }
                if (adxIdeaParamsDo.isFused() != null && adxIdeaParamsDo.isFused().booleanValue() && Math.random() > 0.1) {
                    sWeight = null;
                }
            }
            Double mergePpm = adxIdeaFeatureDo.getMergeRpm();
            Double mergeWeight = AdxIdeaBaseRcmder.getRpmWeight(mergePpm, bestRpm);
            if (mergeWeight == null) {
                mergeWeight = 1.0;
            }
            if (sWeight != null) {
                weighMap.put(adxIdeaFeatureDo, mergeWeight);
            }
            ++i2;
        }
        ret = (AdxIdeaFeatureDo)Roulette.doubleMap(weighMap);
        return ret;
    }

    private static Boolean valid(AdxIdeaRcmdParam adxIdeaRcmdParam) {
        Boolean ret = true;
        if (adxIdeaRcmdParam == null) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxIdeaRcmdParam is null");
            return false;
        }
        if (AssertUtil.isEmpty(adxIdeaRcmdParam.getIdeaFeatureList())) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params ideaFeatureList is empty");
            return false;
        }
        if (adxIdeaRcmdParam.getAdxResourceRcmdDo() == null) {
            logger.warn("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxResourceRcmdDo is null");
        }
        return ret;
    }

    private static Boolean validModel(AdxIdeaRcmdParam adxIdeaRcmdParam) {
        Boolean ret = true;
        if (adxIdeaRcmdParam == null) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxIdeaRcmdParam is null");
            return false;
        }
        if (adxIdeaRcmdParam.getAdxFeatureDo() == null) {
            logger.error("AdxIdeaDQNRcmder.rcmd() input params valid ,params adxFeatureDo is null");
            return false;
        }
        if (adxIdeaRcmdParam.getCoderModel() == null) {
            logger.warn("AdxIdeaDQNRcmder.rcmd() input params valid ,params coderModel is null");
            return false;
        }
        if (adxIdeaRcmdParam.getLtfModel() == null) {
            logger.warn("AdxIdeaDQNRcmder.rcmd() input params valid ,params ltfModel is null");
            System.out.println(ret);
            return false;
        }
        return ret;
    }

    public static Double getMergeRpm(Double predRpm, Double statRpm) {
        Double ret = predRpm;
        if (predRpm != null && statRpm != null) {
            Double limitPredRpm = predRpm;
            limitPredRpm = statRpm >= 0.0 ? MathBase.noiseSmoother(predRpm, -4.0 * statRpm, 4.0 * statRpm) : MathBase.noiseSmoother(predRpm, 4.0 * statRpm, -4.0 * statRpm);
            ret = 0.5 * limitPredRpm + 0.5 * statRpm;
        } else {
            ret = statRpm;
        }
        return ret;
    }
}

