/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdBase;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallRetDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.ColdStartFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxIdeaDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRcmdAlg {
    private static final Logger logger = LoggerFactory.getLogger(AdxRcmdAlg.class);
    public static final int LAST_20_MIN = 1;
    public static final int LAST_1_HOUR = 2;
    public static final int LAST_1_DAY = 3;
    public static final int LAST_3_DAY = 4;
    public static final int LAST_7_DAY = 5;
    public static final int IDEA_COLD_SIZE = 5;
    public static final int IDEA_BEST_SIZE = 15;
    public static final int ADIDEA_COLD_SIZE = 10;
    public static final int ADIDEA_BEST_SIZE = 30;

    public static AdxRecallRetDo recallIdeaRun(AdxRecallReqDo recallReqDo) {
        if (!AdxRcmdAlg.recallIdeaReqValid(recallReqDo)) {
            return null;
        }
        String print = "RecallIdeaRun, resId = " + recallReqDo.getResId();
        List<IdeaUnitDo> ideaUnitDos = recallReqDo.getIdeaUnitDos();
        ideaUnitDos.stream().forEach(ideaUnitDo -> {
            ideaUnitDo.setIsNew(IdeaUnitDo.getNewStatus(ideaUnitDo));
            ideaUnitDo.setLast7DayExpCnt(IdeaUnitDo.countExpCnt(ideaUnitDo, 5));
            ideaUnitDo.setLast7DayAdCost(IdeaUnitDo.countAdCost(ideaUnitDo, 5));
            ideaUnitDo.setStatAdEcpm(IdeaUnitDo.mergeStatAdEcpm(ideaUnitDo, 100L, 1));
        });
        Map<Integer, List<IdeaUnitDo>> ideaUnitMap = AdxRcmdBase.aggregateByRatioType(ideaUnitDos);
        HashMap recallMap = new HashMap();
        ArrayList<IdeaUnitDo> recallList = new ArrayList<IdeaUnitDo>();
        for (Map.Entry<Integer, List<IdeaUnitDo>> entry : ideaUnitMap.entrySet()) {
            Integer ratioType = entry.getKey();
            List<IdeaUnitDo> subIdeaUnitDos = entry.getValue();
            List coldList = subIdeaUnitDos.stream().filter(IdeaUnitDo::getIsNew).sorted(Comparator.comparing(IdeaUnitDo::getLast7DayExpCnt)).limit(5L).collect(Collectors.toList());
            List bestList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew() == false).sorted(Comparator.comparing(IdeaUnitDo::getStatAdEcpm).reversed()).limit(15L).collect(Collectors.toList());
            ArrayList subRecallList = new ArrayList();
            subRecallList.addAll(coldList);
            subRecallList.addAll(bestList);
            recallMap.put(ratioType, subRecallList);
            recallList.addAll(subRecallList);
            List coldIds = coldList.stream().map(IdeaUnitDo::getIdeaUnitId).collect(Collectors.toList());
            List bestIds = bestList.stream().map(IdeaUnitDo::getIdeaUnitId).collect(Collectors.toList());
            print = print + "; {ratioType = " + ratioType + ", originalSize = " + subIdeaUnitDos.size() + ", coldSize = " + coldList.size() + ", coldList = " + JSON.toJSONString(coldIds) + ", bestSize = " + bestList.size() + ", bestList = " + JSON.toJSONString(bestIds) + "}";
        }
        AdxRecallRetDo ret = new AdxRecallRetDo();
        ret.setIdeaUnitDos(recallList);
        ret.setPrintStr(print);
        return ret;
    }

    public static AdxRecallRetDo recallAdIdeaRun(AdxRecallReqDo recallReqDo) {
        if (!AdxRcmdAlg.recallAdIdeaReqValid(recallReqDo)) {
            return null;
        }
        String print = "RecallAdIdeaRun, resId = " + recallReqDo.getResId();
        List<IdeaUnitDo> ideaUnitDos = recallReqDo.getIdeaUnitDos();
        Map<Long, Boolean> isNewMap = ideaUnitDos.stream().collect(Collectors.toMap(IdeaUnitDo::getIdeaUnitId, IdeaUnitDo::getIsNew));
        List<AdIdeaDo> adIdeaDos = recallReqDo.getAdIdeaDos();
        List<IdeaUnitDo> ideaUnitList = adIdeaDos.stream().flatMap(ideaUnit -> ideaUnit.getIdeaUnitDos().stream()).collect(Collectors.toList());
        ideaUnitList.stream().forEach(ideaUnitDo -> {
            ideaUnitDo.setIsNew((Boolean)isNewMap.get(ideaUnitDo.getIdeaUnitId()));
            ideaUnitDo.setLast1DayExpCnt(IdeaUnitDo.countExpCnt(ideaUnitDo, 3));
            ideaUnitDo.setLast1DayAdCost(IdeaUnitDo.countAdCost(ideaUnitDo, 3));
            ideaUnitDo.setStatAdEcpm(IdeaUnitDo.mergeStatAdEcpm(ideaUnitDo, 100L, 2));
        });
        Map<Integer, List<IdeaUnitDo>> ideaUnitMap = AdxRcmdBase.aggregateByRatioType(ideaUnitList);
        HashMap recallMap = new HashMap();
        ArrayList<IdeaUnitDo> recallList = new ArrayList<IdeaUnitDo>();
        for (Map.Entry<Integer, List<IdeaUnitDo>> entry : ideaUnitMap.entrySet()) {
            Integer ratioType = entry.getKey();
            List<IdeaUnitDo> subIdeaUnitDos = entry.getValue();
            List coldList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew()).sorted(Comparator.comparing(IdeaUnitDo::getLast1DayExpCnt)).limit(10L).collect(Collectors.toList());
            List bestList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew() == false).sorted(Comparator.comparing(IdeaUnitDo::getStatAdEcpm).reversed()).limit(30L).collect(Collectors.toList());
            ArrayList subRecallList = new ArrayList();
            subRecallList.addAll(coldList);
            subRecallList.addAll(bestList);
            recallMap.put(ratioType, subRecallList);
            recallList.addAll(subRecallList);
            ArrayList coldIds = new ArrayList();
            ArrayList bestIds = new ArrayList();
            coldList.stream().forEach(e -> {
                IdeaUnitDo tmp = new IdeaUnitDo();
                tmp.setAdIdeaId(e.getAdIdeaId());
                tmp.setIdeaUnitId(e.getIdeaUnitId());
                coldIds.add(tmp);
            });
            bestList.stream().forEach(e -> {
                IdeaUnitDo tmp = new IdeaUnitDo();
                tmp.setAdIdeaId(e.getAdIdeaId());
                tmp.setIdeaUnitId(e.getIdeaUnitId());
                bestIds.add(tmp);
            });
            print = print + "; {ratioType = " + ratioType + ", originalSize = " + subIdeaUnitDos.size() + ", coldSize = " + coldList.size() + ", coldList = " + JSON.toJSONString(coldIds) + ", bestSize = " + bestList.size() + ", bestList = " + JSON.toJSONString(bestIds) + "}";
        }
        List<AdIdeaDo> recallAdIdeaDos = AdxRcmdBase.getCovertList(recallList);
        AdxRecallRetDo ret = new AdxRecallRetDo();
        ret.setAdIdeaDos(recallAdIdeaDos);
        ret.setPrintStr(print);
        return ret;
    }

    public static AdxFactorDo adIdeaFactorRun(AdxFactorReqDo adxFactorReqDo) {
        AdxFactorDo ret = new AdxFactorDo();
        if (!AdxRcmdAlg.adxFactorReqValid(adxFactorReqDo)) {
            return ret;
        }
        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        Integer bidMode = adxIdeaDo.getBidMode();
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        String appId = adxFactorReqDo.getAppId();
        String appTrade = adxFactorReqDo.getExtAppTrade();
        String print = "adIdeaFactorRun, ideaId = " + adxIdeaDo.getIdeaId() + ", bidMode = " + bidMode + ", target = " + target + ", appTrade = " + appTrade + ", appId = " + appId;
        AdxFactorDo factorDo = Optional.ofNullable(adxFactorReqDo.getAdxFactorDo()).orElse(new AdxFactorDo());
        AdxFactorBaseDo adFactorBaseDo = factorDo.getAdFactorBaseDo();
        AdxStatsDo resoStatsDo = adxFactorReqDo.getResoStatsDo();
        AdxStatsDo adStatsDo = adxFactorReqDo.getAdxStatsDo();
        AdxRcmdAlg.adIdeaFactorRunWithPrint(print, adFactorBaseDo, null, adStatsDo, resoStatsDo, bidMode, target, "ad");
        AdxFactorBaseDo tradeFactorBaseDo = factorDo.getTradeFactorBaseDo();
        AdxStatsDo tradeStatsDo = adxFactorReqDo.getTradeStatsDo();
        if (adxFactorReqDo.getExtAppTrade() != null) {
            AdxRcmdAlg.adIdeaFactorRunWithPrint(print, tradeFactorBaseDo, adFactorBaseDo, tradeStatsDo, adStatsDo, bidMode, target, "trade");
        }
        AdxFactorBaseDo appFactorBaseDo = factorDo.getAppFactorBaseDo();
        AdxStatsDo appStatsDo = adxFactorReqDo.getAppStatsDo();
        if (adxFactorReqDo.getAppId() != null) {
            AdxRcmdAlg.adIdeaFactorRunWithPrint(print, appFactorBaseDo, tradeFactorBaseDo, appStatsDo, tradeStatsDo, bidMode, target, "app");
        }
        ColdStartFactorDo coldStartFactorDo = factorDo.getColdStartFactorDo();
        if (adxIdeaDo.getIsColdStart() == null || !adxIdeaDo.getIsColdStart().booleanValue() || adxIdeaDo.getColdStartFee() == null || adxIdeaDo.getColdStartFee() > 1L) {
            // empty if block
        }
        adFactorBaseDo.setAdxIdeaDo(adxIdeaDo);
        ret.setAdFactorBaseDo(adFactorBaseDo);
        ret.setTradeFactorBaseDo(tradeFactorBaseDo);
        ret.setAppFactorBaseDo(appFactorBaseDo);
        ret.setColdStartFactorDo(coldStartFactorDo);
        ret.setPrintStr(print);
        return ret;
    }

    public static void adIdeaFactorRunWithPrint(String print, AdxFactorBaseDo params, AdxFactorBaseDo baseParams, AdxStatsDo statsDo, AdxStatsDo baseStatsDo, Integer bidMode, Double target, String dimType) {
        print = print + "; dimType" + dimType + "; {lastParams: conf = " + params.getConf() + ", factor = " + params.getFactor();
        if (!(params.getConf() != null && params.getConf().booleanValue() || baseParams == null)) {
            params.setFactor(baseParams.getFactor());
        }
        Double factor = params.getFactor();
        AdxIndexStatDo last20MinStat = AdxRcmdBase.getStatusVo(statsDo.getLast20MinStat(), bidMode, target);
        AdxIndexStatDo last1HourStat = AdxRcmdBase.getStatusVo(statsDo.getLast1HourStat(), bidMode, target);
        AdxIndexStatDo last1DayStat = AdxRcmdBase.getStatusVo(statsDo.getLast1DayStat(), bidMode, target);
        if (!AdxRcmdBase.isConfident(last1DayStat) || AdxIndexStatDo.getExpCnt(last1HourStat) < 10L || AdxIndexStatDo.getExpCnt(last20MinStat) < 10L) {
            params.setConf(false);
            factor = factor + (1.0 - factor) * 0.2;
            params.setFactor(DataUtil.formatDouble((Double)factor, (int)4));
            return;
        }
        Double biasTarget = 0.001;
        double factorAvg = last1DayStat.getAvgfactor();
        PidController pidController = new PidController();
        double signal = pidController.update2(biasTarget.doubleValue(), last20MinStat.getBias(), last1HourStat.getBias(), last1DayStat.getBias(), factor.doubleValue(), 0.5);
        factor = 0.01 + 0.99 * (0.9 * factor + 0.1 * factorAvg) + signal;
        if (last1DayStat.getBias() < -0.02) {
            factor = Math.min(factor, 1.0);
        }
        if (last1DayStat.getBias() > 0.02) {
            factor = Math.max(factor, 1.0);
        }
        if (last1HourStat.getSucRate() < last1DayStat.getSucRate() * 0.2) {
            factor = Math.max(factor, 1.0);
        }
        factor = DataUtil.formatDouble((Double)MathUtil.stdwithBoundary((double)factor, (double)0.2, (double)2.0), (int)4);
        params.setFactor(factor);
        print = print + "; {newParams: conf = " + params.getConf() + ", factor = " + params.getFactor() + "}; data: {last1DayStat : " + JSON.toJSONString((Object)last1DayStat) + "}; {last1HourStat : " + JSON.toJSONString((Object)last1HourStat) + "}; {last20MinStat : " + JSON.toJSONString((Object)last20MinStat);
    }

    public static SlotFactorDo slotFactorRun(SlotFactorReqDo factorReqDo) {
        SlotFactorDo ret = new SlotFactorDo();
        if (!AdxRcmdAlg.slotFactorReqValid(factorReqDo)) {
            return ret;
        }
        ret.setResId(factorReqDo.getResId());
        ret.setSlotId(factorReqDo.getSlotId());
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        SlotFactorDo lastFactorDo = Optional.ofNullable(factorReqDo.getSlotFactorDo()).orElse(new SlotFactorDo());
        String print = "slotFactorRun, resId = " + factorReqDo.getResId() + ", slotId = " + factorReqDo.getSlotId() + "; {lastParams: isExplore = " + lastFactorDo.isExplore() + ", factor = " + lastFactorDo.getFactor() + ", flowRatio = " + lastFactorDo.getFlowRatio() + ", updateTime = " + lastFactorDo.getUpdateTime() + "}";
        if (!lastFactorDo.isExplore()) {
            ret.setExplore(false);
            print = print + "; {newParams: isExplore = " + ret.isExplore() + ", updateTime = " + ret.getUpdateTime() + "}";
            ret.setPrintStr(print);
            return ret;
        }
        AdxStatsDo slotStatsDo = Optional.ofNullable(factorReqDo.getSlotStatsDo()).orElse(new AdxStatsDo());
        Long last7DayExpCnt = AdxStatsDo.getExpCnt(slotStatsDo, 5);
        Long last7DayAdxCost = AdxStatsDo.getAdxCost(slotStatsDo, 5);
        Long last7DayAdCost = AdxStatsDo.getAdCost(slotStatsDo, 5);
        print = print + "; data: last7DayExpCnt = " + last7DayExpCnt + ", last7DayAdxCost = " + last7DayAdxCost + ", last7DayAdCost = " + last7DayAdCost;
        Long adxCostLimit = 10000L;
        Long expCntLimit = 5000L;
        if (last7DayAdxCost > adxCostLimit && last7DayExpCnt > expCntLimit) {
            ret.setExplore(false);
            print = print + "; {newParams: isExplore = " + ret.isExplore() + ", updateTime = " + ret.getUpdateTime() + "}";
            ret.setPrintStr(print);
            return ret;
        }
        AdxStatsDo exploreStatsDo = Optional.ofNullable(factorReqDo.getSlotExploreStatsDo()).orElse(new AdxStatsDo());
        Long last7DayEExpCnt = AdxStatsDo.getExpCnt(exploreStatsDo, 5);
        Long last7DayEAdCost = AdxStatsDo.getAdCost(exploreStatsDo, 5);
        AdxRcmdAlg.updateSlotFactor(print, ret, lastFactorDo, adxCostLimit, expCntLimit, last7DayAdxCost, last7DayExpCnt, last7DayEExpCnt, last7DayEAdCost);
        return ret;
    }

    public static void updateSlotFactor(String print, SlotFactorDo params, SlotFactorDo lastParams, long targetCost, long targetExp, long actualCost, long actualExp, long exploreCost, long exploreExp) {
        double p = 0.9;
        double factor = lastParams.getFactor();
        PidController pidController = new PidController();
        double signal1 = pidController.update((double)targetCost * p, (double)actualCost, 0.2, -0.05, 0.05);
        double signal2 = pidController.update((double)targetExp * p, (double)actualExp, 0.2, -0.05, 0.05);
        factor = 0.01 + 0.99 * factor + Math.max(signal1, signal2);
        params.setFactor(DataUtil.formatDouble((Double)MathUtil.stdwithBoundary((double)factor, (double)1.05, (double)2.0), (int)4));
        double flowRatio = lastParams.getFlowRatio();
        double r = DataUtil.division((Long)actualCost, (Long)targetCost);
        params.setFlowRatio(DataUtil.formatDouble((Double)MathUtil.stdwithBoundary((double)(flowRatio += r < 0.2 ? 0.1 : (r < 0.5 ? 0.08 : (r < 0.8 ? 0.05 : 0.02))), (double)0.1, (double)0.3), (int)4));
        params.setExplore(true);
        print = print + "; {newParams: isExplore = " + params.isExplore() + ", factor = " + params.getFactor() + ", flowRatio = " + params.getFlowRatio() + ", updateTime = " + params.getUpdateTime() + "}";
        params.setPrintStr(print);
    }

    public static boolean recallIdeaReqValid(AdxRecallReqDo recallReqDo) {
        if (recallReqDo == null) {
            logger.warn("recallIdeaRun recallReqDo is null");
            return false;
        }
        if (recallReqDo.getResId() == null) {
            logger.warn("recallIdeaRun resId is null");
            return false;
        }
        if (recallReqDo.getIdeaUnitDos() == null || recallReqDo.getIdeaUnitDos().size() < 1) {
            logger.warn("recallIdeaRun ideaUnitDos is null, resId = {}", (Object)recallReqDo.getResId());
            return false;
        }
        return true;
    }

    public static boolean recallAdIdeaReqValid(AdxRecallReqDo recallReqDo) {
        if (recallReqDo == null) {
            logger.warn("recallAdIdeaRun recallReqDo is null");
            return false;
        }
        if (recallReqDo.getResId() == null) {
            logger.warn("recallAdIdeaRun resId is null");
            return false;
        }
        if (recallReqDo.getAdIdeaDos() == null || recallReqDo.getAdIdeaDos().size() < 1) {
            logger.warn("recallAdIdeaRun adIdeaDos is null, resId = {}", (Object)recallReqDo.getResId());
            return false;
        }
        if (recallReqDo.getIdeaUnitDos() == null || recallReqDo.getIdeaUnitDos().size() < 1) {
            logger.warn("recallAdIdeaRun ideaUnitDos is null, resId = {}", (Object)recallReqDo.getResId());
            return false;
        }
        return true;
    }

    public static boolean adxFactorReqValid(AdxFactorReqDo adxFactorReqDo) {
        if (adxFactorReqDo == null) {
            logger.warn("adIdeaFactorRun adxFactorReqDo is null");
            return false;
        }
        if (adxFactorReqDo.getAdxIdeaDo() == null) {
            logger.warn("adIdeaFactorRun adxIdeaDo is null");
            return false;
        }
        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        if (adxIdeaDo.getIdeaId() == null) {
            logger.warn("adIdeaFactorRun ideaId is null");
            return false;
        }
        if (adxIdeaDo.getBidMode() == null) {
            logger.warn("adIdeaFactorRun bidMode is null, adxIdeaDo = {}", (Object)JSON.toJSONString((Object)adxIdeaDo));
            return false;
        }
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        if (target == null) {
            logger.warn("AdxRoiFactor target is null, adxIdeaDo = {}", (Object)JSON.toJSONString((Object)adxIdeaDo));
            return false;
        }
        return true;
    }

    public static boolean slotFactorReqValid(SlotFactorReqDo factorReqDo) {
        if (factorReqDo == null) {
            logger.warn("slotFactorRun factorReqDo is null");
            return false;
        }
        if (factorReqDo.getResId() == null) {
            logger.warn("slotFactorRun resId is null");
            return false;
        }
        if (factorReqDo.getSlotId() == null) {
            logger.warn("slotFactorRun slotId is null");
            return false;
        }
        return true;
    }
}

