/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRcmdBase {
    private static final Logger logger = LoggerFactory.getLogger(AdxRcmdBase.class);

    public static List<AdIdeaDo> getIntersection(List<AdIdeaDo> list1, List<AdIdeaDo> list2) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{list1, list2})) {
            return null;
        }
        List<AdIdeaDo> intersection = list2.stream().filter(a -> list1.stream().anyMatch(b -> {
            if (!Objects.equals(a.getIdeaId(), b.getIdeaId())) {
                return false;
            }
            List<IdeaUnitDo> collect = a.getIdeaUnitDos().stream().filter(c -> b.getIdeaUnitDos().stream().anyMatch(d -> Objects.equals(c.getIdeaUnitId(), d.getIdeaUnitId()))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return false;
            }
            a.setIdeaUnitDos(collect);
            return true;
        })).collect(Collectors.toList());
        return intersection;
    }

    public static List<AdIdeaDo> getRandomList(List<IdeaUnitDo> ideaUnitList, Integer limitSize) {
        List<IdeaUnitDo> candidateList;
        if (ideaUnitList.size() <= limitSize) {
            candidateList = ideaUnitList;
        } else {
            Collections.shuffle(ideaUnitList);
            candidateList = ideaUnitList.subList(0, limitSize);
        }
        List<AdIdeaDo> candidates = AdxRcmdBase.getCovertList(candidateList);
        return candidates;
    }

    public static List<AdIdeaDo> getCovertList(List<IdeaUnitDo> ideaUnitList) {
        ArrayList adIdeaDoList = new ArrayList();
        ideaUnitList.stream().forEach(ido -> {
            AdIdeaDo tmpAdIdeaDo = new AdIdeaDo();
            tmpAdIdeaDo.setIdeaId(ido.getAdIdeaId());
            ArrayList<IdeaUnitDo> tmpIdeaUnitDos = new ArrayList<IdeaUnitDo>();
            tmpIdeaUnitDos.add((IdeaUnitDo)ido);
            tmpAdIdeaDo.setIdeaUnitDos(tmpIdeaUnitDos);
            adIdeaDoList.add(tmpAdIdeaDo);
        });
        HashMap adIdeaMap = new HashMap();
        adIdeaDoList.stream().forEach(ado -> {
            AdIdeaDo tmp = (AdIdeaDo)adIdeaMap.get(ado.getIdeaId());
            if (tmp == null) {
                adIdeaMap.put(ado.getIdeaId(), ado);
            } else {
                tmp.getIdeaUnitDos().addAll(ado.getIdeaUnitDos());
            }
        });
        ArrayList<AdIdeaDo> ret = new ArrayList<AdIdeaDo>(adIdeaMap.values());
        return ret;
    }

    public static Map<Integer, List<IdeaUnitDo>> aggregateByRatioType(List<IdeaUnitDo> ideaUnitDos) {
        HashMap<Integer, List<IdeaUnitDo>> ideaUnitMap = new HashMap<Integer, List<IdeaUnitDo>>();
        ideaUnitDos.stream().forEach(ado -> {
            Integer ratioType = ado.getRatioType();
            if (ratioType == null) {
                logger.warn("ratioType is null, adIdeaId is {}, ideaUnitId is {}", (Object)ado.getAdIdeaId(), (Object)ado.getIdeaUnitId());
                return;
            }
            List subList = (List)ideaUnitMap.get(ratioType);
            if (subList == null) {
                ArrayList<IdeaUnitDo> tmp = new ArrayList<IdeaUnitDo>();
                tmp.add((IdeaUnitDo)ado);
                ideaUnitMap.put(ratioType, tmp);
            } else {
                subList.add(ado);
            }
        });
        return ideaUnitMap;
    }

    public static AdxIndexStatDo getStatusVo(AdxIndexStatDo adxStatBaseDo, Integer bidMode, Double target) {
        AdxIndexStatDo ret = new AdxIndexStatDo();
        Boolean isConfident = AdxRcmdBase.isConfident(adxStatBaseDo);
        Long bidCnt = AdxIndexStatDo.getBidCnt(adxStatBaseDo);
        Long sucCnt = AdxIndexStatDo.getBidSucCnt(adxStatBaseDo);
        Long expCnt = AdxIndexStatDo.getExpCnt(adxStatBaseDo);
        Long clickCnt = AdxIndexStatDo.getClickCnt(adxStatBaseDo);
        Long launchCnt = AdxIndexStatDo.getLaunchCnt(adxStatBaseDo);
        Long adxCost = AdxIndexStatDo.getAdxCost(adxStatBaseDo);
        Long adCost = AdxIndexStatDo.getAdCost(adxStatBaseDo);
        ret.setIsConfident(isConfident);
        ret.setBid(bidCnt);
        ret.setBidSuc(sucCnt);
        ret.setExp(expCnt);
        ret.setClick(clickCnt);
        ret.setAdvertLaunch(launchCnt);
        ret.setAdxCost(adxCost);
        ret.setAdCost(adCost);
        Double avgFactor = AdxRcmdBase.getAvgFactor(adxStatBaseDo);
        double actRoi = DataUtil.division((Double)((double)adCost.longValue() + 1000.0 * target), (Long)(adxCost + 1000L), (int)4);
        double actCpc = DataUtil.division((Double)((double)adxCost.longValue() + 10.0 * target), (Long)(clickCnt + 10L), (int)4);
        double bias = AdxRcmdBase.getBias(ret, target, bidMode, actRoi, actCpc, 0.0);
        double sucRate = DataUtil.division((Long)sucCnt, (Long)(bidCnt + 1000L), (int)4);
        ret.setAvgfactor(avgFactor);
        ret.setBias(bias);
        ret.setActRoi(actRoi);
        ret.setActCpc(actCpc);
        ret.setSucRate(sucRate);
        return ret;
    }

    public static double getBias(AdxIndexStatDo statDo, Double target, Integer bidMode, double actRoi, double actCpc, Double defaultValue) {
        double ret = defaultValue;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{statDo, target, bidMode})) {
            double realValue = bidMode == 2 ? actCpc : actRoi;
            ret = DataUtil.division((Double)(realValue - target), (Double)target, (int)4);
            ret = statDo.getIsConfident() != false ? MathUtil.stdwithBoundary((double)ret, (double)-0.5, (double)0.5) : (AdxRcmdBase.isCostConfident(statDo) ? MathUtil.stdwithBoundary((double)ret, (double)-0.2, (double)0.2) : MathUtil.stdwithBoundary((double)ret, (double)-0.1, (double)0.1));
        }
        return ret;
    }

    public static boolean isCostConfident(AdxIndexStatDo adxIndexStatDo) {
        boolean ret = false;
        if (adxIndexStatDo != null && AdxIndexStatDo.getAdxCost(adxIndexStatDo) > 2000L) {
            ret = true;
        }
        return ret;
    }

    public static boolean isExpConfident(AdxIndexStatDo adxIndexStatDo) {
        boolean ret = false;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 500L) {
            ret = true;
        }
        return ret;
    }

    public static boolean isConfident(AdxIndexStatDo adxIndexStatDo) {
        boolean ret = false;
        if (AdxRcmdBase.isCostConfident(adxIndexStatDo) && AdxRcmdBase.isExpConfident(adxIndexStatDo)) {
            ret = true;
        }
        return ret;
    }

    public static Double getStatCtr(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 200L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getClickCnt(adxIndexStatDo), (Long)AdxIndexStatDo.getExpCnt(adxIndexStatDo), (int)3);
        }
        return ret;
    }

    public static Double getStatCtr(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatCtr(adxIndexStatDo);
        if (ret == null) {
            ret = baseValue;
        }
        return ret;
    }

    public static Double getStatPvLaunch(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getClickCnt(adxIndexStatDo) > 100L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getLaunchCnt(adxIndexStatDo), (Long)AdxIndexStatDo.getClickCnt(adxIndexStatDo), (int)3);
        }
        return ret;
    }

    public static Double getStatPvLaunch(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatPvLaunch(adxIndexStatDo);
        if (ret == null) {
            ret = baseValue;
        }
        return ret;
    }

    public static Double getStatArpu(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getLaunchCnt(adxIndexStatDo) > 50L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getAdCost(adxIndexStatDo), (Long)AdxIndexStatDo.getLaunchCnt(adxIndexStatDo), (int)3);
        }
        return ret;
    }

    public static Double getStatArpu(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatArpu(adxIndexStatDo);
        if (ret == null) {
            ret = baseValue;
        }
        return ret;
    }

    public static Double getStatEcpm(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 500L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getAdCost(adxIndexStatDo), (Long)AdxIndexStatDo.getExpCnt(adxIndexStatDo), (int)3);
        }
        return ret;
    }

    public static Double getStatEcpm(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatArpu(adxIndexStatDo);
        if (ret == null) {
            ret = baseValue;
        }
        return ret;
    }

    public static Double getStatCpm(AdxIndexStatDo adxIndexStatDo) {
        Double ret = null;
        if (adxIndexStatDo != null && AdxIndexStatDo.getExpCnt(adxIndexStatDo) > 500L) {
            ret = DataUtil.division((Long)AdxIndexStatDo.getAdxCost(adxIndexStatDo), (Long)AdxIndexStatDo.getExpCnt(adxIndexStatDo), (int)3);
        }
        return ret;
    }

    public static Double getStatCpm(AdxIndexStatDo adxIndexStatDo, Double baseValue) {
        Double ret = AdxRcmdBase.getStatCpm(adxIndexStatDo);
        if (ret == null) {
            ret = baseValue;
        }
        return ret;
    }

    public static Double getAvgFactor(AdxIndexStatDo adxIndexStatDo) {
        Double ret = 1.0;
        if (adxIndexStatDo != null && adxIndexStatDo.getBid() != null && adxIndexStatDo.getFactor() != null) {
            ret = DataUtil.division((Double)adxIndexStatDo.getFactor(), (Long)adxIndexStatDo.getBid(), (int)4);
        }
        return ret;
    }
}

