package cn.com.duiba.nezha.alg.alg.advertexploitbak.matcher;

import cn.com.duiba.nezha.alg.alg.advertexploitbak.CandidateDto;
import cn.com.duiba.nezha.alg.alg.advertexploitbak.OrientationDto;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExploreMatcher {
    /**
     * 探索-利用
     *
     * @param exploreInfos
     * @return
     */
    public static List<CandidateDto> exploreMatch(List<ExploreInfo> exploreInfos, Map<String, OrientationDto> orientInfoMap, MatcherParams params) {

        ArrayList<CandidateDto> resList = new ArrayList<>();

        for (ExploreInfo exploreInfo : exploreInfos) {
            ExploreData data14day = exploreInfo.getAppAdvertInfo().getData14day();
            String key = exploreInfo.getAdvertId() + "_" + exploreInfo.getOrientationId();
            OrientationDto orientationDto = orientInfoMap.getOrDefault(key, new OrientationDto());

            if (exploitFilter(data14day.getOcpcConsume(), data14day.getExposure(),
                    orientationDto.getNewAdvert(), orientationDto.getExploreFlag(),
                    params.getConsumeThreshold(), params.getExposureThreshold(), params.getNewAdvertFactor())) {
                resList.add(new CandidateDto(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), null));
            }

        }

        return resList;
    }

    private static boolean exploitFilter(Long consume, Long exposure, Integer newAdvert, Integer exploreFlag, Long consumeThreshold, Long exposureThreshold, Double newAdvertFactor) {
        // 如果探索已经结束，直接利用
        if (exploreFlag != null && !exploreFlag.equals(0)) {
            return true;
        }

        double factor = (newAdvert == null || newAdvert.equals(0)) ? 1 : newAdvertFactor;

        // 非终止的过滤条件
        // 新广告降低过滤条件
        // 过滤条件于探索一致，适当降低相关阈值
        return consume != null && consume > consumeThreshold / factor && exposure != null && exposure > exposureThreshold / factor;
    }
}
