package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecrtlyPriceReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorSubDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.swing.text.html.Option;
import java.util.*;

import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.toList;


public class AdxDirectlyBidding {

    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);

    /**
     *
     * @param adxDirecrtlyPriceReqDo
     * @return
     */
    public static List<AdxDirecetlyPriceDo> getAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<AdxDirecetlyPriceDo> ret = new ArrayList<>();

        if(adxDirecrtlyPriceReqDo != null && adxDirecrtlyPriceReqDo.getBillType() != null
                && adxDirecrtlyPriceReqDo.getBillType().equals(1)) {
            ret = getCpmAlgoPrice(adxDirecrtlyPriceReqDo);

        } else {
            ret = getCpcAlgoPrice(adxDirecrtlyPriceReqDo);
        }

        return ret;

    }

    /**
     * 美团cpm出价
     * @param adxDirecrtlyPriceReqDo
     * @return
     */
    public static List<AdxDirecetlyPriceDo> getCpmAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<AdxDirecetlyPriceDo> ret = new ArrayList<>();

        adxDirecrtlyPriceReqDo = Optional.ofNullable(adxDirecrtlyPriceReqDo).orElse(new AdxDirecrtlyPriceReqDo());

        //广告券出价信息(cpm：1张券)
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();
        if (adxDirecetlyPriceDos == null || adxDirecetlyPriceDos.size() < 1) {
            logger.warn("MeiTuan getCpmAlgoPrice: the list of adxDirecetlyPriceDos is empty");
            return ret;
        }

        //广告位维度目标分成
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        slotShareRate = Optional.ofNullable(slotShareRate).orElse(1.);

        //维稳因子对象
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = Optional.ofNullable(slotFactorDo.getRoiFactor()).orElse(1.); //广告位维度维稳因子


        for(AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {

            //广告nezha出价信息
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();  //券CPC价格
            Double advCtr = adxDirecetlyPriceDo.getCtr(); //券CTR
            if(advPrice == null || advPrice <=0 || advCtr == null || advCtr <=0 ) {
                continue;
            }

            //计划维度目标分成
            Double advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            if(advShareRate == null || advShareRate < 0) { advShareRate = slotShareRate;}

            //计划维度上的维稳因子
            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            AdxMeiTuanFactorSubDo advFactorDo = Optional.ofNullable(AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId))
                    .orElse(new AdxMeiTuanFactorSubDo());
            Double advFactor = advFactorDo.getRoiFactor();

            // 如果计划维稳因子不置信(媒体消耗小于10元不置信)，则使用广告位维度
            if(!advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }

            // price = CPC * CTR * 分成 * 维稳因子
            double price = advPrice * advCtr * advShareRate * advFactor;

            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            ret.add(adxDirecetlyPriceDo);

        }

        return ret;
    }



    /**
     * 美团cpc出价
     * @param adxDirecrtlyPriceReqDo
     * @return
     */
    public static List<AdxDirecetlyPriceDo> getCpcAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<AdxDirecetlyPriceDo> ret = new ArrayList<>();
        List<AdxDirecetlyPriceDo> lowPriceAdv = new ArrayList<>();

        //出价阈值，当出价低于该值且竞价成功率过低时，需要适当加价
        Double priceThreshold = 80.;

        Integer groupTag = adxDirecrtlyPriceReqDo.getGroupTag();
        if (groupTag == null) {
            logger.error("adxDirecrtlyPriceReqDo groupTag is null");
            groupTag = 0;
        }

        Double floorPrice = Optional.ofNullable(adxDirecrtlyPriceReqDo.getFloorPrice()).orElse(0.);

        Integer advertCnt = adxDirecrtlyPriceReqDo.getAdvertCnt();
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        if (slotShareRate == null) {
            slotShareRate = 1.;
        }
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();

        //维稳因子对象
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());

        //广告位维度维稳因子
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = slotFactorDo.getRoiFactor();
        if(slotFactor == null) {
            slotFactor = 1.;
        }

        //竞价成功率调节因子
        Double sucFactor = slotFactorDo.getSucFactor();
        if(sucFactor == null) {
            sucFactor = 0.;
        }

        //计划维度维稳因子
        AdxMeiTuanFactorSubDo advFactorDo = new AdxMeiTuanFactorSubDo();
        Double advFactor = 1.0;
        Double adAvgPrice = 30.;

        //计划上设置的分成比例
        Double advShareRate = null;

        if(advertCnt == null) {
            advertCnt = 5;
        }

        /**
         * 头部流量抢量策略
         */
        Long reqCnt = adxDirecrtlyPriceReqDo.getReqCnt();
        Long reqThreshold = adxDirecrtlyPriceReqDo.getReqThreshold();

        if(reqThreshold == null) {reqThreshold = 1L;}

        for(AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {

            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            //nezha发券价格
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
            //过滤
            if(advPrice == null) {
                continue;
            }

            //计划维度上的维稳因子
            advFactorDo = AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId);
            if(advFactorDo != null) {
                advFactor = advFactorDo.getRoiFactor();
                adAvgPrice = advFactorDo.getCpcPrice();
            }

            //如果计划维度未设置分成比例，则使用广告维度的分成比例
            if(advShareRate == null || advShareRate < 0) {advShareRate = slotShareRate;}

            // 如果计划维稳因子不置信(媒体消耗小于10元不置信)，则使用广告位维度
            if(advFactorDo == null || !advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }

            Integer cpcTest = adxDirecetlyPriceDo.getCpcTest();
            if (cpcTest == null) {
                cpcTest = 2;
                logger.info("cpcTest{}, advFactor{}, advertId{}, shareRate{}, advPrice{}", cpcTest, advFactor, advertId, advShareRate, advPrice);
            }

            if (advFactor == null || cpcTest <= 1) {advFactor = 1.;}
            if (adAvgPrice == null) {adAvgPrice = 40.;}

            // price = 广告线发券CPC价格 * 分成比例 * 维稳因子
            double price = advPrice * advShareRate * advFactor;

            adxDirecetlyPriceDo.setOriScore(MathUtil.formatDouble(price, 6));


            /**
             * 原出价逻辑
             */
            if(cpcTest != 1 && price <= priceThreshold && sucFactor>0.1) {
                double priceLimit = price * 1.25;
                price = price + (priceThreshold - price) * sucFactor;
                price = Math.min(price, priceLimit);
            }

            double minPrice = advPrice * advShareRate * 0.75;
            double maxPrice = Math.max(advPrice * advShareRate * (advShareRate + 0.5), advPrice);
            adAvgPrice = MathUtil.stdwithBoundary(adAvgPrice,40,80);

            /**
             * 新增出价逻辑，底价区间抢量
             */

            if(cpcTest != 1 && price < adAvgPrice) {
                price = price + (adAvgPrice - price) * (advFactor - 0.75);
            }


            /**
             * 新增出价逻辑,头部流量抢量
             */
            if(cpcTest != 1 && reqCnt != null && reqCnt < reqThreshold && price < priceThreshold) {
                price = price + (priceThreshold - price) * (advFactor - 0.75);
            }

            price = MathUtil.stdwithBoundary(price, minPrice, maxPrice);
            adxDirecetlyPriceDo.setOriPrice(price);

            // 第3～5张券提价降本
//            if (reqCnt != null && reqCnt >=2 && reqCnt <= 4) {
//                double liftFactor = AdxDirecrtlyPriceReqDo.getLiftFactor1(adxDirecrtlyPriceReqDo);
//                double realFloorPrice = AdxDirecrtlyPriceReqDo.getRealFloorPrice1(adxDirecrtlyPriceReqDo);
//
//
//                // 实验组1：降本，大于30分的按一定比例降价
//                if (groupTag == 1) {
//                    if (price > 30.1) {
//                        price = price * liftFactor;
//                        if (price < 30.1) { price = 30.1; }
//                        adxDirecetlyPriceDo.setLiftFactor(liftFactor);
//                        logger.info("groupTag{}, liftFactor{}, liftPrice{}, reqCnt{}", groupTag, liftFactor, price, reqCnt);
//                    }
//                }
//                // 实验组2：提价抢量，在低于底价区间的强制提价到30分
//                else if (groupTag == 2) {
//                    if (price > realFloorPrice && price < 30.1) {
//                        price = 30.1;
//                        adxDirecetlyPriceDo.setRealFloorPrice(realFloorPrice);
//                        logger.info("groupTag{}, realFloor{}, price{}, reqCnt{}", groupTag, realFloorPrice, price, reqCnt);
//                    }
//                }
//                // 实验组3：提价与降本，综合实验1与实验2的策略
//                else if (groupTag == 3) {
//                    if (price > 30.1) {
//                        price = price * liftFactor;
//                        if (price < 30.1) { price = 30.1; }
//                        adxDirecetlyPriceDo.setLiftFactor(liftFactor);
//                        logger.info("groupTag{}, liftFactor{}, liftPrice{}, reqCnt{}", groupTag, liftFactor, price, reqCnt);
//                    }
//                    else if (price > realFloorPrice && price < 30.1) {
//                        price = 30.1;
//                        adxDirecetlyPriceDo.setRealFloorPrice(realFloorPrice);
//                        logger.info("groupTag{}, realFloor{}, price{}, reqCnt{}", groupTag, realFloorPrice, price, reqCnt);
//                    }
//                }
//            }

            //底价过滤
            if(price < floorPrice) {
                logger.info("MeiTuan floorPrice Filter, advertId:{},price:{}, cpcTest{}, advPrice{}", advertId, price, cpcTest, advPrice);
                continue;
            }

            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            double ctr = adxDirecetlyPriceDo.getCtr();
            Double cvr = adxDirecetlyPriceDo.getCvr();
            if (cvr == null) { cvr = 0.0; }
            double arpu = MathUtil.formatDouble(ctr * advPrice, 6);
            double score = MathUtil.formatDouble(ctr * price, 6);
            adxDirecetlyPriceDo.setCtr(MathUtil.formatDouble(ctr, 6));
            adxDirecetlyPriceDo.setCvr(MathUtil.formatDouble(cvr, 6));
            adxDirecetlyPriceDo.setArpu(arpu);
            adxDirecetlyPriceDo.setScore(score);

            if (cpcTest <= 1) {
                logger.info("cpcTest{}, advFactor{}, advertId{}, shareRate{}, advPrice{}, ctr{}, price{}, arpu{}, score{}", cpcTest, advFactor, advertId, advShareRate, advPrice, ctr, price, arpu, score);
            }


            ret.add(adxDirecetlyPriceDo);
        }
        List<AdxDirecetlyPriceDo> reRankRet;
        reRankRet = ret.stream().
                sorted(comparing(AdxDirecetlyPriceDo::getRankScore).reversed()).collect(toList());

        advertCnt = Math.min(advertCnt, reRankRet.size());
        ret = reRankRet.subList(0,advertCnt);

        return ret;
    }

    /**
     * 算法接口2-直投算法出价
     *
     * @param directlyIdeaInfo 直投创意信息
     * @param directlyFactorInfo 直投ROI维稳因子试探表
     * @return
     */
    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo,
                                                  AdxDirectlyFactorDo directlyFactorInfo) {

        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();

        try {

            // 1.设置默认值
            Double roiFactor = 1.0;            // ROI调节因子
            Double lowerLimit = 0.3;           // ROI调节因子下限
            Double upperLimit = 1.7;           // ROI调节因子上限

            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();


            // 2.获取统计信息
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty(directlyIdeaInfo)) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(),0L);
            }


            // 3.获取level和调节因子
            if (AssertUtil.isNotEmpty(directlyFactorInfo) && ideaBidCntMs != 0L) {

                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);

                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double(result.get("factor")), 1.0, lowerLimit, upperLimit);

            }


            // 3.计算出价
            if (AssertUtil.isNotEmpty(directlyIdeaInfo)) {

                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);

                // 出价 = 广告计划CPC出价(分) * 直投CTR预估 * 1000 /（设置ROI * ROI调节因子）
                algoPrice = Math.round(Math.floor(DataUtil.division(cpcPrice * preCtr * 1000L, minRoi * roiFactor)));

            }

            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);


        } catch(Exception e){
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);

        }

        return ret;
    }
}
