package cn.com.duiba.nezha.alg.alg.vo;

/**
 * @description 非定向广告信息
 * @param
 * @return
 */
public class NdAdvertV3Info {
    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 配置ID
     */
    private Long planId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 媒体ID
     */
    private Long appId;

//    /**
//     * 广告行业
//     */
//    private Long trade;
//
//    /**
//     * 目标转化类型
//     */
//    private Long convertType;

    /**
     * 广告在当前广告位上历史券曝光次数
     */
    private Long hisExpose;

    /**
     * 广告在当前广告位上历史有效券点击次数
     */
    private Long hisClick;

    /**
     * 广告在当前广告位上历史目标转化次数
     */
    private Long hisConvert;

    /**
     * 广告历史探索消耗
     */
    private Long hisAdvertExploreConsume;

    /**
     * 广告历史总消耗
     */
    private Long hisAdvertConsume;

    /**
     * 当前广告类型=>1:新广告;2:普通非定向广告;
     */
    private String advertType;

    /**
     * 广告+转化目标类型+广告位维度 统计信息 --实时
     */
    private NdAdvertStatusDo advSlotDayStats;

    /**
     * 广告行业+转化目标类型+广告位维度 统计信息 --实时
     */
    private NdAdvertStatusDo advTradeSlotDayStats;

    /**
     * 广告行业+转化目标类型+广告位维度 统计信息 --3日
     */
    private NdAdvertStatusDo advTradeSlotTriDayStats;

    /**
     * 广告行业+转化目标类型+媒体维度 统计信息 --实时
     */
    private NdAdvertStatusDo advTradeAppDayStats;

    /**
     * 广告行业+转化目标类型+媒体维度 统计信息 --3日
     */
    private NdAdvertStatusDo advTradeAppTriDayStats;

    /**
     * 广告行业+转化目标类型+媒体行业维度 统计信息 --实时
     */
    private NdAdvertStatusDo advTradeAppTradeDayStats;

    /**
     * 广告行业+转化目标类型+媒体行业维度 统计信息 --3日
     */
    private NdAdvertStatusDo advTradeAppTradeTriDayStats;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 预估cvr
     */
    private Double preCvr;

    /**
     * 目标转化出价
     */
    private Long bid;

    /**
     * 数据来源标识
     */
    private String recomWay; // 1-正常投放组合列表 2-二次提权组合列表 3-拓量增量组合列表 4-定向放开 5-强定向媒体充分探索

    /**
     * 强定向媒体充分探索 调权因子上限值
     */
    private Double StrTarExpAdjFacUpLimit = 1.2;

    // 以下三个字段用于二阶段提权：二阶段的探索消耗=总消耗-一阶段的探索消耗(曝光、点击同理)
    /**
     * 一阶段拓量结束时的探索消耗
     */
    private Long firExploreConsume;

    /**
     * 一阶段拓量结束时的曝光
     */
    private Long firExploreExposure;

    /**
     * 一阶段拓量结束时的点击
     */
    private Long firExploreClick;


    public Long getAdvertId() { return advertId; }

    public void setAdvertId(Long advertId) { this.advertId = advertId; }

    public Long getPlanId() { return planId; }

    public void setPlanId(Long planId) { this.planId = planId; }

    public Long getAppId() { return appId; }

    public void setAppId(Long appId) { this.appId = appId; }

//    public Long getTrade() { return trade; }
//
//    public void setTrade(Long trade) { this.trade = trade; }
//
//    public Long getConvertType() { return convertType; }
//
//    public void setConvertType(Long convertType) { this.convertType = convertType; }

    public Long getHisExpose() { return hisExpose;}

    public void setHisExpose(Long hisExpose) {this.hisExpose = hisExpose;}

    public Long getHisConvert() { return hisConvert; }

    public void setHisConvert(Long hisConvert) { this.hisConvert = hisConvert; }

    public Long getHisClick() { return hisClick; }

    public void setHisClick(Long hisClick) { this.hisClick = hisClick; }

    public Long getSlotId() { return slotId; }

    public void setSlotId(Long slotId) { this.slotId = slotId; }

    public String getAdvertType() { return advertType; }

    public void setAdvertType(String advertType) { this.advertType = advertType; }

    public NdAdvertStatusDo getAdvTradeSlotDayStats() { return advTradeSlotDayStats; }

    public void setAdvTradeSlotDayStats(NdAdvertStatusDo advTradeSlotDayStats) {
        this.advTradeSlotDayStats = advTradeSlotDayStats;
    }

    public NdAdvertStatusDo getAdvTradeSlotTriDayStats() { return advTradeSlotTriDayStats; }

    public void setAdvTradeSlotTriDayStats(NdAdvertStatusDo advTradeSlotTriDayStats) {
        this.advTradeSlotTriDayStats = advTradeSlotTriDayStats;
    }

    public NdAdvertStatusDo getAdvTradeAppDayStats() { return advTradeAppDayStats; }

    public void setAdvTradeAppDayStats(NdAdvertStatusDo advTradeAppDayStats) {
        this.advTradeAppDayStats = advTradeAppDayStats;
    }

    public NdAdvertStatusDo getAdvTradeAppTriDayStats() {
        return advTradeAppTriDayStats;
    }

    public void setAdvTradeAppTriDayStats(NdAdvertStatusDo advTradeAppTriDayStats) {
        this.advTradeAppTriDayStats = advTradeAppTriDayStats;
    }

    public NdAdvertStatusDo getAdvTradeAppTradeDayStats() {
        return advTradeAppTradeDayStats;
    }

    public void setAdvTradeAppTradeDayStats(NdAdvertStatusDo advTradeAppTradeDayStats) {
        this.advTradeAppTradeDayStats = advTradeAppTradeDayStats;
    }

    public NdAdvertStatusDo getAdvTradeAppTradeTriDayStats() {
        return advTradeAppTradeTriDayStats;
    }

    public void setAdvTradeAppTradeTriDayStats(NdAdvertStatusDo advTradeAppTradeTriDayStats) {
        this.advTradeAppTradeTriDayStats = advTradeAppTradeTriDayStats;
    }

    public Double getPreCtr() { return preCtr; }

    public void setPreCtr(Double preCtr) { this.preCtr = preCtr; }

    public Double getPreCvr() { return preCvr; }

    public void setPreCvr(Double preCvr) { this.preCvr = preCvr; }

    public Long getBid() { return bid; }

    public void setBid(Long bid) { this.bid = bid; }

    public Long getHisAdvertExploreConsume() { return hisAdvertExploreConsume; }

    public void setHisAdvertExploreConsume(Long hisAdvertExploreConsume) { this.hisAdvertExploreConsume = hisAdvertExploreConsume; }

    public Long getHisAdvertConsume() { return hisAdvertConsume; }

    public void setHisAdvertConsume(Long hisAdvertConsume) { this.hisAdvertConsume = hisAdvertConsume; }

    public NdAdvertStatusDo getAdvSlotDayStats() { return advSlotDayStats; }

    public void setAdvSlotDayStats(NdAdvertStatusDo advSlotDayStats) { this.advSlotDayStats = advSlotDayStats; }

    public String getRecomWay() { return recomWay; }

    public void setRecomWay(String recomWay) { this.recomWay = recomWay; }

    public Long getFirExploreClick() { return firExploreClick; }

    public Long getFirExploreConsume() { return firExploreConsume; }

    public Long getFirExploreExposure() { return firExploreExposure; }

    public void setFirExploreClick(Long firExploreClick) { this.firExploreClick = firExploreClick; }

    public void setFirExploreConsume(Long firExploreConsume) { this.firExploreConsume = firExploreConsume; }

    public void setFirExploreExposure(Long firExploreExposure) { this.firExploreExposure = firExploreExposure; }

    public Double getStrTarExpAdjFacUpLimit() { return StrTarExpAdjFacUpLimit; }

    public void setStrTarExpAdjFacUpLimit(Double strTarExpAdjFacUpLimit) { this.StrTarExpAdjFacUpLimit = strTarExpAdjFacUpLimit; }

}
