package cn.com.duiba.nezha.alg.alg.vo.advertsupport;

import lombok.Data;

import java.util.Map;
import java.util.Set;

@Data
public class AdvertSupportInfoV1 {

    /**
     * 广告
     */
    Long advertId;
    /**
     * 广告行业
     */
    String trade;

    /**
     * 设置最大加权阈值
     */
    Double upperLimit;

    /**
     * 设置最小加权阈值
     */
    Double lowerLimit;

    /**
     * 预估cvr
     */
    Double preCvr;
    /**
     * cvr过滤条件
     */
    Double cvrLimit = 0.01;

    /**
     * 广告下的目标转化类型
     */
    Set<Integer> convTypes;

    //限制在实验组
    SupportData advert3Day;
    SupportData advert1Day;

    Double rankScore1;//排名第一名的rankScore
    Double rankScore;//该广告的rankScore

    /**
     * 实验组+广告过去1天的转化map
     */
    Map<Integer,Long> advertConvLastDay;

    /**
     * 预估cvr类型
     */
    Integer preType;

    /**
     * 过去7天+行业+媒体上计费量
     * 过去7天+行业+媒体上的转化量
     */
    Long tradeAppClk;
    Map<Integer,Long> tradeAppConv;

    /**
     * 广告的目标转化数量：50
     * 广告的扶持转化类型：0/3/8
     */
    Long convCnt;
    Integer convType;
}
