package cn.com.duiba.nezha.alg.alg.vo.adx.directly2;

import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxStatBaseDo;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.dubbo.DubboException;
import lombok.Data;

import java.util.Optional;

@Data
public class AdxDataBaseDo {

    /**
     * 互动统计数据
     */
    private AdxStatBaseDo adxStatBaseDo1 = new AdxStatBaseDo();

    /**
     * 直投统计数据
     */
    private AdxStatBaseDo adxStatBaseDo2 = new AdxStatBaseDo();

    /**
     * 直投+互动统计数据
     */
    private AdxStatBaseDo adxStatBaseDo3 = new AdxStatBaseDo();


    public static Double getCostDiff(AdxDataBaseDo adxDataBaseDo) {
        Double ret = null;
        if(adxDataBaseDo != null) {
            AdxStatBaseDo adxStatBaseDo1 = adxDataBaseDo.getAdxStatBaseDo1();
            AdxStatBaseDo adxStatBaseDo2 = adxDataBaseDo.getAdxStatBaseDo2();
            AdxStatBaseDo adxStatBaseDo3 = adxDataBaseDo.getAdxStatBaseDo3();

            Double hdCost = Optional.ofNullable(adxStatBaseDo1.getAdxConsume3()).orElse(0.);
            Double directCost = Optional.ofNullable(adxStatBaseDo2.getAdxConsume3()).orElse(0.);
            Double totalCost = Optional.ofNullable(adxStatBaseDo3.getAdxConsume3()).orElse(0.);
            ret = MathUtil.division(Math.abs(hdCost - directCost), totalCost, 3);
        }


        return ret;
    }

    public static Double getIdeaEcpm(AdxDataBaseDo adxDataBaseDo) {
        Double ret = null;
        if(adxDataBaseDo != null) {
            AdxStatBaseDo adxStatBaseDo3 = adxDataBaseDo.getAdxStatBaseDo3();
            ret = adxStatBaseDo3.getStatECpm(adxStatBaseDo3);
        }
        return ret;
    }




}
