/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.coldstartandexplore.util;

import cn.com.duiba.nezha.alg.alg.coldstartandexplore.util.GetCvr;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEParams;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightingFunction {
    private static final Logger logger = LoggerFactory.getLogger(WeightingFunction.class);

    public static HashMap<String, Object> getAdjustWeight(STEParams steParams, List<Long> clickList, List<Double> cvrList, String paramType, Long hisClick, Double staCvr) {
        Integer coldStartThreshold3;
        Integer coldStartThreshold2;
        Integer coldStartThreshold1;
        Integer sepStageThreshold;
        HashMap<String, Object> res = new HashMap<String, Object>();
        double adjustWeight = 1.0;
        double minDimsStatCvr = GetCvr.getMinDimsStatCvr(steParams, clickList, cvrList, paramType);
        if (paramType.equals("firstSet")) {
            sepStageThreshold = steParams.getSepStageThreshold();
            coldStartThreshold1 = steParams.getColdStartThreshold1();
            coldStartThreshold2 = steParams.getColdStartThreshold2();
            coldStartThreshold3 = steParams.getColdStartThreshold3();
        } else {
            sepStageThreshold = steParams.getSepStageThresholdSet2();
            coldStartThreshold1 = steParams.getColdStartThresholdSet4();
            coldStartThreshold2 = steParams.getColdStartThresholdSet5();
            coldStartThreshold3 = steParams.getColdStartThresholdSet6();
        }
        if (hisClick < (long)sepStageThreshold.intValue()) {
            boolean b;
            boolean bl = b = staCvr <= Math.pow(10.0, -8.0) || staCvr < 0.4 * minDimsStatCvr;
            adjustWeight = (long)coldStartThreshold1.intValue() <= hisClick && hisClick < (long)coldStartThreshold2.intValue() ? (b ? 0.9 : 1.0) : ((long)coldStartThreshold2.intValue() <= hisClick && hisClick < (long)coldStartThreshold3.intValue() ? (b ? 0.8 : (staCvr < 0.7 * minDimsStatCvr ? 0.9 : 1.0)) : (hisClick >= (long)coldStartThreshold3.intValue() ? (b ? 0.7 : (staCvr < 0.7 * minDimsStatCvr ? 0.8 : 1.0)) : 1.0));
        } else {
            adjustWeight = staCvr <= Math.pow(10.0, -8.0) ? 0.1 : 0.3 + 0.6 * Math.min(1.0, MathUtil.division((double)hisClick.longValue(), (int)2000, (int)6));
        }
        res.put("adjustWeight", adjustWeight);
        res.put("minDimsStatCvr", minDimsStatCvr);
        return res;
    }

    public static double functionOfExpose(Long exposeCnt, STEParams steParams, String paramType) {
        double res = 1.0;
        double k = 1.0;
        double b = 1.0;
        Integer exposeConfidenceThreshold = 600;
        if (paramType.equals("firstSet")) {
            k = steParams.getExposureK1();
            b = steParams.getExposureUpperBound1();
            exposeConfidenceThreshold = steParams.getExposeConfidenceThreshold2();
        } else {
            k = steParams.getExposureK2();
            b = steParams.getExposureUpperBound2();
            exposeConfidenceThreshold = steParams.getExposeConfidenceThresholdSet5();
        }
        if (exposeCnt <= (long)exposeConfidenceThreshold.intValue()) {
            res = k * (double)exposeCnt.longValue() + b;
        }
        return res;
    }

    public static double decreaseFunc(int index, STEParams steParams) {
        double alpha = steParams.getAlpha();
        double beta = steParams.getBeta();
        double bias = steParams.getBias();
        return beta * Math.exp(-1.0 * alpha * ((double)index - bias));
    }
}

