/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.advert.DeepBidControl;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdFeeDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlFactors;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpcFactorParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlSubModel;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.PriceRiseParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.SlotControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidControl {
    private static final Logger log = LoggerFactory.getLogger(BidControl.class);
    public static List<Long> tradeList = Arrays.asList(15L, 16L);

    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap, OcpxControlModel paramsModel) {
        HashMap<String, AdBidResultDo> ret = new HashMap<String, AdBidResultDo>();
        for (Map.Entry<String, AdBidInputDo> entry : advertMap.entrySet()) {
            String key = entry.getKey();
            AdBidInputDo adBidInputDo = entry.getValue();
            AdBidResultDo adBidResultDo = BidControl.bidControl(adBidInputDo, paramsModel);
            ret.put(key, adBidResultDo);
        }
        return ret;
    }

    public static AdBidResultDo bidControl(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel) {
        AdBidResultDo adBidResultDo = new AdBidResultDo();
        adBidResultDo.setAdvertId(adBidInputDo.getAdvertId());
        adBidResultDo.setPackageId(adBidInputDo.getPackageId());
        adBidResultDo.setSlotId(adBidInputDo.getSlotId());
        adBidResultDo.setReservePriceGiveUp(false);
        adBidResultDo.setReserveFee(adBidInputDo.getReserveFee());
        if (adBidInputDo.getChargeType() == 1) {
            adBidResultDo.setFee(adBidInputDo.getFee());
            AdBidParamsDo cpcAdBidParamsDo = new AdBidParamsDo();
            cpcAdBidParamsDo.setIsNewOTest(adBidInputDo.getIsNewOTest());
            cpcAdBidParamsDo.setNewOAbTestId(adBidInputDo.getNewOAbTestId());
            adBidResultDo.setAdBidParamsDo(cpcAdBidParamsDo);
        }
        if (adBidInputDo.getChargeType() == 2) {
            AdBidParamsDo adBidParamsDo;
            long fee = BidControl.getOcpcFee(adBidInputDo.getCvr(), adBidInputDo.getAFee(), adBidInputDo.getAppAFee(), adBidInputDo.getSpecialAccountWeight());
            adBidResultDo.setFee(fee);
            adBidResultDo.setFactor(1.0);
            if (AssertUtil.isNotEmpty((Object)paramsModel) && AssertUtil.isNotEmpty((Object)(adBidParamsDo = BidControl.getBidParams(adBidInputDo, paramsModel, fee)))) {
                adBidResultDo.setFee(adBidParamsDo.getFee());
                adBidResultDo.setFactor(adBidParamsDo.getFactor());
                adBidResultDo.setAdBidParamsDo(adBidParamsDo);
                adBidResultDo.setReservePriceGiveUp(adBidParamsDo.getIsGiveUp());
            }
        }
        return adBidResultDo;
    }

    public static AdBidParamsDo getBidParams(AdBidInputDo adBidInputDo, OcpxControlModel paramsModel, long fee) {
        AdBidParamsDo adBidParamsDo = new AdBidParamsDo();
        Long advertId = adBidInputDo.getAdvertId();
        Long packageId = adBidInputDo.getPackageId();
        Long slotId = adBidInputDo.getSlotId();
        Long cpcFee = adBidInputDo.getFee();
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setSlotId(slotId);
        adBidParamsDo.setPackageId(packageId);
        adBidParamsDo.setAFee(adBidInputDo.getAFee());
        adBidParamsDo.setAppAFee(adBidInputDo.getAppAFee());
        adBidParamsDo.setDeepFee(adBidInputDo.getDeepFee());
        adBidParamsDo.setChargeType(adBidInputDo.getChargeType());
        adBidParamsDo.setCvrType(adBidInputDo.getCvrType());
        adBidParamsDo.setDeepCvrType(adBidInputDo.getDeepCvrType());
        adBidParamsDo.setPreDcvr(adBidInputDo.getPreDcvr());
        adBidParamsDo.setFactor(1.0);
        adBidParamsDo.setReserveFee(adBidInputDo.getReserveFee());
        adBidParamsDo.setReservePriceWhite(adBidInputDo.getReservePriceWhite());
        adBidParamsDo.setIsAutoTarget(adBidInputDo.getIsAutoTarget());
        adBidParamsDo.setAbTestId(adBidInputDo.getAbTestId());
        adBidParamsDo.setFastAbTestId(adBidInputDo.getFastAbTestId());
        adBidParamsDo.setIsNewOTest(adBidInputDo.getIsNewOTest());
        adBidParamsDo.setNewOAbTestId(adBidInputDo.getNewOAbTestId());
        adBidParamsDo.setIsColdTest(adBidInputDo.getIsColdTest());
        adBidParamsDo.setColdAbTestId(adBidInputDo.getColdAbTestId());
        adBidParamsDo.setDeepControlType(adBidInputDo.getDeepControlType());
        adBidParamsDo.setBidControlType(adBidInputDo.getBidControlType());
        adBidParamsDo.setDeepAllEffect(adBidInputDo.getDeepAllEffect());
        adBidParamsDo.setReleaseTarget(adBidInputDo.getReleaseTarget());
        adBidParamsDo.setDeepDelayType(adBidInputDo.getDeepDelayType());
        adBidParamsDo.setAppLimitReleaseMark(adBidInputDo.getAppLimitReleaseMark());
        adBidParamsDo.setPriceRiseMark(adBidInputDo.getPriceRiseMark());
        OcpxControlSubModel pModel = adBidInputDo.getOcpxControlSubModel();
        if (pModel != null) {
            int costParamsType = 1;
            if (adBidParamsDo.getIsNewOTest() != null && adBidParamsDo.getIsNewOTest().equals(2)) {
                if (adBidParamsDo.getNewOAbTestId() != null && adBidParamsDo.getNewOAbTestId().equals(2)) {
                    costParamsType = 2;
                }
            } else if (adBidParamsDo.getDeepControlType() != null) {
                if (adBidParamsDo.getAbTestId() != null && adBidParamsDo.getAbTestId().equals(2)) {
                    costParamsType = 2;
                }
            } else if (adBidParamsDo.getReleaseTarget() != null && (long)adBidParamsDo.getReleaseTarget().intValue() > 1L && (long)adBidParamsDo.getReleaseTarget().intValue() != 4L && adBidParamsDo.getBidControlType() != null && adBidParamsDo.getBidControlType().equals(2)) {
                if (adBidParamsDo.getFastAbTestId() != null && adBidParamsDo.getFastAbTestId().equals(2)) {
                    costParamsType = 2;
                }
            } else if (adBidParamsDo.getIsColdTest() != null && adBidParamsDo.getIsColdTest().equals(2) && adBidParamsDo.getColdAbTestId() != null && adBidParamsDo.getColdAbTestId().equals(2)) {
                costParamsType = 2;
            }
            BidControl.costControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType));
            BidControl.deepControl(adBidParamsDo, pModel.getDeepControlParams(costParamsType), pModel.getDeepControlParams(costParamsType, slotId), pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId));
            BidControl.exploreControl(adBidParamsDo, adBidInputDo.getExploreFactor(), adBidInputDo.getIsSupport());
            BidControl.priceRiseControl(adBidParamsDo, pModel.getPriceRiseParams(), pModel.getPriceRiseParams(slotId));
            BidControl.floorPriceControl(adBidParamsDo, pModel.getOcpxControlParams(), pModel.getOcpxControlParams(1, slotId));
            BidControl.protectControl(adBidParamsDo, pModel.getOcpxControlParams(costParamsType), pModel.getOcpxControlParams(costParamsType, slotId), pModel.getAtOcpxControlParams(costParamsType), costParamsType);
        }
        BidControl.coldControl(adBidParamsDo, paramsModel.getAdSlotControlParams(advertId, slotId), paramsModel.getSlotControlParams(slotId), cpcFee);
        return adBidParamsDo;
    }

    public static void costControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams) {
        Long factorType = null;
        Double factor = 1.0;
        Double pcFactor = 1.0;
        Double fcFactor = 1.0;
        String updateTime = null;
        Long fee = adBidParamsDo.getFee();
        Integer resetType = OcpxControlParams.getResetType(pkParams);
        OcpcFactorParams slotFactorParams = OcpxControlParams.getOcpcFactors(slotParams);
        OcpcFactorParams pkFactorParams = OcpxControlParams.getOcpcFactors(pkParams);
        OcpcFactorParams atPkFactorParams = OcpxControlParams.getOcpcFactors(atPkParams);
        Double slotFactor = slotFactorParams.getFactor();
        Double pkFactor = pkFactorParams.getFactor();
        Double atPkFactor = atPkFactorParams.getFactor();
        if (atPkFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget().booleanValue()) {
            factorType = 3L;
            factor = atPkFactor;
            pcFactor = atPkFactorParams.getPcFactor();
            fcFactor = atPkFactorParams.getFcFactor();
            updateTime = OcpxControlParams.getUpdateTime(atPkParams);
        } else if (slotFactor != null) {
            factorType = 2L;
            factor = slotFactor;
            pcFactor = slotFactorParams.getPcFactor();
            fcFactor = slotFactorParams.getFcFactor();
            updateTime = OcpxControlParams.getUpdateTime(slotParams);
        } else if (pkFactor != null) {
            factorType = 1L;
            factor = pkFactor;
            pcFactor = pkFactorParams.getPcFactor();
            fcFactor = pkFactorParams.getFcFactor();
            updateTime = OcpxControlParams.getUpdateTime(pkParams);
        } else if (Math.random() < 1.0E-4) {
            log.info("All param is null. pkId is " + adBidParamsDo.getPackageId() + "slotId is " + adBidParamsDo.getSlotId() + "abTest id is " + adBidParamsDo.getAbTestId());
        }
        Long feeNew = Math.round((double)fee.longValue() * factor);
        adBidParamsDo.setResetType(resetType);
        adBidParamsDo.setFactorType(factorType);
        adBidParamsDo.setFactor(factor);
        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setPcFactor(pcFactor);
        adBidParamsDo.setFcFactor(fcFactor);
        adBidParamsDo.setUpdateTime(updateTime);
    }

    public static void deepControl(AdBidParamsDo adBidParamsDo, DeepControlParams pkParams, DeepControlParams slotParams, OcpxControlParams pkCostParams, OcpxControlParams slotCostParams) {
        Long fee = adBidParamsDo.getFee();
        if (adBidParamsDo.getDeepControlType() == null || adBidParamsDo.getAbTestId() == null) {
            return;
        }
        boolean deepStatus = false;
        boolean isDeep = false;
        if (adBidParamsDo.getDeepFee() != null && adBidParamsDo.getDeepControlType() != null) {
            isDeep = true;
            deepStatus = true;
        }
        Double factor = 1.0;
        if (isDeep) {
            DeepControlParams useParams = new DeepControlParams();
            OcpxControlParams useCostParams = new OcpxControlParams();
            if (slotParams.getDeepFactor() != null) {
                useParams = slotParams;
                useCostParams = slotCostParams;
            } else if (pkParams.getDeepFactor() != null) {
                useParams = pkParams;
                useCostParams = pkCostParams;
            }
            DeepControlFactors useFactorDto = DeepBidControl.getDeepFactor(useCostParams, useParams, adBidParamsDo);
            Double useFactor = useFactorDto.getDeepFactor();
            if (useFactor != null) {
                factor = useFactor;
                adBidParamsDo.setPkStatDcvr(useParams.getPkStatDcvr());
                adBidParamsDo.setSlotStatDcvr(useParams.getSlotStatDcvr());
                adBidParamsDo.setDeepConfWeight(useParams.getConfWeight());
                adBidParamsDo.setStatDeepFactor(useFactorDto.getStatDeepFactor());
                adBidParamsDo.setPreDeepFactor(useFactorDto.getPreDeepFactor());
            }
            adBidParamsDo.setDeepControlFactor(factor);
            if (deepStatus) {
                Long feeNew = Math.round((double)fee.longValue() * factor);
                adBidParamsDo.setFee(feeNew);
            }
        }
    }

    public static void coldControl(AdBidParamsDo adBidParamsDo, AdControlParams adControlParams, SlotControlParams slotControlParams, Long cpcFee) {
        Boolean coldProject = null;
        Long coldProjectFeeDiff = null;
        Long fee = adBidParamsDo.getFee();
        if (slotControlParams != null && (adControlParams == null || adControlParams.getIsColdStart() == null || adControlParams.getIsColdStart().booleanValue())) {
            coldProject = true;
            Long feeNew = SlotControlParams.getFee(fee, cpcFee, slotControlParams);
            coldProjectFeeDiff = fee - feeNew;
            fee = feeNew;
        }
        adBidParamsDo.setFee(fee);
        adBidParamsDo.setDefaultFee(cpcFee);
        adBidParamsDo.setColdProject(coldProject);
        adBidParamsDo.setColdProjectFeeDiff(coldProjectFeeDiff);
    }

    public static void exploreControl(AdBidParamsDo adBidParamsDo, Double factor, Boolean isSupport) {
        if (factor == null || isSupport.booleanValue()) {
            return;
        }
        Long fee = adBidParamsDo.getFee();
        Double feeNew = (double)fee.longValue() * factor;
        adBidParamsDo.setExplore(true);
        adBidParamsDo.setExploreFactor(factor);
        adBidParamsDo.setFee(feeNew.longValue());
    }

    public static void priceRiseControl(AdBidParamsDo adBidParamsDo, PriceRiseParams pkParams, PriceRiseParams slotParams) {
        Long fee = adBidParamsDo.getFee();
        Integer priceRiseMark = adBidParamsDo.getPriceRiseMark();
        if (priceRiseMark == null || priceRiseMark.equals(0)) {
            return;
        }
        Double pkFactor = PriceRiseParams.getPrFactor(pkParams);
        Double slotFactor = PriceRiseParams.getPrFactor(slotParams);
        Double factor = 1.0;
        if (slotFactor != null) {
            factor = slotFactor;
        } else if (pkFactor != null) {
            factor = pkFactor;
        }
        Long feeNew = Math.round((double)fee.longValue() * factor);
        adBidParamsDo.setPrFactor(factor);
        adBidParamsDo.setFee(feeNew);
    }

    public static void protectControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams, OcpxControlParams atPkParams, int costParamsType) {
        Boolean secondPriceProject = null;
        Double secondProtectPriceFactor = null;
        Double extraCFactor = 1.0;
        Integer extraCSwitch = 0;
        Double slotProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(slotParams, costParamsType);
        Double pkProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(pkParams, costParamsType);
        Double atProtectPriceFactor = OcpxControlParams.getCostFactorWithProtect(atPkParams, costParamsType);
        if (atProtectPriceFactor != null && adBidParamsDo.getIsAutoTarget() != null && adBidParamsDo.getIsAutoTarget().booleanValue()) {
            secondProtectPriceFactor = atProtectPriceFactor;
            extraCFactor = atPkParams.getExtraCFactor();
            extraCSwitch = atPkParams.getExtraCSwitch();
        } else if (slotProtectPriceFactor != null) {
            secondProtectPriceFactor = slotProtectPriceFactor;
            extraCFactor = slotParams.getExtraCFactor();
            extraCSwitch = slotParams.getExtraCSwitch();
        } else if (pkProtectPriceFactor != null) {
            secondProtectPriceFactor = pkProtectPriceFactor;
            extraCFactor = pkParams.getExtraCFactor();
            extraCSwitch = pkParams.getExtraCSwitch();
        }
        if (secondProtectPriceFactor != null) {
            secondPriceProject = true;
        }
        adBidParamsDo.setSecondPriceProject(secondPriceProject);
        adBidParamsDo.setCFactor(secondProtectPriceFactor);
        adBidParamsDo.setExtraCFactor(extraCFactor);
        adBidParamsDo.setExtraCSwitch(extraCSwitch);
    }

    public static void floorPriceControl(AdBidParamsDo adBidParamsDo, OcpxControlParams pkParams, OcpxControlParams slotParams) {
        Boolean isGiveUp = null;
        if (adBidParamsDo.getReservePriceWhite() != null && adBidParamsDo.getReservePriceWhite().booleanValue()) {
            adBidParamsDo.setReservePriceWhite(true);
            return;
        }
        Long giveUpFee = null;
        Double giveUpRatio = null;
        if (slotParams != null && slotParams.getFConf() != null && slotParams.getFConf().booleanValue()) {
            giveUpFee = slotParams.getFPriceThre();
            giveUpRatio = slotParams.getFGiveUpProb();
        } else if (pkParams != null && pkParams.getFConf() != null) {
            giveUpFee = pkParams.getFPriceThre();
            giveUpRatio = pkParams.getFGiveUpProb();
        } else {
            return;
        }
        double rate = Math.random();
        if (giveUpRatio != null && giveUpFee != null && rate < giveUpRatio && adBidParamsDo.getFee() <= giveUpFee) {
            isGiveUp = true;
        }
        adBidParamsDo.setIsGiveUp(isGiveUp);
        adBidParamsDo.setGiveUpFee(giveUpFee);
        adBidParamsDo.setGiveUpRatio(giveUpRatio);
    }

    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlModel paramsModel) {
        OcpxControlParams ocpxControlParams;
        OcpxControlSubModel ocpxControlSubModel;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertId, packageId, type, paramsModel}) && (ocpxControlSubModel = paramsModel.getOcpxControlSubModel(advertId, packageId)) != null && (ocpxControlParams = ocpxControlSubModel.getOcpxControlParams()) != null) {
            ocpxControlParams.setResetType(type);
        }
    }

    public static void reSet(Long advertId, Long packageId, Integer type, OcpxControlSubModel ocpxControlSubModel) {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{advertId, packageId, type, ocpxControlSubModel}) && ocpxControlSubModel != null) {
            OcpxControlParams ocpxControlParams3;
            OcpxControlParams ocpxControlParams2;
            OcpxControlParams ocpxControlParams = ocpxControlSubModel.getOcpxControlParams();
            if (ocpxControlParams != null) {
                ocpxControlParams.setResetType(type);
            }
            if ((ocpxControlParams2 = ocpxControlSubModel.getOcpxControlParams(2)) != null) {
                ocpxControlParams2.setResetType(type);
            }
            if ((ocpxControlParams3 = ocpxControlSubModel.getOcpxControlParams(3)) != null) {
                ocpxControlParams3.setResetType(type);
            }
        }
    }

    public static AdBidResultDo reBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1) {
        if (AssertUtil.isEmpty((Object)top1)) {
            return bidResultTop1;
        }
        if (bidResultTop1 != null) {
            bidResultTop1.setFee(top1.getFee());
        }
        if (bidResultTop1 != null && bidResultTop1.getAdBidParamsDo() != null) {
            Long reserveFee;
            Boolean isSecondPriceProject = bidResultTop1.getAdBidParamsDo().getSecondPriceProject();
            Double protectPriceFactor = bidResultTop1.getAdBidParamsDo().getCFactor();
            Double extraCFactor = bidResultTop1.getAdBidParamsDo().getExtraCFactor();
            Integer extraCSwitch = bidResultTop1.getAdBidParamsDo().getExtraCSwitch();
            if (extraCSwitch != null && extraCSwitch == 1 && extraCFactor != null && !AssertUtil.isEmpty((Object)top2)) {
                top2.setFee(Math.round(extraCFactor * (double)top2.getFee().longValue()));
                if (Math.random() < 0.001) {
                    log.info("extraCFactor " + extraCFactor.toString() + " extraCSwitch" + extraCSwitch.toString() + " advertId " + top1.getAdvertId() + " pkId " + top1.getPackageId());
                }
            }
            if ((reserveFee = bidResultTop1.getReserveFee()) == null) {
                reserveFee = 15L;
            }
            if (isSecondPriceProject != null && isSecondPriceProject.booleanValue() && protectPriceFactor != null && top1.getFee() > reserveFee) {
                if (protectPriceFactor > 1.0) {
                    long protectFee = Math.round((double)top1.getFee().longValue() * protectPriceFactor);
                    bidResultTop1.setFee(protectFee);
                } else {
                    long protectFee = Math.round((double)top1.getFee().longValue() * protectPriceFactor);
                    long secondFee = protectFee = Math.max(protectFee, reserveFee);
                    if (!AssertUtil.isEmpty((Object)top2)) {
                        secondFee = BidControl.getSecondFee(top1.getCtr(), top2.getCtr(), top2.getFee());
                    }
                    long feeNew = Math.max(secondFee, protectFee);
                    feeNew = Math.min(top1.getFee(), feeNew);
                    bidResultTop1.setFee(feeNew);
                    bidResultTop1.getAdBidParamsDo().setOriginalFee(top1.getFee());
                }
            }
        }
        return bidResultTop1;
    }

    private static long getSecondFee(double ctr1, double ctr2, long fee2) {
        double feeNew = ctr2 * (double)fee2 / ctr1;
        return Math.round(feeNew) + 1L;
    }

    private static long getOcpcFee(double cvr, long afee, Long appFee, Double specialAccountWeight) {
        return appFee == null ? BidControl.getOcpcFee(cvr, afee, specialAccountWeight) : BidControl.getOcpcFee(cvr, appFee, specialAccountWeight);
    }

    private static long getOcpcFee(double cvr, long afee, Double specialAccountWeight) {
        if (specialAccountWeight == null) {
            specialAccountWeight = 1.0;
        }
        return Math.round(cvr * (double)afee * specialAccountWeight);
    }

    public static AdBidResultDo exploreReBid(AdFeeDo top1, AdFeeDo top2, AdBidResultDo bidResultTop1, Boolean isSupport) {
        if (AssertUtil.isEmpty((Object)bidResultTop1)) {
            return bidResultTop1;
        }
        if (isSupport.booleanValue()) {
            bidResultTop1.setFee(top1.getFee());
        } else if (top1 != null && top2 != null) {
            double val = Math.min(Math.max((double)top1.getFee().longValue() / bidResultTop1.getExploreFactor(), (top2.getCtr() * (double)top2.getFee().longValue() + 0.01) / top1.getCtr()), (double)top1.getFee().longValue());
            bidResultTop1.setFee(new Double(val).longValue());
        } else if (top1 != null) {
            bidResultTop1.setFee(new Double((double)top1.getFee().longValue() / bidResultTop1.getExploreFactor()).longValue());
        }
        return bidResultTop1;
    }
}

