/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecrtlyPriceReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorSubDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxDirectlyBidding {
    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);
    public static final HashSet<Long> advertWhiteList = new HashSet<Long>(){
        {
            this.add(77526L);
            this.add(77578L);
            this.add(77579L);
        }
    };
    public static final HashSet<Long> OperatorAdvertList = new HashSet<Long>(){
        {
            this.add(72855L);
            this.add(73693L);
            this.add(74037L);
            this.add(74186L);
            this.add(76613L);
            this.add(77526L);
            this.add(77527L);
            this.add(77548L);
            this.add(77578L);
            this.add(77579L);
            this.add(77607L);
            this.add(77750L);
            this.add(77767L);
            this.add(77795L);
            this.add(77829L);
            this.add(77858L);
        }
    };
    public static final HashMap<Long, Double> newTradeMap1 = new HashMap<Long, Double>(){
        {
            this.put(21L, 35.0);
            this.put(19L, 35.0);
            this.put(15L, 32.0);
            this.put(16L, 35.0);
            this.put(6L, 35.0);
        }
    };
    public static final HashMap<Long, Double> newTradeMap2 = new HashMap<Long, Double>(){
        {
            this.put(21L, 40.0);
            this.put(19L, 40.0);
            this.put(15L, 32.0);
            this.put(16L, 35.0);
            this.put(6L, 40.0);
        }
    };
    public static final LinkedHashMap<String, Double> rateMap = new LinkedHashMap<String, Double>(){
        {
            this.put("1", 20.0);
            this.put("2", 20.0);
            this.put("3", 20.0);
            this.put("4", 20.0);
            this.put("5", 20.0);
        }
    };

    public static List<AdxDirecetlyPriceDo> getAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<Object> ret = new ArrayList();
        ret = adxDirecrtlyPriceReqDo != null && adxDirecrtlyPriceReqDo.getBillType() != null && adxDirecrtlyPriceReqDo.getBillType().equals(1) ? AdxDirectlyBidding.getCpmAlgoPrice(adxDirecrtlyPriceReqDo) : AdxDirectlyBidding.getCpcAlgoPrice(adxDirecrtlyPriceReqDo);
        return ret;
    }

    public static List<AdxDirecetlyPriceDo> getCpmAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        ArrayList<AdxDirecetlyPriceDo> ret = new ArrayList<AdxDirecetlyPriceDo>();
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = (adxDirecrtlyPriceReqDo = Optional.ofNullable(adxDirecrtlyPriceReqDo).orElse(new AdxDirecrtlyPriceReqDo())).getAdxDirecetlyPriceDos();
        if (adxDirecetlyPriceDos == null || adxDirecetlyPriceDos.size() < 1) {
            logger.warn("MeiTuan getCpmAlgoPrice: the list of adxDirecetlyPriceDos is empty");
            return ret;
        }
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        slotShareRate = Optional.ofNullable(slotShareRate).orElse(1.0);
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = Optional.ofNullable(slotFactorDo.getRoiFactor()).orElse(1.0);
        for (AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
            Double advCtr = adxDirecetlyPriceDo.getCtr();
            if (advPrice == null || advPrice <= 0.0 || advCtr == null || advCtr <= 0.0) continue;
            Double advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            if (advShareRate == null || advShareRate < 0.0) {
                advShareRate = slotShareRate;
            }
            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            AdxMeiTuanFactorSubDo advFactorDo = Optional.ofNullable(AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId)).orElse(new AdxMeiTuanFactorSubDo());
            Double advFactor = advFactorDo.getRoiFactor();
            if (!advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }
            double price = advPrice * advCtr * advShareRate * advFactor;
            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            ret.add(adxDirecetlyPriceDo);
        }
        return ret;
    }

    public static List<AdxDirecetlyPriceDo> getCpcAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        Double sucFactor;
        ArrayList<AdxDirecetlyPriceDo> ret = new ArrayList();
        ArrayList lowPriceAdv = new ArrayList();
        Double priceThreshold = 80.0;
        Integer groupTag = adxDirecrtlyPriceReqDo.getGroupTag();
        if (groupTag == null) {
            logger.error("adxDirecrtlyPriceReqDo groupTag is null");
            groupTag = 0;
        }
        double liftFactor = AdxDirecrtlyPriceReqDo.getLiftFactor1(adxDirecrtlyPriceReqDo);
        double realFloorPrice = AdxDirecrtlyPriceReqDo.getRealFloorPrice1(adxDirecrtlyPriceReqDo);
        Double floorPrice = Optional.ofNullable(adxDirecrtlyPriceReqDo.getFloorPrice()).orElse(0.0);
        Integer advertCnt = adxDirecrtlyPriceReqDo.getAdvertCnt();
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        if (slotShareRate == null) {
            slotShareRate = 1.0;
        }
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = slotFactorDo.getRoiFactor();
        if (slotFactor == null) {
            slotFactor = 1.0;
        }
        if ((sucFactor = slotFactorDo.getSucFactor()) == null) {
            sucFactor = 0.0;
        }
        AdxMeiTuanFactorSubDo advFactorDo = new AdxMeiTuanFactorSubDo();
        Double advFactor = 1.0;
        Double adAvgPrice = 30.0;
        Double advShareRate = null;
        if (advertCnt == null) {
            advertCnt = 5;
        }
        Long reqCnt = adxDirecrtlyPriceReqDo.getReqCnt();
        Long reqThreshold = adxDirecrtlyPriceReqDo.getReqThreshold();
        if (reqThreshold == null) {
            reqThreshold = 1L;
        }
        double rand = Math.random();
        for (AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {
            Long newTradeId;
            Integer cpcTest;
            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
            if (advPrice == null) continue;
            advFactorDo = AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId);
            if (advFactorDo != null) {
                advFactor = advFactorDo.getRoiFactor();
                adAvgPrice = advFactorDo.getCpcPrice();
            }
            if (advShareRate == null || advShareRate < 0.0) {
                advShareRate = slotShareRate;
            }
            if (advFactorDo == null || !advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }
            if ((cpcTest = adxDirecetlyPriceDo.getCpcTest()) == null) {
                cpcTest = 2;
                logger.info("cpcTestNull{}, advFactor{}, advertId{}, shareRate{}, advPrice{}, reqCnt{}", new Object[]{cpcTest, advFactor, advertId, advShareRate, advPrice, reqCnt});
            }
            if (advFactor == null) {
                advFactor = 1.0;
            }
            if (groupTag >= 2) {
                advFactor = 1.0;
            }
            if (cpcTest <= 1) {
                advFactor = 1.0;
            }
            if (adAvgPrice == null) {
                adAvgPrice = 40.0;
            }
            double price = advPrice * advShareRate * advFactor;
            double ctr = adxDirecetlyPriceDo.getCtr();
            adxDirecetlyPriceDo.setOriPrice(MathUtil.formatDouble((double)price, (int)6));
            adxDirecetlyPriceDo.setOriScore(MathUtil.formatDouble((double)(ctr * price), (int)6));
            Double cvr = adxDirecetlyPriceDo.getCvr();
            if (cvr == null) {
                cvr = 0.0;
            }
            if ((newTradeId = adxDirecetlyPriceDo.getNewTradeId()) == null) {
                newTradeId = -1L;
            }
            long exploreId = AdxDirectlyBidding.getExploreId(advPrice, newTradeId, advertId, liftFactor);
            adxDirecetlyPriceDo.setExploreId(exploreId);
            if (cpcTest != 1 && groupTag == 0) {
                price = AdxDirectlyBidding.lowPriceAdd(price, priceThreshold, sucFactor, adAvgPrice, advFactor, reqCnt, reqThreshold, advPrice, advShareRate, liftFactor);
            } else if (cpcTest != 1 && groupTag == 1) {
                price = AdxDirectlyBidding.cpcAdjustPrice(floorPrice, liftFactor, realFloorPrice, newTradeId, advPrice, advShareRate, advFactor);
            } else if (cpcTest != 1 && groupTag == 2) {
                AdxDirectlyBidding.getPriceExploreFactor(rand, adxDirecetlyPriceDo);
                if ((int)liftFactor == 1) {
                    price = adxDirecetlyPriceDo.getPriceFactor();
                }
            } else if (cpcTest != 1 && groupTag == 3 && (OperatorAdvertList.contains(advertId) || newTradeId == 16L)) {
                price = AdxDirectlyBidding.doubleAdjustPrice(price, floorPrice, liftFactor, realFloorPrice);
            } else if (cpcTest != 1 && groupTag == 4) {
                price = AdxDirectlyBidding.doubleAdjustPrice(price, floorPrice, liftFactor, realFloorPrice);
            }
            adxDirecetlyPriceDo.setRealFloorPrice(realFloorPrice);
            adxDirecetlyPriceDo.setLiftFactor(liftFactor);
            if (price < floorPrice) {
                logger.info("MT floorPrice Filter, advertId{}, price{}, cpcTest{}, advPrice{}, reqCnt{}, groupTag{}, tradeId{}", new Object[]{advertId, price, cpcTest, advPrice, reqCnt, groupTag, newTradeId});
                continue;
            }
            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            double arpu = MathUtil.formatDouble((double)(ctr * advPrice), (int)6);
            double score = MathUtil.formatDouble((double)(ctr * price), (int)6);
            adxDirecetlyPriceDo.setCtr(MathUtil.formatDouble((double)ctr, (int)6));
            adxDirecetlyPriceDo.setCvr(MathUtil.formatDouble((double)cvr, (int)6));
            adxDirecetlyPriceDo.setArpu(arpu);
            adxDirecetlyPriceDo.setScore(score);
            adxDirecetlyPriceDo.setAdvShareRate(advShareRate);
            if (Math.random() <= 0.1) {
                logger.info("cpcTest{}, reqCnt{}, groupTag{}, advFactor{}, advertId{}, shareRate{}, advPrice{}, ctr{}, price{}, arpu{}, tradeId{}", new Object[]{cpcTest, reqCnt, groupTag, advFactor, advertId, advShareRate, advPrice, ctr, price, arpu, newTradeId});
            }
            ret.add(adxDirecetlyPriceDo);
        }
        List<AdxDirecetlyPriceDo> reRankRet = ret.stream().sorted(Comparator.comparing(AdxDirecetlyPriceDo::getRankScore).reversed()).collect(Collectors.toList());
        advertCnt = Math.min(advertCnt, reRankRet.size());
        if (groupTag == 4) {
            reRankRet = AdxDirectlyBidding.categoryDiversity(reRankRet);
        }
        ret = reRankRet.subList(0, advertCnt);
        if (reqCnt == null) {
            logger.info("reqCnt is null");
        }
        if (Math.random() <= 0.2) {
            logger.info("groupTag{}, ret{}, liftFactor{}, realFloorPrice{}, reqCnt{}, reRankRet{}", new Object[]{groupTag, JSONObject.toJSONString(ret), liftFactor, realFloorPrice, reqCnt, reRankRet.size()});
        }
        return ret;
    }

    public static void getPriceExploreFactor(double rand, AdxDirecetlyPriceDo adxDirecetlyPriceDo) {
        double expRate = 0.2;
        String level = AdxDirectlyBidding.doubleMap(rateMap, rand);
        assert (level != null);
        int level1 = Integer.parseInt(level);
        double defaultValue = (double)(level1 + 1) * 0.5;
        double priceFactor = adxDirecetlyPriceDo.getFactorExploreMap().getOrDefault(level, defaultValue);
        adxDirecetlyPriceDo.setPriceFactor(priceFactor);
        adxDirecetlyPriceDo.setLevel(level1);
    }

    public static String doubleMap(Map<String, Double> map, double rand) {
        if (AssertUtil.isEmpty(map)) {
            logger.warn("priceExploreExp mapSample param is invalid, params invalid");
            return null;
        }
        double w = 0.0;
        try {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!(rand <= (w += entry.getValue().doubleValue()))) continue;
                return entry.getKey();
            }
        }
        catch (Exception e) {
            logger.error("priceExploreExp mapSample happened error: ", (Throwable)e);
        }
        return null;
    }

    public static List<AdxDirecetlyPriceDo> categoryDiversity(List<AdxDirecetlyPriceDo> reRankRet) {
        ArrayList<AdxDirecetlyPriceDo> reRankRet1 = new ArrayList<AdxDirecetlyPriceDo>();
        ArrayList<AdxDirecetlyPriceDo> reRankRet2 = new ArrayList<AdxDirecetlyPriceDo>();
        HashSet<Long> newTradeIdList1 = new HashSet<Long>();
        for (AdxDirecetlyPriceDo adxDirecetlyPriceDo : reRankRet) {
            Long tradeId = adxDirecetlyPriceDo.getNewTradeId();
            if (!newTradeIdList1.contains(tradeId)) {
                newTradeIdList1.add(tradeId);
                reRankRet1.add(adxDirecetlyPriceDo);
                continue;
            }
            reRankRet2.add(adxDirecetlyPriceDo);
        }
        reRankRet1.addAll(reRankRet2);
        if (Math.random() <= 0.05) {
            logger.info("reRankRet1{}, reRankRet2{}", reRankRet1, reRankRet2);
        }
        return reRankRet1;
    }

    public static double lowPriceAdd(double price, double priceThreshold, double sucFactor, double adAvgPrice, double advFactor, Long reqCnt, long reqThreshold, double advPrice, double advShareRate, double liftFactor) {
        if (price <= priceThreshold && sucFactor > 0.1) {
            double priceLimit = price * 1.25;
            price += (priceThreshold - price) * sucFactor * liftFactor;
            price = Math.min(price, priceLimit);
        }
        if (price < (adAvgPrice = MathUtil.stdwithBoundary((double)adAvgPrice, (double)40.0, (double)80.0))) {
            price += (adAvgPrice - price) * (advFactor - 0.75) * liftFactor;
        }
        if (reqCnt != null && reqCnt < reqThreshold && price < priceThreshold) {
            price += (priceThreshold - price) * (advFactor - 0.75) * liftFactor;
        }
        double minPrice = advPrice * advShareRate * 0.75;
        double maxPrice = Math.max(advPrice * advShareRate * (advShareRate + 0.5), advPrice);
        price = MathUtil.stdwithBoundary((double)price, (double)minPrice, (double)maxPrice);
        return price;
    }

    public static long getExploreId(Double advPrice, Long newTradeId, Long advertId, Double liftFactor) {
        int mod = liftFactor.intValue();
        if (mod == 1) {
            if (advPrice <= 35.0) {
                return 1L;
            }
            if (advPrice <= 40.0) {
                return 2L;
            }
            if (advPrice <= 50.0) {
                return 3L;
            }
            return 4L;
        }
        if (mod == 2) {
            return newTradeId;
        }
        if (mod == 3) {
            return 1L;
        }
        if (mod == 4) {
            if (advPrice <= 35.0) {
                return newTradeId * 10L + 1L;
            }
            if (advPrice <= 40.0) {
                return newTradeId * 10L + 2L;
            }
            if (advPrice <= 50.0) {
                return newTradeId * 10L + 3L;
            }
            return newTradeId * 10L + 4L;
        }
        return advertId;
    }

    public static double doubleAdjustPrice(double price, double floorPrice, double liftFactor, double realFloorPrice) {
        if (price > realFloorPrice && price <= 100.0) {
            price *= liftFactor;
        }
        if (price <= floorPrice && price >= realFloorPrice) {
            price = floorPrice + 0.2;
        }
        return price;
    }

    public static double cpcAdjustPrice(double floorPrice, double liftFactor, double realFloorPrice, long newTradeId, double advPrice, double advShareRate, double advFactor) {
        double price = advPrice * advShareRate;
        double basePrice = floorPrice + 0.2;
        if (price <= floorPrice && price >= realFloorPrice) {
            return basePrice;
        }
        if (price > basePrice) {
            int liftCate = (int)liftFactor;
            if (liftCate == 1) {
                price = newTradeMap1.getOrDefault(newTradeId, 32.0);
            } else if (liftCate == 2) {
                price = newTradeMap2.getOrDefault(newTradeId, 32.0);
            } else if (liftCate >= 3 && liftCate <= 10) {
                price = newTradeMap1.getOrDefault(newTradeId, 32.0) + (double)liftCate - 2.0;
            } else if (liftCate > 10) {
                price = newTradeMap2.getOrDefault(newTradeId, 32.0) + (double)liftCate - 10.0;
            }
            return Math.max(basePrice, price * advFactor);
        }
        return price * advFactor;
    }

    public static double upperAdjustPrice(double price, double floorPrice, double liftFactor, double realFloorPrice) {
        if (price >= realFloorPrice && price <= 100.0) {
            price *= Math.pow(liftFactor, (100.0 - price) / (100.0 - realFloorPrice));
        }
        if (price <= floorPrice && price >= realFloorPrice) {
            price = floorPrice + 0.2;
        }
        return price;
    }

    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo, AdxDirectlyFactorDo directlyFactorInfo) {
        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();
        try {
            Double roiFactor = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{directlyIdeaInfo})) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(), 0L);
            }
            if (AssertUtil.isNotEmpty((Object)directlyFactorInfo) && ideaBidCntMs != 0L) {
                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);
                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double((String)result.get("factor")), 1.0, lowerLimit, upperLimit);
            }
            if (AssertUtil.isNotEmpty((Object)directlyIdeaInfo)) {
                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);
                algoPrice = Math.round(Math.floor(DataUtil.division((Double)(cpcPrice * preCtr * 1000.0), (Double)(minRoi * roiFactor))));
            }
            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);
        }
        catch (Exception e) {
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);
        }
        return ret;
    }
}

