/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.ExplorePriceDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeiTuanExplorePrice {
    private static final Logger logger = LoggerFactory.getLogger(MeiTuanExplorePrice.class);

    public static Map<String, Double> updatePriceExploreList(List<ExplorePriceDo> priceExploreDoList, Map<String, Double> lastPriceExploreMap, Double liftFactor, Double realFloorPrice) {
        Map<String, Double> consumeResultMap;
        if (lastPriceExploreMap == null) {
            lastPriceExploreMap = new HashMap<String, Double>();
        }
        if (liftFactor == null) {
            liftFactor = 1.0;
        }
        if (realFloorPrice == null) {
            realFloorPrice = 1.0;
        }
        if (AssertUtil.isEmpty(consumeResultMap = MeiTuanExplorePrice.getResultMap(priceExploreDoList, lastPriceExploreMap, liftFactor))) {
            MeiTuanExplorePrice.defaultResultMap(consumeResultMap);
        }
        return consumeResultMap;
    }

    public static void defaultResultMap(Map<String, Double> resultMap) {
        for (int i = 1; i <= 5; ++i) {
            double defaultValue = (double)(i + 1) * 0.5;
            resultMap.put(i + "", defaultValue);
        }
    }

    public static Map<String, Double> getResultMap(List<ExplorePriceDo> priceExploreDoList, Map<String, Double> lastPriceExploreMap, Double minStepSize) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        if (priceExploreDoList.size() != 5) {
            logger.info("updatePriceExploreList input data error {}", priceExploreDoList);
            return retMap;
        }
        String bestKey = MeiTuanExplorePrice.getBestKey(priceExploreDoList);
        Map<String, Double> factorMap = MeiTuanExplorePrice.getFactorMap(bestKey, minStepSize, lastPriceExploreMap);
        double bestFactor = factorMap.getOrDefault("bestFactor", 2.0);
        double stepSize = factorMap.getOrDefault("stepSize", 0.5);
        double idx = factorMap.getOrDefault("idx", 0.0);
        for (int level = 1; level <= 5; ++level) {
            double factor = bestFactor + (double)(level - 3) * stepSize;
            retMap.put(level + "", factor);
        }
        retMap.put("idx", idx);
        logger.info("updatePriceExploreList, curPriceMap {}, lastPriceMap{}, priceDoList{}, bestKey{}", new Object[]{retMap, lastPriceExploreMap, priceExploreDoList, bestKey});
        return retMap;
    }

    public static String getBestKey(List<ExplorePriceDo> priceExploreDoList) {
        return MeiTuanExplorePrice.findKey(priceExploreDoList);
    }

    public static String findKey(List<ExplorePriceDo> priceExploreDoList) {
        double bestEffect = Double.NEGATIVE_INFINITY;
        String bestKey = "-1";
        for (ExplorePriceDo levelDo : priceExploreDoList) {
            if (!AssertUtil.isNotEmpty((Object)levelDo)) continue;
            String key = levelDo.getLevel();
            Double effect = ExplorePriceDo.getEffect(levelDo);
            if (!AssertUtil.isNotEmpty((Object)effect) || !(effect > bestEffect)) continue;
            bestEffect = effect;
            bestKey = key;
        }
        return bestKey;
    }

    public static Map<String, Double> getFactorMap(String bestKey, double minStepSize, Map<String, Double> lastPriceExploreMap) {
        double stepSize;
        HashMap<String, Double> tmpMap = new HashMap<String, Double>();
        double upper = 5.0;
        double lower = 0.3;
        double bestFactor = MathUtil.stdwithBoundary((double)lastPriceExploreMap.getOrDefault(bestKey, 2.0), (double)lower, (double)upper);
        double oldBase = lastPriceExploreMap.getOrDefault("3", 2.0);
        double idx = lastPriceExploreMap.getOrDefault("idx", 0.0);
        idx = bestFactor == oldBase ? (idx += 1.0) : 0.0;
        if (idx >= 4.0) {
            if (bestFactor >= 3.0) {
                stepSize = 5.0 * minStepSize;
                bestFactor -= 2.0 * stepSize;
                idx = 0.0;
            } else {
                stepSize = 2.0 * minStepSize;
            }
        } else {
            double stepSizeU = bestFactor - oldBase > 0.0 ? Math.min((upper - bestFactor) / 2.0, 1.0) : Math.min((bestFactor - lower) / 2.0, 1.0);
            stepSize = MathUtil.stdwithBoundary((double)Math.abs(bestFactor - oldBase), (double)minStepSize, (double)stepSizeU);
        }
        tmpMap.put("bestFactor", bestFactor);
        tmpMap.put("stepSize", stepSize);
        tmpMap.put("idx", idx);
        return tmpMap;
    }
}

