package cn.com.duiba.nezha.alg.alg.adx.directly;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.priceExploreLevelEnum;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDircetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxDirectlyIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecetlyPriceDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxDirecrtlyPriceReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan.AdxMeiTuanFactorSubDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidReq;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.swing.text.html.Option;
import java.util.*;

import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.toList;


public class AdxDirectlyBidding {

    private static final Logger logger = LoggerFactory.getLogger(AdxDirectlyBidding.class);
    public static final HashSet<Long> advertWhiteList = new HashSet<Long>(){ {add(77526L); add(77578L); add(77579L);} };
    public static final HashSet<Long> OperatorAdvertList = new HashSet<Long>(){ {
        add(72855L); add(73693L); add(74037L);
        add(74186L); add(76613L); add(77526L);
        add(77527L); add(77548L); add(77578L);
        add(77579L); add(77607L); add(77750L);
        add(77767L); add(77795L); add(77829L);
        add(77858L);} };

    public static final HashMap<Long, Double> newTradeMap1 = new HashMap<Long, Double>() {
        {
            put(21L, 35.0);
            put(19L, 35.0);
            put(15L, 32.0);
            put(16L, 35.0);
            put(6L, 35.0);
        }
    };

    public static final HashMap<Long, Double> newTradeMap2 = new HashMap<Long, Double>() {
        {
            put(21L, 40.0);
            put(19L, 40.0);
            put(15L, 32.0);
            put(16L, 35.0);
            put(6L, 40.0);
        }
    };


    /**
     *
     * @param adxDirecrtlyPriceReqDo
     * @return
     */
    public static List<AdxDirecetlyPriceDo> getAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<AdxDirecetlyPriceDo> ret = new ArrayList<>();

        if(adxDirecrtlyPriceReqDo != null && adxDirecrtlyPriceReqDo.getBillType() != null
                && adxDirecrtlyPriceReqDo.getBillType().equals(1)) {
            ret = getCpmAlgoPrice(adxDirecrtlyPriceReqDo);

        } else {
            ret = getCpcAlgoPrice(adxDirecrtlyPriceReqDo);
        }

        return ret;

    }

    /**
     * 美团cpm出价
     * @param adxDirecrtlyPriceReqDo
     * @return
     */
    public static List<AdxDirecetlyPriceDo> getCpmAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<AdxDirecetlyPriceDo> ret = new ArrayList<>();

        adxDirecrtlyPriceReqDo = Optional.ofNullable(adxDirecrtlyPriceReqDo).orElse(new AdxDirecrtlyPriceReqDo());

        //广告券出价信息(cpm：1张券)
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();
        if (adxDirecetlyPriceDos == null || adxDirecetlyPriceDos.size() < 1) {
            logger.warn("MeiTuan getCpmAlgoPrice: the list of adxDirecetlyPriceDos is empty");
            return ret;
        }

        //广告位维度目标分成
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        slotShareRate = Optional.ofNullable(slotShareRate).orElse(1.);

        //维稳因子对象
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = Optional.ofNullable(slotFactorDo.getRoiFactor()).orElse(1.); //广告位维度维稳因子


        for(AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {

            //广告nezha出价信息
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();  //券CPC价格
            Double advCtr = adxDirecetlyPriceDo.getCtr(); //券CTR
            if(advPrice == null || advPrice <=0 || advCtr == null || advCtr <=0 ) {
                continue;
            }

            //计划维度目标分成
            Double advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            if(advShareRate == null || advShareRate < 0) { advShareRate = slotShareRate;}

            //计划维度上的维稳因子
            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            AdxMeiTuanFactorSubDo advFactorDo = Optional.ofNullable(AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId))
                    .orElse(new AdxMeiTuanFactorSubDo());
            Double advFactor = advFactorDo.getRoiFactor();

            // 如果计划维稳因子不置信(媒体消耗小于10元不置信)，则使用广告位维度
            if(!advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }

            // price = CPC * CTR * 分成 * 维稳因子
            double price = advPrice * advCtr * advShareRate * advFactor;

            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            ret.add(adxDirecetlyPriceDo);

        }

        return ret;
    }



    /**
     * 美团cpc出价
     * @param adxDirecrtlyPriceReqDo
     * @return
     */
    public static List<AdxDirecetlyPriceDo> getCpcAlgoPrice(AdxDirecrtlyPriceReqDo adxDirecrtlyPriceReqDo) {
        List<AdxDirecetlyPriceDo> ret = new ArrayList<>();
        List<AdxDirecetlyPriceDo> lowPriceAdv = new ArrayList<>();

        //出价阈值，当出价低于该值且竞价成功率过低时，需要适当加价
        Double priceThreshold = 80.;

        Integer groupTag = adxDirecrtlyPriceReqDo.getGroupTag();
        if (groupTag == null) {
            logger.error("adxDirecrtlyPriceReqDo groupTag is null");
            groupTag = 0;
        }

        double liftFactor = AdxDirecrtlyPriceReqDo.getLiftFactor1(adxDirecrtlyPriceReqDo); // groupTag=3
        double realFloorPrice = AdxDirecrtlyPriceReqDo.getRealFloorPrice1(adxDirecrtlyPriceReqDo); // groupTag=3

        Double floorPrice = Optional.ofNullable(adxDirecrtlyPriceReqDo.getFloorPrice()).orElse(0.);

        Integer advertCnt = adxDirecrtlyPriceReqDo.getAdvertCnt();
        Double slotShareRate = AdxDirecrtlyPriceReqDo.getShareRate(adxDirecrtlyPriceReqDo);
        if (slotShareRate == null) {
            slotShareRate = 1.;
        }
        List<AdxDirecetlyPriceDo> adxDirecetlyPriceDos = adxDirecrtlyPriceReqDo.getAdxDirecetlyPriceDos();

        //维稳因子对象
        AdxMeiTuanFactorDo adxMeiTuanFactorDo = Optional.ofNullable(adxDirecrtlyPriceReqDo.getAdxMeiTuanFactorDo()).orElse(new AdxMeiTuanFactorDo());

        //广告位维度维稳因子
        AdxMeiTuanFactorSubDo slotFactorDo = adxMeiTuanFactorDo.getSlotFactorDo();
        Double slotFactor = slotFactorDo.getRoiFactor();
        if(slotFactor == null) {
            slotFactor = 1.;
        }

        //竞价成功率调节因子
        Double sucFactor = slotFactorDo.getSucFactor();
        if(sucFactor == null) {
            sucFactor = 0.;
        }

        //计划维度维稳因子
        AdxMeiTuanFactorSubDo advFactorDo = new AdxMeiTuanFactorSubDo();
        Double advFactor = 1.0;
        Double adAvgPrice = 30.;

        //计划上设置的分成比例
        Double advShareRate = null;

        if(advertCnt == null) {
            advertCnt = 5;
        }

        /**
         * 头部流量抢量策略
         */
        Long reqCnt = adxDirecrtlyPriceReqDo.getReqCnt();
        Long reqThreshold = adxDirecrtlyPriceReqDo.getReqThreshold();

        if(reqThreshold == null) {reqThreshold = 1L;}

        double rand = Math.random();

        for(AdxDirecetlyPriceDo adxDirecetlyPriceDo : adxDirecetlyPriceDos) {

            Long advertId = adxDirecetlyPriceDo.getAdvertId();
            advShareRate = AdxDirecetlyPriceDo.getShareRate(adxDirecetlyPriceDo);
            //nezha发券价格
            Double advPrice = adxDirecetlyPriceDo.getAdvPrice();
            //过滤
            if(advPrice == null) {
                continue;
            }

            //计划维度上的维稳因子
            advFactorDo = AdxMeiTuanFactorDo.getAdvFactorSubDo(adxMeiTuanFactorDo, advertId);
            if(advFactorDo != null) {
                advFactor = advFactorDo.getRoiFactor();
                adAvgPrice = advFactorDo.getCpcPrice();
            }

            //如果计划维度未设置分成比例，则使用广告维度的分成比例
            if(advShareRate == null || advShareRate < 0) {advShareRate = slotShareRate;}

            // 如果计划维稳因子不置信(媒体消耗小于10元不置信)，则使用广告位维度
            if(advFactorDo == null || !advFactorDo.isConfident()) {
                advFactor = slotFactor;
            }

            Integer cpcTest = adxDirecetlyPriceDo.getCpcTest();
            if (cpcTest == null) {
                cpcTest = 2;
                logger.info("cpcTestNull{}, advFactor{}, advertId{}, shareRate{}, advPrice{}, reqCnt{}", cpcTest, advFactor, advertId, advShareRate, advPrice, reqCnt);
            }

            if (advFactor == null) { advFactor = 1.; }
            if (groupTag >= 2) { advFactor = 1.0; }
            if (cpcTest <= 1) { advFactor = 1.0; }
            if (adAvgPrice == null) {adAvgPrice = 40.;}

            // price = 广告线发券CPC价格 * 分成比例 * 维稳因子
            double price = advPrice * advShareRate * advFactor;

            double ctr = adxDirecetlyPriceDo.getCtr();
            adxDirecetlyPriceDo.setOriPrice(MathUtil.formatDouble(price, 6));
            adxDirecetlyPriceDo.setOriScore(MathUtil.formatDouble(ctr * price, 6));

            Double cvr = adxDirecetlyPriceDo.getCvr();
            if (cvr == null) { cvr = 0.0; }

            Long newTradeId = adxDirecetlyPriceDo.getNewTradeId();
            if (newTradeId == null) {
                newTradeId = -1L;
            }

            /**
             * groupTag=0:原逻辑
             * groupTag=1:取消低出价区间加价
             * groupTag=2:取消低出价区间加价，新加价策略:分层映射调价1(低加高减)，非首张券底价
             * groupTag=3:取消低出价区间加价，按CVR流量分层筛选，分层映射调价(高加)，非首张券底价
             * groupTag=4:取消低出价区间加价，非首张券底价
             */
            if (cpcTest != 1 && groupTag == 0) {
                price = lowPriceAdd(price, priceThreshold, sucFactor, adAvgPrice, advFactor, reqCnt, reqThreshold, advPrice, advShareRate, liftFactor);
            }
            else if (cpcTest != 1 && groupTag == 1) {
                price = cpcAdjustPrice(floorPrice, liftFactor, realFloorPrice, newTradeId, advPrice, advShareRate, advFactor);
            }
            else if (cpcTest != 1 && groupTag == 2) {
                price = getPriceExploreFactor(floorPrice, liftFactor, realFloorPrice, rand, adxDirecetlyPriceDo, advPrice, advShareRate, advFactor);
            }
            else if (cpcTest != 1 && groupTag == 3 && (OperatorAdvertList.contains(advertId) || newTradeId == 16L)) {
                price = doubleAdjustPrice(price, floorPrice, liftFactor, realFloorPrice);
            }
            else if (cpcTest != 1 && groupTag == 4) {
                price = doubleAdjustPrice(price, floorPrice, liftFactor, realFloorPrice);
            }

            adxDirecetlyPriceDo.setRealFloorPrice(realFloorPrice);
            adxDirecetlyPriceDo.setLiftFactor(liftFactor);

            //底价过滤
            if(price < floorPrice) {
                logger.info("MT floorPrice Filter, advertId{}, price{}, cpcTest{}, advPrice{}, reqCnt{}, groupTag{}, tradeId{}", advertId, price, cpcTest, advPrice, reqCnt, groupTag, newTradeId);
                continue;
            }

            adxDirecetlyPriceDo.setAdxPrice(price);
            adxDirecetlyPriceDo.setRoiFactor(advFactor);
            double arpu = MathUtil.formatDouble(ctr * advPrice, 6);
            double score = MathUtil.formatDouble(ctr * price, 6);
            adxDirecetlyPriceDo.setCtr(MathUtil.formatDouble(ctr, 6));
            adxDirecetlyPriceDo.setCvr(MathUtil.formatDouble(cvr, 6));
            adxDirecetlyPriceDo.setArpu(arpu);
            adxDirecetlyPriceDo.setScore(score);
            adxDirecetlyPriceDo.setAdvShareRate(advShareRate);

//            if (Math.random() <= 0.1) {
            logger.info("groupTag{}, level{}, priceFactor{}, liftFactor{}, realFloorPrice{}, rand{}, FactorExploreMap{}, exploreId{}", groupTag, adxDirecetlyPriceDo.getLevel(), adxDirecetlyPriceDo.getPriceFactor(), liftFactor, realFloorPrice, rand, JSONObject.toJSON(adxDirecetlyPriceDo.getFactorExploreMap()), adxDirecetlyPriceDo.getExploreId());
            logger.info("cpcTest{}, reqCnt{}, groupTag{}, advFactor{}, advertId{}, shareRate{}, advPrice{}, ctr{}, price{}, arpu{}, tradeId{}", cpcTest, reqCnt, groupTag, advFactor, advertId, advShareRate, advPrice, ctr, price, arpu, newTradeId);



            ret.add(adxDirecetlyPriceDo);
        }
        List<AdxDirecetlyPriceDo> reRankRet;
        reRankRet = ret.stream().
                sorted(comparing(AdxDirecetlyPriceDo::getRankScore).reversed()).collect(toList());

        advertCnt = Math.min(advertCnt, reRankRet.size());

        if (groupTag >= 1) {
            // 类目多样性策略
            reRankRet = categoryDiversity(reRankRet);
        }

        ret = reRankRet.subList(0, advertCnt);

        if (reqCnt == null) {
            logger.info("reqCnt is null");
        }
//        if (Math.random() <= 0.2) {
        logger.info("groupTag{}, ret{}, liftFactor{}, realFloorPrice{}, reqCnt{}, reRankRet{}", groupTag, JSONObject.toJSONString(ret), liftFactor, realFloorPrice, reqCnt, reRankRet.size());
//        }

        return ret;
    }

    public static double getPriceExploreFactor(double floorPrice, double liftFactor, double realFloorPrice, double rand, AdxDirecetlyPriceDo adxDirecetlyPriceDo, double advPrice, double advShareRate, double advFactor) {

        // liftFactor: 消耗与roi的权重系数
        // realFloorPrice： 真实底价
        double price = advPrice * advShareRate;
        double basePrice = floorPrice + 0.2;
        LinkedHashMap<String, Double> rateMap = new LinkedHashMap<>();

//        double baseRate = Math.max(1.0 - liftFactor, 0.0); // 基准桶流量比例
        double baseRate = 0.0;
        double expRate = 0.2;
        double priceFactor;
        int start = priceExploreLevelEnum.profitLevelStart.getIndex();
        int end = priceExploreLevelEnum.profitLevelEnd.getIndex();
        for (int i=start; i <= end; i++) {
            rateMap.put(i+"", end == i ? baseRate : expRate);
        }

        String level = doubleMap(rateMap, rand);
        if (level == null)
        logger.info("rateMap{}, rand{}", rateMap, rand);

        assert level != null;
        int level1 = Integer.parseInt(level);

        double defaultValue = level.equals(end+"") ? 2.0 : (level1 + 1) * 0.5;
        priceFactor = adxDirecetlyPriceDo.getFactorExploreMap().getOrDefault(level, defaultValue);
        adxDirecetlyPriceDo.setPriceFactor(priceFactor);
        adxDirecetlyPriceDo.setLevel(level1);
        if (adxDirecetlyPriceDo.getLevel() == null) {
            logger.info("rateMap{}, rand{}， level{}, defaultValue{}, priceFactor{}, level1{}", rateMap, rand, level, defaultValue, priceFactor, level1);
        }

        logger.info("level{}, priceFactor{}, liftFactor{}, realFloorPrice{}, rand{}, FactorExploreMap{}, exploreId{}", level1, priceFactor, liftFactor, realFloorPrice, rand, JSONObject.toJSON(adxDirecetlyPriceDo.getFactorExploreMap()), adxDirecetlyPriceDo.getExploreId());

        if (price <= floorPrice && price >= realFloorPrice) {
            return basePrice;
        }

        if (price > basePrice) {
            return Math.max(basePrice, basePrice * priceFactor);
        }
        return price * advFactor;
    }

    public static String doubleMap(Map<String, Double> map, double rand) {

        // 参数检验
        if (AssertUtil.isEmpty(map)) {
            logger.warn("priceExploreExp mapSample param is invalid, params invalid");
            return null;
        }

        double w = 0.0;
        try {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                w += entry.getValue();
                if (rand <= w) {
                    return entry.getKey();
                }
            }
        } catch (Exception e) {
            logger.error("priceExploreExp mapSample happened error: ", e);

        }
        return null;
    }

    public static List<AdxDirecetlyPriceDo> categoryDiversity (List<AdxDirecetlyPriceDo> reRankRet) {
        List<AdxDirecetlyPriceDo> reRankRet1 = new ArrayList<>();
        List<AdxDirecetlyPriceDo> reRankRet2 = new ArrayList<>();
        HashSet<Long> newTradeIdList1 = new HashSet<>();
        for (AdxDirecetlyPriceDo adxDirecetlyPriceDo : reRankRet) {
            Long tradeId = adxDirecetlyPriceDo.getNewTradeId();
            if (!newTradeIdList1.contains(tradeId)) {
                newTradeIdList1.add(tradeId);
                reRankRet1.add(adxDirecetlyPriceDo);
            }
            else {
                reRankRet2.add(adxDirecetlyPriceDo);
            }
        }
        reRankRet1.addAll(reRankRet2);
        if (Math.random() <= 0.05) {
            logger.info("reRankRet1{}, reRankRet2{}", reRankRet1, reRankRet2);
        }
        return reRankRet1;
    }


    public static double lowPriceAdd(double price, double priceThreshold, double sucFactor, double adAvgPrice, double advFactor, Long reqCnt, long reqThreshold, double advPrice, double advShareRate, double liftFactor) {
        /**
         * 原出价逻辑
         */
        if(price <= priceThreshold && sucFactor>0.1) {
            double priceLimit = price * 1.25;
            price = price + (priceThreshold - price) * sucFactor * liftFactor;
            price = Math.min(price, priceLimit);
        }

        adAvgPrice = MathUtil.stdwithBoundary(adAvgPrice,40,80);

        /**
         * 新增出价逻辑，底价区间抢量
         */

        if(price < adAvgPrice) {
            price = price + (adAvgPrice - price) * (advFactor - 0.75) * liftFactor;
        }


        /**
         * 新增出价逻辑,头部流量抢量
         */
        if(reqCnt != null && reqCnt < reqThreshold && price < priceThreshold) {
            price = price + (priceThreshold - price) * (advFactor - 0.75) * liftFactor;
        }

        double minPrice = advPrice * advShareRate * 0.75;
        double maxPrice = Math.max(advPrice * advShareRate * (advShareRate + 0.5), advPrice);
        price = MathUtil.stdwithBoundary(price, minPrice, maxPrice);
        return price;
    }


    public static long getExploreId(Double advPrice, Long newTradeId, Long advertId, Double liftFactor) {

        return newTradeId;

    }

    public static double doubleAdjustPrice(double price, double floorPrice, double liftFactor, double realFloorPrice) {
        /**
         * 分层映射调价1(线性调价)
         * liftFactor: 【1.0， 1.5】
         * realFloorPrice: 【10.0， 30.0】
         */
        if (price > realFloorPrice && price <= 100.0) {
            price = price * liftFactor;
        }
        if (price <= floorPrice && price >= realFloorPrice) {
            price = floorPrice + 0.2;
        }
        return price;
    }

    public static double cpcAdjustPrice(double floorPrice, double liftFactor, double realFloorPrice, long newTradeId, double advPrice, double advShareRate, double advFactor) {
        /**
         * cpc固定出价
         * liftFactor: 选择不同cpc出价策略
         * realFloorPrice: 【10.0， 30.0】低价提价的阈值
         */

        double price = advPrice * advShareRate;
        double basePrice = floorPrice + 0.2;

        if (price <= floorPrice && price >= realFloorPrice) {
            return basePrice;
        }

        if (price > basePrice) {
            int liftCate = (int) liftFactor;
            if (liftCate == 1) {
                price = newTradeMap1.getOrDefault(newTradeId, 32.0);
            }
            else if (liftCate == 2) {
                price = newTradeMap2.getOrDefault(newTradeId, 32.0);
            }
            else if (liftCate >= 3 && liftCate <= 10) {
                price = newTradeMap1.getOrDefault(newTradeId, 32.0) + liftCate - 2;
            }
            else if (liftCate > 10) {
                price = newTradeMap2.getOrDefault(newTradeId, 32.0) + liftCate - 10;
            }

            return Math.max(basePrice, price * advFactor);
        }

        return price * advFactor;
    }

    public static double upperAdjustPrice(double price, double floorPrice, double liftFactor, double realFloorPrice) {
        /**
         * 分层映射调价2(非线性调价)
         * liftFactor: 【1.0， 1.5】
         * realFloorPrice: 【10.0， 30.0】
         */
        if (price >= realFloorPrice && price <= 100.0) {
            price = price * Math.pow(liftFactor, (100.0 - price)/(100.0 - realFloorPrice));
        }
        if (price <= floorPrice && price >= realFloorPrice) {
            price = floorPrice + 0.2;
        }
        return price;
    }

    /**
     * 算法接口2-直投算法出价
     *
     * @param directlyIdeaInfo 直投创意信息
     * @param directlyFactorInfo 直投ROI维稳因子试探表
     * @return
     */
    public static AdxDircetlyPriceDo getAlgoPrice(AdxDirectlyIdeaDo directlyIdeaInfo,
                                                  AdxDirectlyFactorDo directlyFactorInfo) {

        AdxDircetlyPriceDo ret = new AdxDircetlyPriceDo();

        try {

            // 1.设置默认值
            Double roiFactor = 1.0;            // ROI调节因子
            Double lowerLimit = 0.3;           // ROI调节因子下限
            Double upperLimit = 1.7;           // ROI调节因子上限

            Long algoPrice = 0L;
            String strategy = AdxStrategy.ADX_STRATEGY_FIR.getCode();
            String level = AdxLevel.ADX_LEVEL_TWO.getCode();


            // 2.获取统计信息
            Long ideaBidCntMs = 0L;
            if (AssertUtil.isAllNotEmpty(directlyIdeaInfo)) {
                AdxIndexStatsDo interIndexStatMs = AdxStatData.indexStatCompute(directlyIdeaInfo.getIdeaIndexMap());
                ideaBidCntMs = AdxStatData.nullToMinDefault(interIndexStatMs.getBidCnt(),0L);
            }


            // 3.获取level和调节因子
            if (AssertUtil.isNotEmpty(directlyFactorInfo) && ideaBidCntMs != 0L) {

                Map<String, Double> factorMap = directlyFactorInfo.getFactorExploreMap();
                Map<String, Double> FlowRateMap = directlyFactorInfo.getFactorFlowRateMap();
                Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, 1.0);

                level = result.get("level");
                roiFactor = AdxStatData.getNormalValue(DataUtil.string2Double(result.get("factor")), 1.0, lowerLimit, upperLimit);

            }


            // 3.计算出价
            if (AssertUtil.isNotEmpty(directlyIdeaInfo)) {

                Double minRoi = AdxStatData.nullToMinDefault(directlyIdeaInfo.getMinRoi(), 1.0);
                Double cpcPrice = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyCpcPrice(), 0.0);
                Double preCtr = AdxStatData.nullToMinDefault(directlyIdeaInfo.getDirectlyPreCtr(), 0.0);

                // 出价 = 广告计划CPC出价(分) * 直投CTR预估 * 1000 /（设置ROI * ROI调节因子）
                algoPrice = Math.round(Math.floor(DataUtil.division(cpcPrice * preCtr * 1000L, minRoi * roiFactor)));

            }

            ret.setAdxAlgoPrice(algoPrice);
            ret.setStrategy(strategy);
            ret.setLevel(level);


        } catch(Exception e){
            logger.error("AdxDirectlyBidding.getAlgoPrice error:" + e);

        }

        return ret;
    }
}
