package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.CODER2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ChargePvFiltering {

    /**
     * 每pv点券过滤
     *
     * @param flowFilterRequestDo
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(ChargePvFiltering.class);

    public static FlowFilterResultDo getChargePvFiltering(FlowFilterRequestDo flowFilterRequestDo) {

        FlowFilterResultDo ret = new FlowFilterResultDo();

        /**
         *
         * 步骤：
         * 步骤0、预估每PV点券
         * 步骤1、获取统计数据
         * 步骤2、获取历史过滤比例
         * 步骤3、判断流量过滤
         * 步骤4、控制整体放弃比例
         *
         */

        try {

            Integer flowFilterLabel = 0;        //流量过滤标记(0：不过滤；1：过滤)
            Integer filterType = 0;             //算法过滤原因(0-不过滤，1-流量预过滤，2-每pv发券过滤，3-每pv点券过滤)
            boolean isConfident = false;        //统计指标是否置信

            Double preWeight = 0.8;             //每PV点券模型预估权重
            Double flowerLimit = 0.0;           //每PV点券统计值*比例下限
            Double fUpperLimit = 4.0;           //每PV点券统计值*比例上限
            Double defaultValue = 0.01;         //每PV点券默认值


            //0.预估每PV点券
            Double preChargePv = flowFilterRequestDo.getPreChargePv();

            AdxFlowInfoDo flowInfo = flowFilterRequestDo.getFlowInfo();
            if (AssertUtil.isNotEmpty(flowInfo)) {

                //1.获取统计数据
                AdxIndexStatDo ideaMinStats = flowInfo.getIdeaMinStats();
                AdxIndexStatsDo ideaMinComputes = AdxStatData.adxIndexCompute(ideaMinStats);
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaMinComputes.getConfident() && ideaDayComputes.getConfident();


                //2.获取历史过滤比例
                Map<Integer, AdxFilterCntDo> ideafilterDo = flowFilterRequestDo.getIdeafilterCntDo();
                Double minfilterRate = AdxStatData.getFilterRate(ideafilterDo, "20min", 3);
                Double dayfilterRate = AdxStatData.getFilterRate(ideafilterDo, "1day", 3);
                Double filterRate = Math.max(minfilterRate, dayfilterRate);


                //3.判断流量过滤（前提：数据置信）
                Double statChargePv = AdxStatData.nullToDefault(ideaMinComputes.getChargePv(), ideaDayComputes.getChargePv());
                Double conChargePv = AdxStatData.getConValue(preChargePv, statChargePv, preWeight, flowerLimit, fUpperLimit, defaultValue);
                Double ChargePvLimit = AdxStatData.nullToMinDefault(flowFilterRequestDo.getChargePvLimit(), 0.0);

                double random = Math.random();
                if (isConfident) {

                    if (conChargePv < ChargePvLimit * 0.8) {
                        flowFilterLabel = random < 0.99 ? 1 : 0;
                    } else if (conChargePv < ChargePvLimit * 0.9) {
                        flowFilterLabel = random < 0.95 ? 1 : 0;
                    } else if (conChargePv < ChargePvLimit) {
                        flowFilterLabel = random < 0.90 ? 1 : 0;
                    }
                }


                //4.控制整体放弃比例
                double random2 = Math.random();
                if (flowFilterLabel.equals(1)) {

                    if (filterRate > 0.8) {
                        flowFilterLabel = random < 0.2 ? 1 : 0;
                    } else if (filterRate > 0.5) {
                        flowFilterLabel = random2 < 0.5 ? 1 : 0;
                    }
                }

            }

            //算法过滤原因(0-不过滤，1-流量预过滤，2-每pv发券过滤, 3-每pv点券过滤)
            filterType = flowFilterLabel == 1 ? 3 : 0;

            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setFilterType(filterType);


        } catch (Exception e) {
            logger.error("ChargePvFiltering.getChargePvFiltering error " + e);
        }

        return ret;
    }

}
