package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertInfo;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertParams;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertResultDo;
import cn.com.duiba.nezha.alg.alg.vo.NdFilterAppInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

public class NdAdvertSupport {
    private static final Logger logger= LoggerFactory.getLogger(NdAdvertSupportOrigin.class);

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;   // 修正后的bid，用于调权因子制定阶段的辅助排序
        NdAdvertResultDo ndAdvertResult;
    }

    /**
     * 出价降序排
     * @param NdAdvertResultDo
     * @return
     */
    public static Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>() {
        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) { return (int) (r2.rectifyBid- r1.rectifyBid >= 0 ? 1 : -1); }
    };

    /**
     * @description 非定向广告拓量/冷启动策略
     * @param
     * @return
     */
    public static List<NdAdvertResultDo> NDAdvertColdStartAndExpose(NdFilterAppInfo ndFilterAppInfo,
                                                                    NdAdvertParams ndAdvertParams,
                                                                    List<NdAdvertInfo> ndAdvertInfoList) {

        // 拓量/冷启动结果初始化
        List<NdAdvertResultDo> res = new ArrayList<>();
        // 按修正后的bid降序活动队列(rectifyBid=pCtr*rectifyCvr*bid*[f(exposeCnt)])
        Queue<RectifyNdAdvertResInfo> candis = new PriorityQueue<>(iComparator);

        if (AssertUtil.isAnyEmpty(ndAdvertInfoList, ndFilterAppInfo, ndAdvertParams)) {
            return res;
        }

        // 筛选媒体，在小媒体或较差的媒体不做非定向广告的拓量/冷启动
        Long hisAppConvert = ndFilterAppInfo.getHisAppConvert();
        Double hisAppCVR = ndFilterAppInfo.getHisAppCVR();
        Long hisAppConsume = ndFilterAppInfo.getHisAppConsume();
        if (hisAppConvert <= ndAdvertParams.getAppConvertThreshold() || hisAppCVR <= ndAdvertParams.getAppCVRThreshold() || hisAppConsume <= ndAdvertParams.getAppConsumeThreshold()) {
            return res;
        }

        // 将要计算调权因子的广告按降序（curRectifyBid）添加到candis（Queen）中，不用调权因子的直接修正CVR后添加到res.
        for (int i=0; i < ndAdvertInfoList.size(); i++) {
            double curRectifyBid = 0.0;
            Integer exposeConfidenceThreshold;      //辅助判断是否需要做扶持
            Double exposeConsumePercentThreshold;   //辅助判断是否需要做扶持
            Integer exposeConfidenceThreshold2;     //辅助判断是否需要做扶持
            NdAdvertInfo curNdAdvertInfo =  ndAdvertInfoList.get(i);
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();
            Long hisSlotAdvExpose = curNdAdvertInfo.getHisExpose();
            Long hisAdvertExploreConsume = curNdAdvertInfo.getHisAdvertExploreConsume();
            Long hisAdvertConsume = curNdAdvertInfo.getHisAdvertConsume();
            Map<String, Double> AdjustCVRRes = getAdjustCVR(ndAdvertParams, curNdAdvertInfo);
            double adjustWeight = AdjustCVRRes.get("adjustWeight");
            double adjustCvr = AdjustCVRRes.get("adjustCvr");
            String paramType = AdjustCVRRes.get("paramType") == 1.0 ? "firstSet" : "secondSet";   //1.0表示使用的是第一套扶持参数；2.0表示使用的是第二套扶持参数；
            double preCtr = curNdAdvertInfo.getPreCtr();      // 注：本版本中未对CTR进行修正
            Long bid = curNdAdvertInfo.getBid();

            if (paramType.equals("firstSet")) {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThreshold();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThreshold();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThreshold2();
            }else {
                exposeConfidenceThreshold = ndAdvertParams.getExposeConfidenceThresholdSet3();
                exposeConsumePercentThreshold = ndAdvertParams.getExposeConsumePercentThresholdSet2();
                exposeConfidenceThreshold2 = ndAdvertParams.getExposeConfidenceThresholdSet5();
            }

            if (hisSlotAdvExpose <= exposeConfidenceThreshold || hisAdvertExploreConsume <= exposeConsumePercentThreshold * hisAdvertConsume) {    // 需要做扶持
                if (hisSlotAdvExpose <= exposeConfidenceThreshold2) {
                    curRectifyBid = preCtr * adjustCvr * bid * functionOfExpose(hisSlotAdvExpose);
                }else {
                    curRectifyBid = preCtr * adjustCvr * bid;
                }

                rectifyNdAdvertResInfo.ndAdvertResult = fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr);
                rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
                candis.add(rectifyNdAdvertResInfo);     // 放到降序队列中，稍后用于调权因子制定时使用
            }else {     // 不需要做扶持
                res.add(fillData(curNdAdvertInfo, 1.0, 1.0, adjustWeight, preCtr, adjustCvr));
            }
        }

        // 对candis（Queen）中的广告，求取调权因子
        int lengthOfCandis = candis.size();
        List<Double> functionOfRectifyFacList = functionOfRectifyFac(lengthOfCandis);
        for (int idx=0; idx < lengthOfCandis; idx++) {
            double curFactor = functionOfRectifyFacList.get(idx);
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo= candis.poll();
            curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(curFactor);
            res.add(curRectifyNdAdvertResInfo.ndAdvertResult);
        }

        return res;
    }

    /**
     * @description 对非定向广告的CVR进行修正；目的：打压高点击低转化广告
     * @param ndAdvertInfo
     * @return CVR修正因子及修正后的CVR值
     */
    public static Map<String, Double> getAdjustCVR(NdAdvertParams ndAdvertParams, NdAdvertInfo ndAdvertInfo){

        Map<String, Double> res = new HashMap<>();
        if (AssertUtil.isAnyEmpty(ndAdvertParams, ndAdvertInfo)) {
            return null;
        }

        // 获取统计信息
        Double preCvr = ndAdvertInfo.getPreCvr();
        Long hisClick = ndAdvertInfo.getHisClick();
        Long hisConvert = ndAdvertInfo.getHisConvert();
        Double staCvr = Optional.ofNullable(MathUtil.division(hisConvert, hisClick, 6)).orElse(0.0);
        Long advTradeSlotDayClick = ndAdvertInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = ndAdvertInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = ndAdvertInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = ndAdvertInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = ndAdvertInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getClick();
        Long advTradeSlotDayConvert = ndAdvertInfo.getAdvTradeSlotDayStats().getConvert();
        Long advTradeAppDayConvert = ndAdvertInfo.getAdvTradeAppDayStats().getConvert();
        Long advTradeAppTradeDayConvert = ndAdvertInfo.getAdvTradeAppTradeDayStats().getConvert();
        Long advTradeSlotTriDayConvert = ndAdvertInfo.getAdvTradeSlotTriDayStats().getConvert();
        Long advTradeAppTriDayConvert = ndAdvertInfo.getAdvTradeAppTriDayStats().getConvert();
        Long advTradeAppTradeTriDayConvert = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getConvert();

        // 计算各统计维度CVR
        Double advTradeSlotDayCvr = Optional.ofNullable(MathUtil.division(advTradeSlotDayConvert, advTradeSlotDayClick, 6)).orElse(0.0);
        Double advTradeAppDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppDayConvert, advTradeAppDayClick, 6)).orElse(0.0);
        Double advTradeAppTradeDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTradeDayConvert, advTradeAppTradeDayClick, 6)).orElse(0.0);
        Double advTradeSlotTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeSlotTriDayConvert, advTradeSlotTriDayClick, 6)).orElse(0.0);
        Double advTradeAppTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTriDayConvert, advTradeAppTriDayClick, 6)).orElse(0.0);
        Double advTradeAppTradeTriDayCvr = Optional.ofNullable(MathUtil.division(advTradeAppTradeTriDayConvert, advTradeAppTradeTriDayClick, 6)).orElse(0.0);

        List<Long> clickList = Arrays.asList(advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick,
                advTradeAppTriDayClick, advTradeAppTradeTriDayClick);
        List<Double> cvrList = Arrays.asList(advTradeSlotDayCvr, advTradeAppDayCvr, advTradeAppTradeDayCvr, advTradeSlotTriDayCvr,
                advTradeAppTriDayCvr, advTradeAppTradeTriDayCvr);

        // 确认走哪套扶持参数,并求取相应的CVR调整系数
        double adjustWeight = 1.0;
        String paramType = "firstSet";
        if (Collections.max(cvrList) < ndAdvertParams.getMinDimStatsCvrThreshold()) {     // CVR较低行业，需要使用第二套扶持参数
            paramType = "secondSet";
        }else {     // 用第一套扶持参数
            paramType = "firstSet";
        }
        adjustWeight = getAdjustWeight(ndAdvertParams, clickList, cvrList, paramType, hisClick, staCvr);

        // CVR调整策略。各变量与文档中的对应关系：preCvr ==> pcvr；hisClick ==> x；staCvr ==> y1；minDimsStatCvr ==> y2；adjustWeight ==> a
        double adjustCvr = preCvr;
//        if (hisClick >= ndAdvertParams.getSepStageThreshold() && staCvr != 0) {
        if (hisClick >= (paramType.equals("firstSet") ? ndAdvertParams.getSepStageThreshold() : ndAdvertParams.getSepStageThresholdSet2()) && staCvr != 0) {
            // 根据CVR调整系数计算得到调整后的adjustCvr
            adjustCvr = (1 - adjustWeight) * preCvr + adjustWeight * staCvr;
        } else { adjustCvr *= adjustWeight; }

        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        res.put("paramType", (paramType.equals("firstSet") ? 1.0 : 2.0));   //1.0表示使用的是第一套扶持参数；2.0表示使用的是第二套扶持参数；

        return res;
    }

    /**
     * 求取数据充分的最小粒度维度上统计CVR值
     * @param ndAdvertParams
     * @param clickList
     * @param cvrList
     * @param paramType
     * @return minDimsStatCvr
     */
    public static Double getMinDimsStatCvr(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType) {
        Double minDimsStatCvr = 0.0;

        if (clickList.get(clickList.size() -1) <= (paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold())) {
            minDimsStatCvr = cvrList.get(clickList.size() -1);
        }else {
            for (int index=0; index<clickList.size(); index++) {
                if (clickList.get(index) >= (paramType.equals("secondSet") ? ndAdvertParams.getClickConfidenceThresholdSet2() : ndAdvertParams.getClickConfidenceThreshold())) {
                    minDimsStatCvr = cvrList.get(index);
                    break;
                }
            }
        }

        return minDimsStatCvr;
    }

    /**
     * CVR调整系数
     */
    public static Double getAdjustWeight(NdAdvertParams ndAdvertParams, List<Long> clickList, List<Double> cvrList, String paramType, Long hisClick, Double staCvr) {
        double adjustWeight = 1.0;
        double minDimsStatCvr = getMinDimsStatCvr(ndAdvertParams, clickList, cvrList, paramType);
        Integer sepStageThreshold;
        Integer coldStartThreshold1;
        Integer coldStartThreshold2;
        Integer coldStartThreshold3;

        // 根据paramType变量查看取哪套参数
        if (paramType.equals("firstSet")) {
            sepStageThreshold = ndAdvertParams.getSepStageThreshold();
            coldStartThreshold1 = ndAdvertParams.getColdStartThreshold1();
            coldStartThreshold2 = ndAdvertParams.getColdStartThreshold2();
            coldStartThreshold3 = ndAdvertParams.getColdStartThreshold3();
        }else {
            sepStageThreshold = ndAdvertParams.getSepStageThresholdSet2();
            coldStartThreshold1 = ndAdvertParams.getColdStartThresholdSet4();
            coldStartThreshold2 = ndAdvertParams.getColdStartThresholdSet5();
            coldStartThreshold3 = ndAdvertParams.getColdStartThresholdSet6();
        }

        if (hisClick < sepStageThreshold) {             // 冷启阶段
            boolean b = staCvr <= Math.pow(10, -8) || staCvr < 0.4 * minDimsStatCvr;
            if (coldStartThreshold1 <= hisClick && hisClick < coldStartThreshold2) {
                adjustWeight = b ? 0.9 : 1.0;
            }else if (coldStartThreshold2 <= hisClick && hisClick < coldStartThreshold3) {
                if (b) {adjustWeight = 0.8;}else if (staCvr < 0.7 * minDimsStatCvr) {adjustWeight = 0.9;}else {adjustWeight = 1.0;}
            }else if (hisClick >= coldStartThreshold3) {
                if (b) {adjustWeight = 0.7;}else if (staCvr < 0.7 * minDimsStatCvr) {adjustWeight = 0.8;}else {adjustWeight = 1.0;}
            }else { adjustWeight = 1.0; }
        }else{              // 起量阶段
            if (staCvr <= Math.pow(10, -8)) { adjustWeight = 0.1; } else { adjustWeight = 0.3 + 0.4 * Math.min(1, MathUtil.division(hisClick, 2000, 6));}
        }

        return adjustWeight;
    }

    /**
     * 曝光次数加权函数
     */
    public static double functionOfExpose(Long exposeCnt) {
        double res = 1.0;

        if (exposeCnt <= 3000L) {
            double k = -7 * Math.pow(10, -4);
            double b = 1.21;
            res = k * exposeCnt + b;
        }

        return res;
    }

    /**
     * 调权因子加权函数
     */
    public static List<Double> functionOfRectifyFac(int size) {
        List<Double> res = new ArrayList<>();
        double weight = 1.0;
        Map<String, Double> KBMap1 = calculateKAndB(0, (int) (0.1 * size), 1.2, 1.1);
        Map<String, Double> KBMap2 = calculateKAndB((int) (0.1 * size), (int) (0.2 * size), 1.1, 1.0);
        double k1 = KBMap1.get("K");
        double k2 = KBMap2.get("K");
        double b1 = KBMap1.get("B");
        double b2 = KBMap1.get("B");

        for (int i=0; i<size; i++) {
            if (i <= (int) (0.1 * size)) {
                weight = k1 * i + b1;
            }else if((int) (0.1 * size) < i && i <= (int) (0.2 * size)) {
                weight = k2 * i + b2;
            }else { weight = 1.0; }

            weight = Math.round(weight * 1e6) / 1e6;
            res.add(Math.max(weight, 1.0));
        }

        return res;
    }


    /**
     * 调权因子加权函数斜率及偏置的计算
     */
    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        Map<String, Double> res = new HashMap<>();

        double k = MathUtil.division(y1 - y0, x1 - x0, 6);
        double b = y0 - k * x0;
        res.put("K", k);
        res.put("B", b);

        return res;
    }

    /**
     * 封装拓量/冷启动对非定向广告扶持结果数据
     */
    private static NdAdvertResultDo fillData(NdAdvertInfo ndAdvertInfo,
                                             double adjustFactor,
                                             double ctrRectifyFactor,
                                             double cvrRectifyFactor,
                                             double rectifyCtr,
                                             double rectifyCvr) {
        NdAdvertResultDo ndAdvertRes = new NdAdvertResultDo();

        ndAdvertRes.setAdvertId(ndAdvertInfo.getAdvertId());
        ndAdvertRes.setPlanId(ndAdvertInfo.getPlanId());
        ndAdvertRes.setSlotId(ndAdvertInfo.getSlotId());
        ndAdvertRes.setAppId(ndAdvertInfo.getAppId());
        ndAdvertRes.setAdvertType(ndAdvertInfo.getAdvertType());
        ndAdvertRes.setAdjustFactor(adjustFactor);
        ndAdvertRes.setCtrRectifyFactor(ctrRectifyFactor);
        ndAdvertRes.setCvrRectifyFactor(cvrRectifyFactor);
        ndAdvertRes.setRectifyCtr(rectifyCtr);
        ndAdvertRes.setRectifyCvr(rectifyCvr);

        return ndAdvertRes;
    }


}
