/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.base.BaseAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.HeatAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.HeatRedisDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.HeatRequest;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums;
import cn.com.duiba.nezha.alg.api.facade.recall.AbstractRecallChanelFacade;
import cn.com.duiba.nezha.alg.api.facade.recall.channel.HeatRecallChannelFacade;
import cn.com.duiba.nezha.alg.api.facade.recall.channel.IndustryGeneralRecallChannelFacadeImpl;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.bag.HashBag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatRecallChannelFacadeImpl
extends AbstractRecallChanelFacade<HeatAdvertDTO, HeatRequest>
implements HeatRecallChannelFacade {
    private static final Logger log = LoggerFactory.getLogger(HeatRecallChannelFacadeImpl.class);
    static Logger logger = LoggerFactory.getLogger(IndustryGeneralRecallChannelFacadeImpl.class);

    public RecallEnums.RecallChannelType getType() {
        return RecallEnums.RecallChannelType.Heat;
    }

    @Override
    public Map<String, RecallChannelResult> execute(Map<String, HeatAdvertDTO> heatAdvertDTOMap, HeatRequest heatRequest) {
        HashMap<String, RecallChannelResult> res = new HashMap<String, RecallChannelResult>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{heatAdvertDTOMap, heatRequest})) {
            return res;
        }
        Map heatRecallInitRes = heatRequest.getRedisMap();
        Map nums = heatRequest.getNum();
        Map threshold = heatRequest.getThreshold();
        Set advertIds = heatAdvertDTOMap.values().stream().map(BaseAdvertDTO::getAdvertId).collect(Collectors.toSet());
        Map adOrientMap = heatAdvertDTOMap.values().stream().collect(Collectors.groupingBy(BaseAdvertDTO::getAdvertId, Collectors.mapping(BaseAdvertDTO::getPackageId, Collectors.toList())));
        HashMap helperMap = new HashMap();
        for (Map.Entry entry : heatRecallInitRes.entrySet()) {
            String key = (String)entry.getKey();
            String curIndex = key.split("_")[2];
            List curHeatRedisDTOList = (List)entry.getValue();
            if (!AssertUtil.isNotEmpty((Collection)curHeatRedisDTOList)) continue;
            List retained = curHeatRedisDTOList.stream().filter(pkg -> pkg != null && advertIds.contains(pkg.getAdvertId())).collect(Collectors.toList());
            for (HeatRedisDTO ig : retained) {
                HashMap<Long, Map<String, Double>> curAdRes = new HashMap<Long, Map<String, Double>>();
                Map<String, Double> curInnerRes = this.getInnerVal(ig, curIndex, key);
                Long CurAdId = ig.getAdvertId();
                curAdRes.put(CurAdId, curInnerRes);
                if (helperMap.containsKey(curIndex)) {
                    if (((Map)helperMap.get(curIndex)).containsKey(CurAdId)) {
                        ((Map)((Map)helperMap.get(curIndex)).get(CurAdId)).putAll(curInnerRes);
                        continue;
                    }
                    ((Map)helperMap.get(curIndex)).putAll(curAdRes);
                    continue;
                }
                helperMap.put(curIndex, curAdRes);
            }
        }
        for (Map.Entry entry : helperMap.entrySet()) {
            ArrayList<RecallChannelResult> curIndexRecallResList = new ArrayList<RecallChannelResult>();
            String index = (String)entry.getKey();
            Map advertRecallResMap = (Map)entry.getValue();
            for (Map.Entry entry1 : advertRecallResMap.entrySet()) {
                RecallChannelResult curRecallRes = new RecallChannelResult();
                Long advertId = (Long)entry1.getKey();
                Map advertBeRecalledRes = (Map)entry1.getValue();
                Double threeDays = this.getCurDimsScore(advertBeRecalledRes, index, "3day", "global", heatRequest.getSlotId().toString());
                Double oneDays = this.getCurDimsScore(advertBeRecalledRes, index, "1day", "global", heatRequest.getSlotId().toString());
                Double oneHour = this.getCurDimsScore(advertBeRecalledRes, index, "1hour", "global", heatRequest.getSlotId().toString());
                Double[] scoreList = new Double[]{oneHour, oneDays, threeDays};
                Double finalScore = this.getFinalScore(Arrays.asList(scoreList));
                curRecallRes.setAdvertId(advertId);
                curRecallRes.setScore(finalScore);
                curIndexRecallResList.add(curRecallRes);
            }
            List innerTmpRes = curIndexRecallResList.stream().filter(curIndexRecallRes -> curIndexRecallRes.getScore() > (Double)threshold.get(index)).sorted(Comparator.comparing(RecallChannelResult::getScore).reversed()).limit(((Integer)nums.get(index)).intValue()).collect(Collectors.toList());
            for (RecallChannelResult rcr : innerTmpRes) {
                RecallChannelResult finalOneRecallRes = new RecallChannelResult();
                List orientList = adOrientMap.get(rcr.getAdvertId());
                for (Long orient : orientList) {
                    finalOneRecallRes.setAdvertId(rcr.getAdvertId());
                    finalOneRecallRes.setPackageId(orient);
                    finalOneRecallRes.setScore(rcr.getScore());
                    finalOneRecallRes.setIndex(index);
                    res.put(finalOneRecallRes.buildKey(), finalOneRecallRes);
                }
            }
        }
        return res;
    }

    private Map<String, Double> getInnerVal(HeatRedisDTO heatRedisDTO, String type, String key) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{heatRedisDTO, type, key})) {
            return res;
        }
        if ("ctr".equals(type)) {
            res.put(key, heatRedisDTO.getCtrScore());
        } else if ("cvr0".equals(type)) {
            res.put(key, heatRedisDTO.getCvrScore0());
        } else if ("cvr1".equals(type)) {
            res.put(key, heatRedisDTO.getCvrScore1());
        } else if ("dCvr".equals(type)) {
            res.put(key, heatRedisDTO.getDCvrScore());
        } else if ("consume".equals(type)) {
            res.put(key, heatRedisDTO.getConsumeScore());
        } else if ("weight0".equals(type)) {
            res.put(key, heatRedisDTO.getWeightScore0());
        } else if ("weight1".equals(type)) {
            res.put(key, heatRedisDTO.getWeightScore1());
        } else {
            logger.info("Wrong input type. Please enter type in array('ctr', 'cvr0', 'cvr1', 'dCvr', 'consume', 'weight0', 'weight1')");
            System.out.println("Wrong input type. Please enter type in array('ctr', 'cvr0', 'cvr1', 'dCvr', 'consume', 'weight0', 'weight1')");
        }
        return res;
    }

    private List<String> getKey(String index, List<String> timeDims, List<String> dataDims) {
        ArrayList<String> res = new ArrayList<String>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{index, timeDims, dataDims})) {
            return res;
        }
        for (String time : timeDims) {
            dataDims.forEach(data -> res.add(Joiner.on((String)"_").join((Object)"NZ_A1", (Object)index, new Object[]{"advert", time, data})));
        }
        return res;
    }

    private String getKey(String index, String timeDim, String dataDim) {
        return AssertUtil.isAnyEmpty((Object[])new Object[]{index, timeDim, dataDim}) ? null : Joiner.on((String)"_").join((Object)"NZ_A1", (Object)index, new Object[]{"advert", timeDim, dataDim});
    }

    private Double getCurDimsScore(Map<String, Double> advertBeRecalledRes, String index, String timeDim, String global, String slot) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertBeRecalledRes, index, timeDim, global, slot})) {
            return 0.0;
        }
        String globalKey = this.getKey(index, timeDim, global);
        String slotKey = this.getKey(index, timeDim, slot);
        if (advertBeRecalledRes.containsKey(slotKey)) {
            return advertBeRecalledRes.getOrDefault(slotKey, 0.0);
        }
        return advertBeRecalledRes.getOrDefault(globalKey, 0.0);
    }

    private Double getFinalScore(List<Double> scoreList) {
        HashBag bag = new HashBag(scoreList);
        int nonZero = scoreList.size() - bag.getCount((Object)0.0);
        return nonZero != 0 ? (Constance.weight1Hour * scoreList.get(0) + Constance.weight1Day * scoreList.get(1) + Constance.weight3Day * scoreList.get(2)) / (double)nonZero : 0.0;
    }

    private static class Constance {
        private static final String prefix = "NZ_A1";
        static Double weight3Day = 0.96;
        static Double weight1Day = 0.98;
        static Double weight1Hour = 1.0;

        private Constance() {
        }
    }
}

