package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.MaterialExtractDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.material.RerankMaterial;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.MaterialFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeature;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.UserMaterialFeature;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;

import java.util.*;
import java.util.stream.Collectors;

public class MaterialRcmder {


    public static MaterialRcmdDo forkFeatureParse(MaterialFeatureDo materialFeatureDo) {
        List<Long> idList = new ArrayList<>(materialFeatureDo.getMaterialFeatureMap().keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }

        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        // 旧版算法对应type为1
        materialRcmdDo.setType(1);
        // 获取素材id对应的特征，构建推荐结果对象
        Map<String, String> featureMap = new HashMap<>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo));
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    /**
     * 排序
     *
     * @param model
     * @param materialExtractDo 召回模块输出结果
     * @param materialFeatureDo
     * @return
     * @throws Exception
     */
    public static MaterialRcmdDo rcmd(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {

        MaterialRcmdDo ret = null;
//        ret = randomStrategy(materialExtractDo, materialFeatureDo);
        ret = rank(model, materialExtractDo, materialFeatureDo);
        return ret;
    }

    private static MaterialRcmdDo randomStrategy(MaterialExtractDo materialExtractDo,
                                                 MaterialFeatureDo materialFeatureDo) {
        List<MaterialMatchDo> materialMatchDoList = materialExtractDo.getMaterialMatchDoList();
        if (materialMatchDoList.size() < 1) {
            return null;
        }
        Collections.shuffle(materialMatchDoList);
        MaterialMatchDo materialMatchDo = materialMatchDoList.get(0);
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = materialMatchDo.getMaterialId();
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        // 随机策略对应type为0
        materialRcmdDo.setType(0);
        // 获取素材id对应的特征，构建推荐结果对象
        Map<String, String> featureMap = new HashMap<>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo));
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }


    public static MaterialRcmdDo rank(FM model,
                                      MaterialExtractDo materialExtractDo,
                                      MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;


        if (AssertUtil.isAnyEmpty(materialExtractDo, materialFeatureDo)) {
            return ret;
        }
        Map<Long, FeatureMapDo> featureDoMap = new HashMap<>();
        //1 合并多路召回数据
        Set<Long> recallMaterialSet = mergeMultiRecallStrategy(materialExtractDo);

        //2 静态特征解析
        Map<String, String> staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic(materialFeatureDo);

        //3 解析：动态特征
        for (Long materialId : recallMaterialSet) {

            Map<String, String> dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic(materialFeatureDo, materialFeatureDo, materialId);
//            dynamicFeatureMap.putAll(staticFeatureMap);

            // 封装特征
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);

        }

        //4 模型预估
        Map<Long, Double> preCTR = new HashMap<>();
        preCTR = model.predictsNew(featureDoMap);

        //5 重排策略；包括曝光降权及前序点击的加权
        RerankMaterial rerankMaterial = reRank(preCTR, materialFeatureDo);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        ret.setMaterialId(reRankId);
        FeatureMapDo featureMapDo = featureDoMap.get(reRankId);
        Map<String, String> resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
//        ret.setReRankScore(rerankMaterial.getReRankScore());
        return ret;
    }

    /**
     * @description merge多路召回结果
     * @return 返回值说明
     * @date 2020/7/24
     */
    private static Set<Long> mergeMultiRecallStrategy(MaterialExtractDo materialExtractDo) {
        Set<Long> recallMaterialSet = new HashSet<>();
        materialExtractDo.getMaterialMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        materialExtractDo.getMaterialCostMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        return recallMaterialSet;
    }

    private static RerankMaterial reRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map<Long, UserMaterialFeature> userMaterialFeatureMap = materialFeatureDo.getUserMaterialFeatureMap();
        double upWeight = 0.1;
        double maxScore = -1;
        double rawScore = -1;
        Long resultId = 0L;
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            if (userMaterialFeatureMap.containsKey(materialId)) {
                UserMaterialFeature userMaterialFeature = userMaterialFeatureMap.get(materialId);
                Long exposeCnt = userMaterialFeature.getUExposeDayCnt();
                // 屏蔽跨天点击加权操作
//                Long uClickWeekCnt = userMaterialFeature.getUClickWeekCnt();
//                if (null != uClickWeekCnt && uClickWeekCnt > 0) {
//                    score += upWeight;
//                }
                // 曝光降权
                if (null != exposeCnt) {
                    score = score / (1 + exposeCnt);
                }

            }
            if (score > maxScore) {
                maxScore = score;
                resultId = materialId;
                rawScore = tmpScore;
            }
        }
        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        return rerankMaterial;
    }
}