package cn.com.duiba.nezha.alg.alg.vo.adx.pd;

import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

import java.util.Optional;

import static cn.com.duiba.nezha.alg.alg.adx.AdxStatData.getAdxTimeIndex;
import static cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdAlg.*;


/**
 * adx统计数据（时间维度）
 */
@Data
public class AdxStatsDo {

    /**
     * 近20分钟统计数据
     */
    private AdxIndexStatDo last20MinStat;

    /**
     * 近1小时统计数据
     */
    private AdxIndexStatDo last1HourStat;

    /**
     * 近1天统计数据
     */
    private AdxIndexStatDo last1DayStat;

    /**
     * 近3天统计数据
     */
    private AdxIndexStatDo last3DayStat;

    /**
     * 历史7天统计数据
     */
    private AdxIndexStatDo last7DayStat;

    /**
     * 计算创意维度历史平均CPM--融合实时和全天累计值
     * @param ideaStats
     * @return
     */
    public static Long getMergeAvgPrice(AdxStatsDo ideaStats) {
        Long ret = 200L;

        if(ideaStats != null) {

            //创意维度CPM均值
            AdxIndexStatsDo adxIndexStatsDoDay = getAdxTimeIndex(ideaStats, "1day");
            AdxIndexStatsDo adxIndexStatsDoDayMin = getAdxTimeIndex(ideaStats, "20min");

            Long price1 = getAvgPrice(adxIndexStatsDoDay);
            Long price2 = getAvgPrice(adxIndexStatsDoDayMin);

            if(price1 == null) {
                ret = price2;
            }else if(price2 == null) {
                ret = price1;
            }else{
                ret = (long) (0.2 * price1 + 0.8 * price2);
            }
        }
        if(ret == null) {ret = 400L;}

        ret = (long)MathUtil.stdwithBoundary(ret, 400, 800);

        return ret;
    }

    public static Long getAvgPrice(AdxIndexStatsDo adxIndexStatsDo) {
        Long ret = null;
        if(adxIndexStatsDo != null && adxIndexStatsDo.getExpCnt() != null && adxIndexStatsDo.getExpCnt() > 100) {
            ret = MathUtil.division(adxIndexStatsDo.getAdxConsume() * 1000, adxIndexStatsDo.getExpCnt());
        }
        return ret;
    }

    /**
     * 计算融合统计广告ecpm(广告消耗/adx曝光*1000)
     */
    public static Double mergeStatAdEcpm(AdxStatsDo adxStatsDo, long limit, int mergeType) {

        adxStatsDo = Optional.ofNullable(adxStatsDo).orElse(new AdxStatsDo());
        AdxIndexStatDo last1HourStat = adxStatsDo.getLast1HourStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last3DayStat = adxStatsDo.getLast3DayStat();
        AdxIndexStatDo last7DayStat = adxStatsDo.getLast7DayStat();

        double mergeExpCnt = 0, mergeAdCost = 0;
        if (mergeType == 1) {

            //创意召回任务：近1d/近3d/近7d
            double r1 = 0.5, r2 = 0.3, r3 = 0.2;
            mergeExpCnt = r1 * AdxIndexStatDo.getExpCnt(last1DayStat)
                    + r2 * AdxIndexStatDo.getExpCnt(last3DayStat)
                    + r3 * AdxIndexStatDo.getExpCnt(last7DayStat);
            mergeAdCost = r1 * AdxIndexStatDo.getAdCost(last1DayStat)
                    + r2 * AdxIndexStatDo.getAdCost(last3DayStat)
                    + r3 * AdxIndexStatDo.getAdCost(last7DayStat);

        } else if (mergeType == 2) {

            //<计划，创意>召回任务：近1h/近1d/近3d
            double r1 = 0.2, r2 = 0.5, r3 = 0.3;
            mergeExpCnt = r1 * AdxIndexStatDo.getExpCnt(last1HourStat)
                    + r2 * AdxIndexStatDo.getExpCnt(last1DayStat)
                    + r3 * AdxIndexStatDo.getExpCnt(last3DayStat);
            mergeAdCost = r1 * AdxIndexStatDo.getAdCost(last1HourStat)
                    + r2 * AdxIndexStatDo.getAdCost(last1DayStat)
                    + r3 * AdxIndexStatDo.getAdCost(last3DayStat);

        }

        //置信阈值：曝光量级limit，广告ecpm = 10分/次 * 1000次，倾向低曝光的创意
        Double ret = DataUtil.division((mergeAdCost + limit * 10) * 1000, mergeExpCnt + limit, 3);
        return ret;
    }


    /**
     * 计算竞价次数
     * @return
     */
    public static Long getBidCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getBidCnt(statDo);
        }
        return ret;
    }


    /**
     * 计算竞价成功次数
     * @return
     */
    public static Long getBidSucCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getBidSucCnt(statDo);
        }
        return ret;
    }


    /**
     * 计算曝光次数
     * @return
     */
    public static Long getExpCnt(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getExpCnt(statDo);
        }

        return ret;
    }

    /**
     * 计算广告消耗/分
     * @return
     */
    public static Long getAdCost(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getAdCost(statDo);
        }
        return ret;
    }


    /**
     * 计算adx消耗/分
     * @return
     */
    public static Long getAdxCost(AdxStatsDo adxStatsDo, int timeType) {
        Long ret = 0L;

        if(adxStatsDo != null ) {

            AdxIndexStatDo statDo = new AdxIndexStatDo();

            if (timeType == LAST_20_MIN) {
                statDo = adxStatsDo.getLast20MinStat();
            } else if (timeType == LAST_1_HOUR) {
                statDo = adxStatsDo.getLast1HourStat();
            } else if (timeType == LAST_1_DAY) {
                statDo = adxStatsDo.getLast1DayStat();
            } else if (timeType == LAST_3_DAY) {
                statDo = adxStatsDo.getLast3DayStat();
            } else if (timeType == LAST_7_DAY) {
                statDo = adxStatsDo.getLast7DayStat();
            }

            ret = AdxIndexStatDo.getAdxCost(statDo);
        }
        return ret;
    }


    public AdxIndexStatDo getLast20MinStat() {
        return last20MinStat;
    }

    public void setLast20MinStat(AdxIndexStatDo last20MinStat) {
        this.last20MinStat = last20MinStat;
    }

    public AdxIndexStatDo getLast1HourStat() {
        return last1HourStat;
    }

    public void setLast1HourStat(AdxIndexStatDo last1HourStat) {
        this.last1HourStat = last1HourStat;
    }

    public AdxIndexStatDo getLast1DayStat() {
        return last1DayStat;
    }

    public void setLast1DayStat(AdxIndexStatDo last1DayStat) {
        this.last1DayStat = last1DayStat;
    }
}
