/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdBase;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.priceExploreLevelEnum;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxAppReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidReq;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxBidRet;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.ColdStartFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxBid {
    private static final Logger logger = LoggerFactory.getLogger(AdxBid.class);

    public static AdxBidRet bid(AdxBidReq adxBidReq) {
        AdxBidRet ret = new AdxBidRet();
        try {
            Integer groupTag;
            if (!AdxBid.valid(adxBidReq) || adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2) {
                AdxBid.printBidReq(adxBidReq);
            }
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();
            AdxFactorBaseDo factorBaseDo = Optional.ofNullable(adxBidReq.getAdxFactorBaseDo()).orElse(new AdxFactorBaseDo());
            double factor = factorBaseDo.getFactor();
            Double cpm = factorBaseDo.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(327.0);
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = Optional.ofNullable(adxBidReq.getStatCtr()).orElse(factorBaseDo.getStatCtr());
            Double ctr = MathUtil.mean((Double)preCtr, (Double)statCtr, (Double)0.9);
            ctr = Optional.ofNullable(ctr).orElse(0.0269);
            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = Optional.ofNullable(adxBidReq.getStatLaunchPv()).orElse(factorBaseDo.getLaunchPv());
            Double launchPv = MathUtil.mean((Double)preLaunchPv, (Double)statLaunchPv, (Double)0.7);
            launchPv = Optional.ofNullable(launchPv).orElse(1.025);
            Double preArpu = adxBidReq.getPreArpu();
            Double arpu = Optional.ofNullable(adxBidReq.getStatArpu()).orElse(factorBaseDo.getArpu());
            Double mixArpu = MathUtil.mean((Double)preArpu, (Double)arpu, (Double)0.7);
            mixArpu = Optional.ofNullable(mixArpu).orElse(17.9);
            arpu = Optional.ofNullable(arpu).orElse(17.9);
            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division((Double)adxBidReq.getRoi(), (Long)100L, (int)3);
            Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
            boolean expSwitch = adxBidReq.getAdxExploreDo().isExpSwitch();
            if (expTag == null) {
                expTag = 99;
            }
            if (expTag >= 2 && !expSwitch) {
                AdxBid.getPriceExploreFactor(adxBidReq, ret);
            }
            if ((groupTag = adxBidReq.getGroupTag()) == null) {
                groupTag = 0;
            }
            Double price = pmpType != null && pmpType == 2 ? adxBidReq.getPrice() : (priceType == 1 ? (bidMode == 1 ? AdxBid.getRoiPrice(ctr, factor, launchPv, arpu, mixArpu, roi, expTag, ret.getPriceFactor(), expSwitch, groupTag) : AdxBid.getCpcPrice(ctr, cpc, factor, expTag, ret.getPriceFactor(), expSwitch)) : (priceType == 2 ? AdxBid.getDirectPrice(ctr, cpc, factor, roi, expTag, ret.getPriceFactor(), expSwitch) : adxBidReq.getPrice()));
            if (expTag >= 1 && Math.random() <= 0.005) {
                logger.info("priceExploreExpTag{} ,level{}, price{}, appId{}, slotId{}, priceType{}, bidMode{}", new Object[]{expTag, ret.getLevel(), price, adxBidReq.getAppId(), adxBidReq.getSlotId(), priceType, bidMode});
            }
            price = Math.min(price, 50.0 * cpm);
            Double rankScore = AdxBid.getRankScore(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());
            ret.setAdxAlgoPrice(Math.round(price));
            ret.setArpu(arpu);
            ret.setMixArpu(mixArpu);
            ret.setPreArpu(preArpu);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setFactor(factor);
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setRankScore(rankScore);
        }
        catch (Exception e) {
            logger.error("AdxBid.bid error", (Throwable)e);
        }
        return ret;
    }

    public static AdxBidRet getBid(AdxBidReq adxBidReq) {
        AdxBidRet ret = new AdxBidRet();
        try {
            Double statArpu;
            if (!AdxBid.valid(adxBidReq) || adxBidReq.getPriceType() != null && adxBidReq.getPriceType() == 2) {
                AdxBid.printBidReq(adxBidReq);
            }
            Integer bidMode = adxBidReq.getBidMode();
            int priceType = Optional.ofNullable(adxBidReq.getPriceType()).orElse(1);
            Integer pmpType = adxBidReq.getPmpType();
            Integer groupTag = adxBidReq.getGroupTag();
            double factor = adxBidReq.getFactor();
            Double preCtr = adxBidReq.getPreCtr();
            Double statCtr = adxBidReq.getStatCtr();
            Double ctr = MathUtil.mean((Double)preCtr, (Double)statCtr, (Double)0.9);
            ctr = Optional.ofNullable(ctr).orElse(0.0269);
            Double preLaunchPv = adxBidReq.getPreLaunchPv();
            Double statLaunchPv = adxBidReq.getStatLaunchPv();
            Double launchPv = MathUtil.mean((Double)preLaunchPv, (Double)statLaunchPv, (Double)0.7);
            launchPv = Optional.ofNullable(launchPv).orElse(1.025);
            Double preArpu = adxBidReq.getPreArpu();
            Double arpu = statArpu = adxBidReq.getStatArpu();
            if (groupTag == null) {
                groupTag = 0;
            }
            if (groupTag == 1) {
                arpu = MathUtil.mean((Double)preArpu, (Double)statArpu, (Double)0.7);
            }
            arpu = Optional.ofNullable(arpu).orElse(17.9);
            Double cpc = priceType == 1 ? adxBidReq.getCpc() : adxBidReq.getDirectCpc();
            Double roi = MathUtil.division((Double)adxBidReq.getRoi(), (Long)100L, (int)3);
            Double price = pmpType != null && pmpType == 2 ? adxBidReq.getPrice() : (priceType == 1 ? (bidMode == 1 ? AdxBid.getRoiPrice(ctr, launchPv, arpu, roi, factor) : AdxBid.getCpcPrice(ctr, cpc, factor)) : (priceType == 2 ? AdxBid.getDirectPrice(ctr, cpc, roi, factor) : adxBidReq.getPrice()));
            Double cpm = adxBidReq.getCpm();
            cpm = Optional.ofNullable(cpm).orElse(327.0);
            price = Math.min(price, 50.0 * cpm);
            Double rankScore = AdxBid.getRankScore2(price, adxBidReq.getStatEcpm(), adxBidReq.isConfidence());
            ret.setAdxAlgoPrice(Math.round(price));
            ret.setRankScore(rankScore);
            ret.setCtr(ctr);
            ret.setPreCtr(preCtr);
            ret.setStatCtr(statCtr);
            ret.setLaunchPv(launchPv);
            ret.setPreLaunchPv(preLaunchPv);
            ret.setStatLaunchPv(statLaunchPv);
            ret.setMixArpu(arpu);
            ret.setArpu(statArpu);
            ret.setPreArpu(preArpu);
            ret.setFactor(factor);
            ret.setExploreType(adxBidReq.getExploreType());
            ret.setBasePrice(adxBidReq.getBasePrice());
            ret.setIdeaId(adxBidReq.getIdeaId());
            ret.setIdeaUnitId(adxBidReq.getIdeaUnitId());
            ret.setIsNew(adxBidReq.getIsNew());
            ret.setIsColdStart(adxBidReq.getIsColdStart());
        }
        catch (Exception e) {
            logger.error("AdxBid.bid error", (Throwable)e);
        }
        return ret;
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorBaseDo factorBaseDo, AdxAppReqDo adxAppReqDo) {
        ArrayList<AdxBidReq> adxBidReqs = new ArrayList<AdxBidReq>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();
        for (IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            adxBidReq.setAdxFactorBaseDo(factorBaseDo);
            BeanUtils.copy((Object)adxAppReqDo, (Object)adxBidReq);
            BeanUtils.copy((Object)adIdeaDo, (Object)adxBidReq);
            BeanUtils.copy((Object)ideaUnitDo, (Object)adxBidReq);
            if (adxAppReqDo != null && adxAppReqDo.getPmpType() != null) {
                adxBidReq.setPmpType(adxAppReqDo.getPmpType());
                if (adxAppReqDo.getPmpType() != 0) {
                    adxBidReq.setPrice(DataUtil.toDouble((Long)adxAppReqDo.getPmpPrice()));
                }
            }
            if (ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo adxStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo adxIndexStatDo = adxStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxIndexStatDo.getStatCtr(adxIndexStatDo));
                adxBidReq.setStatLaunchPv(AdxIndexStatDo.getStatLaunchPv(adxIndexStatDo));
                adxBidReq.setStatArpu(AdxIndexStatDo.getStatArpu(adxIndexStatDo));
                adxBidReq.setStatEcpm(AdxIndexStatDo.getStatEcpm(adxIndexStatDo));
                adxBidReq.setConfidence(AdxIndexStatDo.isCostConfidence(adxIndexStatDo));
            }
            adxBidReqs.add(adxBidReq);
        }
        return adxBidReqs;
    }

    public static List<AdxBidReq> buildAdxBidReq(AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo, AdxAppReqDo adxAppReqDo) {
        ArrayList<AdxBidReq> adxBidReqs = new ArrayList<AdxBidReq>();
        List<IdeaUnitDo> ideaUnitDos = adIdeaDo.getIdeaUnitDos();
        AdxBidReq tmpBidReq = new AdxBidReq();
        AdxBid.getFactorDo(tmpBidReq, adIdeaDo, adxFactorDo, adxAppReqDo);
        for (IdeaUnitDo ideaUnitDo : ideaUnitDos) {
            AdxBidReq adxBidReq = new AdxBidReq();
            BeanUtils.copy((Object)tmpBidReq, (Object)adxBidReq);
            adxBidReq.setIdeaUnitId(ideaUnitDo.getIdeaUnitId());
            adxBidReq.setIsNew(ideaUnitDo.getIsNew());
            adxBidReq.setPreCtr(ideaUnitDo.getPreCtr());
            adxBidReq.setPreLaunchPv(ideaUnitDo.getPreLaunchPv());
            adxBidReq.setPreArpu(ideaUnitDo.getPreArpu());
            if (adxAppReqDo != null && adxAppReqDo.getPmpType() != null) {
                adxBidReq.setPmpType(adxAppReqDo.getPmpType());
                if (adxAppReqDo.getPmpType() != 0) {
                    adxBidReq.setPrice(DataUtil.toDouble((Long)adxAppReqDo.getPmpPrice()));
                }
            }
            if (ideaUnitDo.getAdxStatsDo() != null) {
                AdxStatsDo ideaUnitStatsDo = ideaUnitDo.getAdxStatsDo();
                AdxIndexStatDo indexStatDo = ideaUnitStatsDo.getLast1DayStat();
                adxBidReq.setStatCtr(AdxRcmdBase.getStatCtr(indexStatDo, tmpBidReq.getStatCtr()));
                adxBidReq.setStatLaunchPv(AdxRcmdBase.getStatPvLaunch(indexStatDo, tmpBidReq.getStatLaunchPv()));
                adxBidReq.setStatArpu(AdxRcmdBase.getStatArpu(indexStatDo, tmpBidReq.getStatArpu()));
                adxBidReq.setStatEcpm(AdxRcmdBase.getStatEcpm(indexStatDo, tmpBidReq.getStatEcpm()));
                adxBidReq.setConfidence(AdxRcmdBase.isConfident(indexStatDo));
            }
            adxBidReqs.add(adxBidReq);
        }
        return adxBidReqs;
    }

    public static void getFactorDo(AdxBidReq ret, AdIdeaDo adIdeaDo, AdxFactorDo adxFactorDo, AdxAppReqDo adxAppReqDo) {
        double factor = 1.0;
        Integer exploreType = 1;
        AdxFactorBaseDo adFactorBaseDo = Optional.ofNullable(adxFactorDo.getAdFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo tradeFactorBaseDo = Optional.ofNullable(adxFactorDo.getTradeFactorBaseDo()).orElse(new AdxFactorBaseDo());
        AdxFactorBaseDo appFactorBaseDo = Optional.ofNullable(adxFactorDo.getAppFactorBaseDo()).orElse(new AdxFactorBaseDo());
        factor = adFactorBaseDo.getFactor();
        if (appFactorBaseDo.conf) {
            factor = appFactorBaseDo.getFactor();
        } else if (tradeFactorBaseDo.conf) {
            factor = tradeFactorBaseDo.getFactor();
        }
        SlotFactorDo slotFactorDo = Optional.ofNullable(adxFactorDo.getSlotFactorDo()).orElse(new SlotFactorDo());
        boolean isSlotExplore = slotFactorDo.isExplore();
        double flowRatio = slotFactorDo.getFlowRatio();
        double slotFactor = slotFactorDo.getFactor();
        Boolean isColdStart = adIdeaDo.getIsColdStart();
        ColdStartFactorDo coldStartFactorDo = Optional.ofNullable(adxFactorDo.getColdStartFactorDo()).orElse(new ColdStartFactorDo());
        boolean isAdColdExplore = coldStartFactorDo.isExplore();
        double adColdFactor = coldStartFactorDo.getFactor();
        double random = Math.random();
        if (isSlotExplore && random < flowRatio) {
            factor = Math.max(slotFactor, factor);
            exploreType = 2;
        } else if (isColdStart != null && isColdStart.booleanValue() && isAdColdExplore) {
            factor = Math.max(adColdFactor, factor);
            exploreType = 3;
        }
        ret.setStatCtr(adFactorBaseDo.getStatCtr());
        ret.setStatLaunchPv(adFactorBaseDo.getLaunchPv());
        ret.setStatArpu(adFactorBaseDo.getArpu());
        ret.setStatEcpm(adFactorBaseDo.getStatEcpm());
        ret.setCpm(adFactorBaseDo.getCpm());
        if (appFactorBaseDo.dataConf) {
            ret.setStatCtr(appFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(appFactorBaseDo.getLaunchPv());
            ret.setStatArpu(appFactorBaseDo.getArpu());
            ret.setStatEcpm(appFactorBaseDo.getStatEcpm());
            ret.setCpm(appFactorBaseDo.getCpm());
        } else if (tradeFactorBaseDo.dataConf) {
            ret.setStatCtr(tradeFactorBaseDo.getStatCtr());
            ret.setStatLaunchPv(tradeFactorBaseDo.getLaunchPv());
            ret.setStatArpu(tradeFactorBaseDo.getArpu());
            ret.setStatEcpm(tradeFactorBaseDo.getStatEcpm());
            ret.setCpm(tradeFactorBaseDo.getCpm());
        }
        ret.setFactor(factor);
        ret.setExploreType(exploreType);
        ret.setIsColdStart(isColdStart);
        ret.setIdeaId(adIdeaDo.getIdeaId());
        ret.setBidMode(adIdeaDo.getBidMode());
        ret.setRoi(adIdeaDo.getRoi());
        ret.setCpc(adIdeaDo.getCpc());
        ret.setDirectCpc(adIdeaDo.getDirectCpc());
        ret.setPriceType(adIdeaDo.getPriceType());
        ret.setAppId(adxAppReqDo.getAppId());
        ret.setSlotId(adxAppReqDo.getSlotId());
        ret.setPmpType(adxAppReqDo.getPmpType());
        ret.setPmpPrice(adxAppReqDo.getPmpPrice());
        ret.setBasePrice(adxAppReqDo.getBasePrice());
        ret.setGroupTag(adxAppReqDo.getGroupTag());
    }

    public static void getPriceExploreFactor(AdxBidReq adxBidReq, AdxBidRet ret) {
        double priceFactor;
        Integer expTag = adxBidReq.getAdxExploreDo().getExpTag();
        Double exploreFlowRate = adxBidReq.getAdxExploreDo().getExploreFlowRate();
        if (exploreFlowRate == null) {
            SamplerLog.info((String)"priceExploreExpTag{} ,exploreFlowRate is null", (Object[])new Object[]{adxBidReq.getAdxExploreDo().getExpTag()});
            exploreFlowRate = 0.1;
        }
        double expRate = 0.02 / exploreFlowRate;
        double baseRate = Math.max(1.0 - 5.0 * expRate, 0.0);
        double rand = adxBidReq.getAdxExploreDo().getRandomFactor();
        LinkedHashMap<String, Double> rateMap = new LinkedHashMap<String, Double>();
        if (expTag == 2) {
            int start = priceExploreLevelEnum.profitLevelStart.getIndex();
            int end = priceExploreLevelEnum.profitLevelEnd.getIndex();
            for (int i = start; i <= end; ++i) {
                rateMap.put(i + "", start == i ? baseRate : expRate);
            }
            String level = AdxBid.doubleMap(rateMap, rand);
            assert (level != null);
            double defaultValue = level.equals(start + "") ? 2.0 : 2.0 + ((double)Integer.parseInt(level) - (double)(end + start + 1) / 2.0) * 0.5;
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault(level, defaultValue);
            ret.setPriceFactor(priceFactor);
            ret.setLevel(level);
        } else {
            int start = priceExploreLevelEnum.consumeLevelStart.getIndex();
            int end = priceExploreLevelEnum.consumeLevelEnd.getIndex();
            for (int i = start; i <= end; ++i) {
                rateMap.put(i + "", start == i ? baseRate : expRate);
            }
            String level = AdxBid.doubleMap(rateMap, rand);
            assert (level != null);
            double defaultValue = level.equals(start + "") ? 2.0 : 2.0 + ((double)Integer.parseInt(level) - (double)(end + start + 1) / 2.0) * 0.5;
            priceFactor = adxBidReq.getAdxExploreDo().getFactorExploreMap().getOrDefault(level, defaultValue);
            ret.setPriceFactor(priceFactor);
            ret.setLevel(level);
        }
        if (Math.random() < 0.01) {
            logger.info("priceExploreExpTag{} ,level{}, priceFactor{}, exploreFlowRate{}, appId{}, slotId{}, factorExploreMap{}, rand{}", new Object[]{adxBidReq.getAdxExploreDo().getExpTag(), ret.getLevel(), priceFactor, exploreFlowRate, adxBidReq.getAppId(), adxBidReq.getSlotId(), adxBidReq.getAdxExploreDo().getFactorExploreMap(), rand});
        }
    }

    public static String doubleMap(Map<String, Double> map, double rand) {
        if (AssertUtil.isEmpty(map)) {
            logger.warn("priceExploreExp mapSample param is invalid, params invalid");
            return null;
        }
        double w = 0.0;
        try {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!(rand <= (w += entry.getValue().doubleValue()))) continue;
                return entry.getKey();
            }
        }
        catch (Exception e) {
            logger.error("priceExploreExp mapSample happened error: ", (Throwable)e);
        }
        return null;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return ctr * cpc * exploreFactor * 1000.0 * 100.0;
        }
        return ctr * cpc * factor * 1000.0 * 100.0;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, double factor, Double roi, Integer expTag, double exploreFactor, boolean expSwitch) {
        if (expTag >= 2 && !expSwitch) {
            return DataUtil.division((Double)(ctr * algoCpcPrice * exploreFactor * 1000.0), (Double)roi, (int)3);
        }
        return DataUtil.division((Double)(ctr * algoCpcPrice * factor * 1000.0), (Double)roi, (int)3);
    }

    public static Double getRoiPrice(Double ctr, double factor, Double launchPv, Double arpu, Double mixArpu, Double roi, Integer expTag, double exploreFactor, boolean expSwitch, Integer groupTag) {
        if (expTag >= 2 && !expSwitch) {
            if (groupTag == 1) {
                return ctr * launchPv * mixArpu * exploreFactor / roi * 1000.0;
            }
            return ctr * launchPv * arpu * exploreFactor / roi * 1000.0;
        }
        if (groupTag == 1) {
            return ctr * launchPv * mixArpu * factor / roi * 1000.0;
        }
        return ctr * launchPv * arpu * factor / roi * 1000.0;
    }

    public static Double getRoiPrice(Double ctr, Double launchPv, Double arpu, Double roi, double factor) {
        return ctr * launchPv * arpu * factor * 1000.0 / roi;
    }

    public static Double getCpcPrice(Double ctr, Double cpc, double factor) {
        return ctr * cpc * factor * 1000.0 * 100.0;
    }

    public static Double getDirectPrice(Double ctr, Double algoCpcPrice, Double roi, double factor) {
        return ctr * algoCpcPrice * factor * 1000.0 / roi;
    }

    public static boolean valid(AdxBidReq adxBidReq) {
        boolean ret = true;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxBidReq, adxBidReq.getPreCtr(), adxBidReq.getPriceType()})) {
            return false;
        }
        if (adxBidReq.getPriceType() == 1) {
            if (adxBidReq.getBidMode() == null) {
                return false;
            }
            ret = adxBidReq.getBidMode() == 1 ? adxBidReq.getRoi() != null && adxBidReq.getPreLaunchPv() != null : adxBidReq.getCpc() != null;
        } else if (adxBidReq.getPriceType() == 2) {
            ret = adxBidReq.getDirectCpc() != null && adxBidReq.getRoi() != null;
        }
        return ret;
    }

    public static void printBidReq(AdxBidReq adxBidReq) {
        if (Math.random() < 0.1) {
            logger.info("bidRequestDo2 is not valid, groupId:{}, resourceId:{}, ideaId:{}, appId:{}, priceType:{}, bidMode:{}, preCtr:{}, roi:{}, preLaunchPv:{}, cpc:{}, directCpc:{}", new Object[]{adxBidReq.getGroupId(), adxBidReq.getResId(), adxBidReq.getIdeaId(), adxBidReq.getAppId(), adxBidReq.getPriceType(), adxBidReq.getBidMode(), adxBidReq.getPreCtr(), adxBidReq.getRoi(), adxBidReq.getPreLaunchPv(), adxBidReq.getCpc(), adxBidReq.getDirectCpc()});
        }
    }

    public static Double getRankScore(Double price, Double statEcpm, boolean isConfidence) {
        Double rankScore = !isConfidence ? price * (1.0 + 2.0 * Math.random()) : price;
        rankScore = MathUtil.mean((Double)rankScore, (Double)statEcpm, (Double)0.7);
        return rankScore;
    }

    public static Double getRankScore2(Double price, Double statEcpm, boolean isConfidence) {
        Double rankScore = !isConfidence ? price * (1.0 + 1.0 * Math.random()) : price;
        rankScore = MathUtil.mean((Double)rankScore, (Double)statEcpm, (Double)0.7);
        return rankScore;
    }
}

