/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.recall;

import cn.com.duiba.nezha.alg.alg.recall.data.CandidateDto;
import cn.com.duiba.nezha.alg.alg.recall.data.RecallResultDto;
import cn.com.duiba.nezha.alg.alg.recall.enums.RecallerEnum;
import cn.com.duiba.nezha.alg.alg.recall.params.CombineParam;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecallCombination {
    private static final Logger log = LoggerFactory.getLogger(RecallCombination.class);

    public static List<CandidateDto> topK(List<CandidateDto> candidateDtos, RecallerEnum recallerEnum, CombineParam combineParam) {
        if (recallerEnum.isScored()) {
            candidateDtos.sort(Comparator.comparing(CandidateDto::getScore).reversed());
            List<CandidateDto> candidateDtosTopk = candidateDtos.subList(0, Math.min(combineParam.getRecallNumMap().getOrDefault(recallerEnum.getId(), 0), candidateDtos.size()));
            return candidateDtosTopk;
        }
        for (CandidateDto candidateDto : candidateDtos) {
            candidateDto.setScore(Math.random());
        }
        candidateDtos.sort(Comparator.comparing(CandidateDto::getScore).reversed());
        List<CandidateDto> candidateDtosTopk = candidateDtos.subList(0, Math.min(combineParam.getRecallNumMap().getOrDefault(recallerEnum.getId(), 0), candidateDtos.size()));
        return candidateDtosTopk;
    }

    public static Map<RecallerEnum, List<CandidateDto>> selectSome(Map<RecallerEnum, List<CandidateDto>> rawRecallerListMap, CombineParam combineParam) {
        HashMap<RecallerEnum, List<CandidateDto>> selectedListMap = new HashMap<RecallerEnum, List<CandidateDto>>();
        for (Map.Entry<RecallerEnum, List<CandidateDto>> recallerEnumListEntry : rawRecallerListMap.entrySet()) {
            List<Object> midCandidateDtoList = new ArrayList();
            try {
                midCandidateDtoList = RecallCombination.topK(recallerEnumListEntry.getValue(), recallerEnumListEntry.getKey(), combineParam);
            }
            catch (Exception e) {
                log.error("combine ", (Throwable)e);
            }
            selectedListMap.put(recallerEnumListEntry.getKey(), midCandidateDtoList);
        }
        return selectedListMap;
    }

    public static List<RecallResultDto> combineRecallResult(Map<RecallerEnum, List<CandidateDto>> rawRecallerListMap, CombineParam combineParam) {
        Map<RecallerEnum, List<CandidateDto>> recallerListMap = RecallCombination.selectSome(rawRecallerListMap, combineParam);
        HashMap midResultMap = new HashMap();
        for (Map.Entry<RecallerEnum, List<CandidateDto>> recallerEnumListEntry : recallerListMap.entrySet()) {
            for (CandidateDto candidateDto : recallerEnumListEntry.getValue()) {
                if (midResultMap.getOrDefault(candidateDto.getKey(), null) == null) {
                    HashMap<Integer, Double> tempMap = new HashMap<Integer, Double>();
                    tempMap.put(recallerEnumListEntry.getKey().getId(), candidateDto.getScore());
                    midResultMap.put(candidateDto.getKey(), tempMap);
                    continue;
                }
                ((Map)midResultMap.get(candidateDto.getKey())).put(recallerEnumListEntry.getKey().getId(), candidateDto.getScore());
            }
        }
        ArrayList<RecallResultDto> recallResultDtos = new ArrayList<RecallResultDto>();
        for (String adpk : midResultMap.keySet()) {
            RecallResultDto recallResultDto = new RecallResultDto();
            recallResultDto.setAdPkOnce(adpk);
            recallResultDto.setScoreMap((Map)midResultMap.get(adpk));
            recallResultDtos.add(recallResultDto);
        }
        return recallResultDtos;
    }

    public static void main(String[] args) {
        String pkStr = "73672_178993,71121_173168,65521_176061,68810_178437,49829_178811,73041_177565,67320_177930,67320_178039,68837_178357,62556_177938,67320_179069,72917_177183,73524_0,72764_177427,68810_177405,68810_178808,67320_178976,72260_178946,73639_0,73526_0,73363_0,72917_177492,68810_173191,68810_175292,72093_177812";
        List<String> strList = Arrays.asList(pkStr.split(","));
        ArrayList<CandidateDto> candidateDtos = new ArrayList<CandidateDto>();
        for (String s : strList) {
            CandidateDto candidateDto = new CandidateDto();
            candidateDto.setAdPkOnce(s);
            candidateDto.setScore(Math.random());
            candidateDtos.add(candidateDto);
        }
        CombineParam combineParam = new CombineParam();
        combineParam.setRecallNumMap((Map<Integer, Integer>)ImmutableMap.of((Object)2, (Object)10, (Object)3, (Object)11));
        HashMap<RecallerEnum, List<CandidateDto>> recallerEnumListMap = new HashMap<RecallerEnum, List<CandidateDto>>();
        recallerEnumListMap.put(RecallerEnum.HUMAN, candidateDtos);
        ArrayList<CandidateDto> candidateDtos1 = new ArrayList<CandidateDto>();
        for (String s : strList) {
            CandidateDto candidateDto = new CandidateDto();
            candidateDto.setAdPkOnce(s);
            candidateDto.setScore(Math.random());
            candidateDtos1.add(candidateDto);
        }
        recallerEnumListMap.put(RecallerEnum.DSSM, candidateDtos1);
        List<RecallResultDto> a = RecallCombination.combineRecallResult(recallerEnumListMap, combineParam);
        System.out.println(a);
    }
}

