package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.*;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FilterReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FilterRetDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public class FlowFilterAlg {

    private static final Logger logger = LoggerFactory.getLogger(FlowFilterAlg.class);



    /**
     * 1.构建流量静态特征，无计划创意特征
     */
    public static Map<String,String> getStaticFeatureMap(AdxFeatureDo adxFeatureDo, AdxStatsDo resoAppStats) {

        AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
        adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
        adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
        adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());

        if(AssertUtil.isEmpty(adxFeatureDo)) {
            logger.warn("FlowFilterAlg.getStaticFeatureMap adxFeatureDo is not valid");
        }

        Map<String,String> featureMap = AdxFeatureParse.generateFeatureMapStatic(adxFeatureDo);
        return featureMap;
    }


    /**
     * 2.流量初筛ctr预估
     * model: ctrModel模型, key为TAE:ALGBID:MODEL:adx_mid_ftrl_fm_ctr_v101
     * predictType：PredictType.CTR
     */
    public static Double predict(Map<String,String> staticFeatureMap, Model model, PredictType predictType) throws Exception {

        Double ret = null;

        if(AssertUtil.isAnyEmpty(staticFeatureMap, model, predictType)) {
            logger.warn("FlowFilterAlg.predict params is not valid featureMap:{},predictType:{}", JSON.toJSONString(staticFeatureMap), JSON.toJSONString(predictType));
            return ret;
        }

        Map<FeatureIndex, FeatureMapDo> featureMap = new HashMap<>();
        FeatureIndex featureIndex = new FeatureIndex(1L, 1L);
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(staticFeatureMap);
        featureMap.put(featureIndex, featureMapDo);

        if (PredictType.CTR.equals(predictType)) {
            Map<FeatureIndex, Double> preMap = model.predictCtr(featureMap);

            if (AssertUtil.isEmpty(preMap)) {
                logger.warn("FlowFilterAlg.predict preMap is null");
                return ret;
            }

            ret = preMap.get(featureIndex);
        }
        return ret;
    }


    /**
     * 3.流量初筛
     */
    public static FilterRetDo getFilter(FilterReqDo filterReqDo) {

        FilterRetDo ret = new FilterRetDo();
        try {
            ret = null;

        } catch (Exception e) {
            logger.error("FlowFilterAlg.getFilter", e);
        }
        return ret;
    }







}
